/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.renderer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.renderer.CacheableBlock;
import org.jplot2d.renderer.ImageAssemblyInfo;
import org.jplot2d.renderer.ImageFactory;
import org.jplot2d.renderer.Renderer;
import org.jplot2d.renderer.RenderingFinishedEvent;
import org.jplot2d.renderer.RenderingFinishedListener;

public abstract class ImageRenderer
extends Renderer {
    private static final int cores = Runtime.getRuntime().availableProcessors();
    protected static final Executor COMPONENT_RENDERING_POOL_EXECUTOR = new ThreadPoolExecutor(1, cores, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new RendererThreadFactory());
    protected static final Executor COMPONENT_RENDERING_CALLER_RUN_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };
    protected final Executor executor;
    protected final ImageFactory imageFactory;
    private ImageAssemblyInfo compCachedFutureMap = new ImageAssemblyInfo();
    protected long fsn;
    private final List<RenderingFinishedListener> renderingFinishedListenerList = Collections.synchronizedList(new ArrayList());

    protected ImageRenderer(ImageFactory imageFactory) {
        this(imageFactory, COMPONENT_RENDERING_POOL_EXECUTOR);
    }

    public ImageRenderer(ImageFactory imageFactory, Executor executor) {
        this.imageFactory = imageFactory;
        this.executor = executor;
    }

    @Override
    public void render(ComponentEx comp, List<CacheableBlock> cacheBlockList) {
        BufferedImage result;
        Rectangle bounds = ImageRenderer.getDeviceBounds(comp);
        if (cacheBlockList.size() == 0) {
            result = null;
        } else if (cacheBlockList.size() == 1) {
            result = this.renderCacheableBlock(bounds, cacheBlockList.get(0));
        } else {
            ImageAssemblyInfo ainfo = this.runCompRender(this.executor, cacheBlockList);
            result = this.assembleResult(this.fsn, bounds, ainfo);
        }
        this.fireRenderingFinished(this.fsn++, result);
    }

    protected void fireRenderingFinished(long sn, BufferedImage img) {
        RenderingFinishedListener[] ls;
        if (img == null) {
            return;
        }
        for (RenderingFinishedListener lsnr : ls = this.renderingFinishedListenerList.toArray(new RenderingFinishedListener[0])) {
            try {
                lsnr.renderingFinished(new RenderingFinishedEvent(sn, img));
            }
            catch (Exception e) {
                logger.warn("RenderingFinishedListener Error", (Throwable)e);
            }
        }
    }

    public void addRenderingFinishedListener(RenderingFinishedListener listener) {
        this.renderingFinishedListenerList.add(listener);
    }

    public void removeRenderingFinishedListener(RenderingFinishedListener listener) {
        this.renderingFinishedListenerList.remove(listener);
    }

    protected final BufferedImage renderCacheableBlock(Rectangle bounds, CacheableBlock cb) {
        if (Thread.interrupted()) {
            return null;
        }
        if (bounds.width <= 0 || bounds.height <= 0) {
            return null;
        }
        BufferedImage image = this.imageFactory.createImage(bounds.width, bounds.height);
        Graphics2D g = image.createGraphics();
        g.translate(-bounds.x, -bounds.y);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        for (ComponentEx comp : cb.getSubcomps()) {
            if (Thread.interrupted()) {
                g.dispose();
                this.imageFactory.cacheImage(image);
                return null;
            }
            comp.draw(g);
        }
        g.dispose();
        return image;
    }

    protected final ImageAssemblyInfo runCompRender(Executor executor, List<CacheableBlock> cacheBlockList) {
        ImageAssemblyInfo ainfo = new ImageAssemblyInfo();
        for (CacheableBlock cb : cacheBlockList) {
            ComponentEx comp = cb.getUid();
            ComponentEx ccopy = cb.getComp();
            if (!ccopy.isRedrawNeeded() && this.compCachedFutureMap.contains(comp)) {
                ainfo.put(comp, this.compCachedFutureMap.getBounds(comp), this.compCachedFutureMap.getFuture(comp));
                continue;
            }
            Rectangle bounds = ImageRenderer.getDeviceBounds(ccopy);
            CompRenderCallable compRenderCallable = new CompRenderCallable(cb, this.imageFactory, bounds);
            FutureTask<BufferedImage> crtask = new FutureTask<BufferedImage>(compRenderCallable);
            executor.execute(crtask);
            ainfo.put(comp, bounds, crtask);
        }
        this.compCachedFutureMap = ainfo;
        return ainfo;
    }

    protected boolean isFutureCached(ComponentEx comp, Future<BufferedImage> future) {
        return this.compCachedFutureMap.getFuture(comp) == future;
    }

    protected BufferedImage assembleResult(long sn, Rectangle bounds, ImageAssemblyInfo ainfo) {
        BufferedImage image = this.imageFactory.createImage(bounds.width, bounds.height);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.translate(-bounds.x, -bounds.y);
        try {
            for (ComponentEx c : ainfo.componentSet()) {
                Rectangle cbounds = ainfo.getBounds(c);
                BufferedImage bi = ainfo.getFuture(c).get();
                g.drawImage((Image)bi, cbounds.x, cbounds.y, null);
            }
            g.dispose();
            return image;
        }
        catch (CancellationException e) {
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            logger.warn("Renderer exception, drop R." + sn, (Throwable)e);
        }
        this.imageFactory.cacheImage(image);
        return null;
    }

    static {
        logger.info("Max Renderer Threads: " + cores);
    }

    private static class CompRenderCallable
    implements Callable<BufferedImage> {
        private final CacheableBlock cacheableBlock;
        private final ImageFactory imageFactory;
        private final Rectangle bounds;

        public CompRenderCallable(CacheableBlock cacheableBlock, ImageFactory imageFactory, Rectangle bounds) {
            this.cacheableBlock = cacheableBlock;
            this.imageFactory = imageFactory;
            this.bounds = bounds;
        }

        @Override
        public BufferedImage call() throws Exception {
            if (Thread.interrupted()) {
                return null;
            }
            BufferedImage image = this.imageFactory.createTransparentImage(this.bounds.width, this.bounds.height);
            Graphics2D g = image.createGraphics();
            g.translate(-this.bounds.x, -this.bounds.y);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            for (ComponentEx comp : this.cacheableBlock.getSubcomps()) {
                if (Thread.interrupted()) {
                    g.dispose();
                    return null;
                }
                comp.draw(g);
            }
            g.dispose();
            return image;
        }
    }

    private static class RendererThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);

        RendererThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "JPlot2d-renderer-" + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

