/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.notice;

import org.jplot2d.notice.AbstractNotifier;
import org.jplot2d.notice.Notice;
import org.jplot2d.notice.NoticeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingNotifier
extends AbstractNotifier {
    private static final LoggingNotifier instance = new LoggingNotifier();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.jplot2d.notice");

    private LoggingNotifier() {
    }

    public static LoggingNotifier getInstance() {
        return instance;
    }

    @Override
    public void showNotices(NoticeType type) {
        LoggingNotifier.logNotices(this.notices.toArray(new Notice[this.notices.size()]));
    }

    public static void logNotices(Notice[] notices) {
        if (notices.length == 0) {
            return;
        }
        if (notices.length == 1) {
            LOGGER.info("Notice: " + notices[0]);
        } else {
            StringBuilder sb = new StringBuilder("Multiple Notices:\n");
            for (Notice wm : notices) {
                sb.append("\t");
                sb.append(wm.getMessage());
                sb.append("\n");
            }
            LOGGER.info(sb.toString());
        }
    }
}

