/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jplot2d.interaction.InteractionManager;
import org.jplot2d.interaction.InteractionMode;
import org.jplot2d.interaction.MouseBehavior;
import org.jplot2d.interaction.MouseButtonCombinationEnablity;
import org.jplot2d.interaction.MousePreference;

public class StringMousePreference
implements MousePreference {
    protected final InteractionManager _imanager;
    private Integer _clickThreshold;
    private final Map<InteractionMode, Map<MouseBehavior, MouseButtonCombinationEnablity>> _bindingMap;

    public StringMousePreference(InteractionManager imanager) {
        InteractionMode[] modes;
        this._imanager = imanager;
        this._bindingMap = new LinkedHashMap<InteractionMode, Map<MouseBehavior, MouseButtonCombinationEnablity>>();
        for (InteractionMode mode : modes = imanager.getModes()) {
            LinkedHashMap<MouseBehavior, Object> behaviorMap = new LinkedHashMap<MouseBehavior, Object>();
            this._bindingMap.put(mode, behaviorMap);
            for (MouseBehavior behavior : mode.getAvailableMouseBehaviors()) {
                behaviorMap.put(behavior, null);
            }
        }
    }

    public void loadBindingPreference(String bindingStr) {
        InteractionMode[] modes;
        if (bindingStr == null) {
            return;
        }
        Properties prop = new Properties();
        try {
            prop.load(new StringReader(bindingStr));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        for (InteractionMode mode : modes = this._imanager.getModes()) {
            Map<MouseBehavior, MouseButtonCombinationEnablity> behaviorMap = this._bindingMap.get(mode);
            for (MouseBehavior behavior : mode.getAvailableMouseBehaviors()) {
                String bkey = mode.getName() + "." + behavior.getName();
                String bstr = (String)prop.get(bkey);
                if (bstr == null || bstr.length() == 0) {
                    behaviorMap.put(behavior, new MouseButtonCombinationEnablity(null, false));
                    continue;
                }
                MouseButtonCombinationEnablity mbce = MouseButtonCombinationEnablity.valueOf(bstr);
                behaviorMap.put(behavior, mbce);
            }
        }
    }

    public static String encodeBindingPreference(MousePreference prefs) {
        Properties prop = new Properties();
        for (InteractionMode mode : prefs.getModes()) {
            for (MouseBehavior behavior : prefs.getBehaviorsInMode(mode)) {
                MouseButtonCombinationEnablity mbce = prefs.getMouseButtonCombinationEnablity(mode, behavior);
                if (mbce == null) continue;
                String key = mode.getName() + "." + behavior.getName();
                prop.put(key, mbce.toString());
            }
        }
        StringWriter writer = new StringWriter();
        try {
            prop.store(writer, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    @Override
    public Integer getClickThreshold() {
        return this._clickThreshold;
    }

    public void setClickThreshold(Integer threshold) {
        this._clickThreshold = threshold;
    }

    @Override
    public InteractionMode[] getModes() {
        return this._bindingMap.keySet().toArray(new InteractionMode[0]);
    }

    @Override
    public MouseBehavior[] getBehaviorsInMode(InteractionMode mode) {
        Map<MouseBehavior, MouseButtonCombinationEnablity> mapinmode = this._bindingMap.get(mode);
        return mapinmode.keySet().toArray(new MouseBehavior[0]);
    }

    @Override
    public MouseButtonCombinationEnablity getMouseButtonCombinationEnablity(InteractionMode mode, MouseBehavior behavior) {
        Map<MouseBehavior, MouseButtonCombinationEnablity> mapinmode = this._bindingMap.get(mode);
        return mapinmode.get(behavior);
    }
}

