/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.util.HashMap;
import java.util.Map;
import org.jplot2d.interaction.InteractionMode;
import org.jplot2d.interaction.MouseBehavior;
import org.jplot2d.interaction.MouseButtonCombinationEnablity;
import org.jplot2d.interaction.MousePreference;
import org.jplot2d.interaction.PlotInteractionManager;

public class PlotDefaultMousePreference
implements MousePreference {
    private static PlotDefaultMousePreference instance = new PlotDefaultMousePreference();
    private static final Integer DEFAULT_CLICK_THRESHOLD = 3;
    private final Map<InteractionMode, Map<MouseBehavior, MouseButtonCombinationEnablity>> _bindingMap = new HashMap<InteractionMode, Map<MouseBehavior, MouseButtonCombinationEnablity>>();

    public static PlotDefaultMousePreference getInstance() {
        return instance;
    }

    private PlotDefaultMousePreference() {
        this.initDefault();
    }

    private void initDefault() {
        InteractionMode[] modes;
        PlotInteractionManager manager = PlotInteractionManager.getInstance();
        for (InteractionMode mode : modes = PlotInteractionManager.getInstance().getModes()) {
            this._bindingMap.put(mode, new HashMap());
        }
        MouseButtonCombinationEnablity moveBA = new MouseButtonCombinationEnablity(0, 0, 0);
        MouseButtonCombinationEnablity moveCoordinatesBA = new MouseButtonCombinationEnablity(64, 0, 0);
        MouseButtonCombinationEnablity clickBA = new MouseButtonCombinationEnablity(0, 1, 1);
        MouseButtonCombinationEnablity ctlClickBA = new MouseButtonCombinationEnablity(128, 1, 1);
        MouseButtonCombinationEnablity metaClickBA = new MouseButtonCombinationEnablity(256, 1, 1);
        MouseButtonCombinationEnablity dragBA = new MouseButtonCombinationEnablity(1024, 1, 1);
        MouseButtonCombinationEnablity middleDragBA = new MouseButtonCombinationEnablity(2048, 1, 2);
        MouseButtonCombinationEnablity wheelBA = new MouseButtonCombinationEnablity(0, 0, 0);
        MouseButtonCombinationEnablity ctlWheelBA = new MouseButtonCombinationEnablity(128, 0, 0);
        MouseButtonCombinationEnablity metaWheelBA = new MouseButtonCombinationEnablity(256, 0, 0);
        this.addBinding(manager.defaultMode, manager.activeComponentBehavior, moveBA);
        this.addBinding(manager.defaultMode, manager.showCoordinatesTooltipBehavior, moveCoordinatesBA);
        this.addBinding(manager.defaultMode, manager.moveComponentBehavior, dragBA);
        this.addBinding(manager.defaultMode, manager.marqueeZoomBehavior, dragBA);
        this.addBinding(manager.defaultMode, manager.wheelZoomBehavior, wheelBA);
        this.addBinding(manager.defaultMode, manager.panBehavior, middleDragBA);
        this.addBinding(manager.defaultMode, manager.axisRangeZoomBehavior, dragBA);
        this.addBinding(manager.defaultMode, manager.axisWheelZoomBehavior, wheelBA);
        this.addBinding(manager.defaultMode, manager.axisPanBehavior, middleDragBA);
        if (this.isMacOSX()) {
            this.addBinding(manager.defaultMode, manager.adaptiveZoomBehavior, metaClickBA);
            this.addBinding(manager.defaultMode, manager.wheelFinerZoomBehavior, metaWheelBA);
            this.addBinding(manager.defaultMode, manager.axisAdaptiveZoomBehavior, metaClickBA);
            this.addBinding(manager.defaultMode, manager.axisWheelFinerZoomBehavior, metaWheelBA);
        } else {
            this.addBinding(manager.defaultMode, manager.adaptiveZoomBehavior, ctlClickBA);
            this.addBinding(manager.defaultMode, manager.wheelFinerZoomBehavior, ctlWheelBA);
            this.addBinding(manager.defaultMode, manager.axisAdaptiveZoomBehavior, ctlClickBA);
            this.addBinding(manager.defaultMode, manager.axisWheelFinerZoomBehavior, ctlWheelBA);
        }
    }

    private void addBinding(InteractionMode mode, MouseBehavior behavior, MouseButtonCombinationEnablity mba) {
        Map<MouseBehavior, MouseButtonCombinationEnablity> mapinmode = this._bindingMap.get(mode);
        mapinmode.put(behavior, mba);
    }

    private boolean isMacOSX() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("mac os x");
    }

    @Override
    public Integer getClickThreshold() {
        return DEFAULT_CLICK_THRESHOLD;
    }

    @Override
    public InteractionMode[] getModes() {
        return this._bindingMap.keySet().toArray(new InteractionMode[0]);
    }

    @Override
    public MouseBehavior[] getBehaviorsInMode(InteractionMode mode) {
        Map<MouseBehavior, MouseButtonCombinationEnablity> mapinmode = this._bindingMap.get(mode);
        return mapinmode.keySet().toArray(new MouseBehavior[0]);
    }

    @Override
    public MouseButtonCombinationEnablity getMouseButtonCombinationEnablity(InteractionMode mode, MouseBehavior behavior) {
        Map<MouseBehavior, MouseButtonCombinationEnablity> mapinmode = this._bindingMap.get(mode);
        return mapinmode.get(behavior);
    }
}

