/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.Plot;
import org.jplot2d.env.BatchToken;
import org.jplot2d.env.PlotEnvironment;
import org.jplot2d.interaction.InteractionModeHandler;
import org.jplot2d.interaction.MouseDragBehaviorHandler;
import org.jplot2d.interaction.MousePanBehavior;
import org.jplot2d.notice.UINoticeType;

public class MousePanHandler
extends MouseDragBehaviorHandler<MousePanBehavior> {
    private Plot plot;
    private int oldX;
    private int oldY;

    public MousePanHandler(MousePanBehavior behavior, InteractionModeHandler handler) {
        super(behavior, handler);
    }

    @Override
    public boolean canStartDargging(int x, int y) {
        PlotEnvironment env = (PlotEnvironment)this.handler.getValue("PLOT_ENV");
        this.plot = env.getPlotAt(new Point(x, y));
        return this.plot != null;
    }

    @Override
    public void draggingStarted(int x, int y) {
        this.oldX = x;
        this.oldY = y;
    }

    @Override
    public void draggingTo(int x, int y) {
        int xoff = x - this.oldX;
        int yoff = y - this.oldY;
        this.oldX = x;
        this.oldY = y;
        PlotEnvironment env = (PlotEnvironment)this.handler.getValue("PLOT_ENV");
        BatchToken token = env.beginBatch("Pan");
        Dimension2D csize = this.plot.getContentSize();
        Rectangle2D.Double cbnds = new Rectangle2D.Double(0.0, 0.0, csize.getWidth(), csize.getHeight());
        Rectangle2D plotRect = this.plot.getPaperTransform().getPtoD(cbnds).getBounds2D();
        double npxStart = (double)(-xoff) / plotRect.getWidth();
        double npxEnd = 1.0 + npxStart;
        double npyStart = (double)yoff / plotRect.getHeight();
        double npyEnd = 1.0 + npyStart;
        this.plot.zoomXRange(npxStart, npxEnd);
        this.plot.zoomYRange(npyStart, npyEnd);
        env.endBatch(token, UINoticeType.getInstance());
    }

    @Override
    public void draggingFinished(int x, int y) {
    }

    @Override
    public void draggingCancelled() {
    }
}

