/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jplot2d.element.MovableComponent;
import org.jplot2d.element.PComponent;
import org.jplot2d.interaction.InteractionModeHandler;
import org.jplot2d.interaction.InteractiveComp;
import org.jplot2d.interaction.MouseDragBehaviorHandler;
import org.jplot2d.interaction.MouseMoveComponentBehavior;
import org.jplot2d.interaction.VisualFeedbackDrawer;
import org.jplot2d.transform.PaperTransform;

public class MouseMoveComponentHandler
extends MouseDragBehaviorHandler<MouseMoveComponentBehavior>
implements PropertyChangeListener,
VisualFeedbackDrawer {
    private InteractiveComp icomp;
    private MovableComponent pcomp;
    private Shape boundsShape;
    private Point startPoint;
    private Point toPoint;

    public MouseMoveComponentHandler(MouseMoveComponentBehavior behavior, InteractionModeHandler handler) {
        super(behavior, handler);
        this.icomp = (InteractiveComp)handler.getValue("INTERACTIVE_COMP");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("ACTIVE_COMPONENT")) {
            PComponent acomp = (PComponent)evt.getNewValue();
            if (acomp instanceof MovableComponent && ((MovableComponent)acomp).isMovable()) {
                this.handler.putValue("ACTIVE_COMPONENT_MOVABLE", Boolean.TRUE);
            } else {
                this.handler.putValue("ACTIVE_COMPONENT_MOVABLE", null);
            }
        }
    }

    @Override
    public boolean canStartDargging(int x, int y) {
        Boolean movable = (Boolean)this.handler.getValue("ACTIVE_COMPONENT_MOVABLE");
        return movable != null && movable != false;
    }

    @Override
    public void draggingStarted(int x, int y) {
        this.pcomp = (MovableComponent)this.handler.getValue("ACTIVE_COMPONENT");
        this.startPoint = new Point(x, y);
        this.boundsShape = MouseMoveComponentHandler.getDeviceBounds(this.pcomp);
    }

    @Override
    public void draggingTo(int x, int y) {
        this.toPoint = new Point(x, y);
        this.icomp.repaint();
    }

    @Override
    public void draggingFinished(int x, int y) {
        if (this.startPoint.x == x && this.startPoint.y == y) {
            return;
        }
        double xoff = x - this.startPoint.x;
        double yoff = y - this.startPoint.y;
        PaperTransform pxf = this.pcomp.getParent().getPaperTransform();
        Point2D dloc = pxf.getPtoD(this.pcomp.getLocation());
        dloc.setLocation(dloc.getX() + xoff, dloc.getY() + yoff);
        Point2D newLoc = pxf.getDtoP(dloc);
        this.pcomp.setLocation(newLoc);
        this.startPoint = null;
        this.toPoint = null;
        this.icomp.repaint();
    }

    @Override
    public void draggingCancelled() {
    }

    @Override
    public void draw(Object g) {
        if (this.startPoint == null || this.toPoint == null) {
            return;
        }
        double xoff = this.toPoint.x - this.startPoint.x;
        double yoff = this.toPoint.y - this.startPoint.y;
        Shape shape = AffineTransform.getTranslateInstance(xoff, yoff).createTransformedShape(this.boundsShape);
        this.icomp.drawShape(g, Color.RED.getRGB(), shape);
    }

    private static Shape getDeviceBounds(PComponent comp) {
        return comp.getPaperTransform().getPtoD(comp.getSelectableBounds());
    }
}

