/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.Plot;
import org.jplot2d.env.BatchToken;
import org.jplot2d.env.PlotEnvironment;
import org.jplot2d.interaction.InteractionModeHandler;
import org.jplot2d.interaction.MouseMarqueeHandler;
import org.jplot2d.interaction.MouseMarqueeZoomBehavior;
import org.jplot2d.notice.UINoticeType;

public class MouseMarqueeZoomHandler
extends MouseMarqueeHandler<MouseMarqueeZoomBehavior> {
    public MouseMarqueeZoomHandler(MouseMarqueeZoomBehavior behavior, InteractionModeHandler handler) {
        super(behavior, handler);
    }

    @Override
    public boolean canStartDargging(int x, int y) {
        return true;
    }

    @Override
    protected void handleMarquee(Point startPoint, Point endPoint) {
        Rectangle zrect = new Rectangle();
        zrect.setFrameFromDiagonal(startPoint, endPoint);
        PlotEnvironment env = (PlotEnvironment)this.handler.getValue("PLOT_ENV");
        Plot plot = env.getPlotAt(startPoint);
        if (plot == null) {
            return;
        }
        BatchToken token = env.beginBatch("MarqueeZoom");
        Dimension2D csize = plot.getContentSize();
        Rectangle2D.Double cbnds = new Rectangle2D.Double(0.0, 0.0, csize.getWidth(), csize.getHeight());
        Rectangle2D plotRect = plot.getPaperTransform().getPtoD(cbnds).getBounds2D();
        double npxStart = (zrect.getX() - plotRect.getX()) / plotRect.getWidth();
        double npxEnd = (zrect.getMaxX() - plotRect.getX()) / plotRect.getWidth();
        plot.zoomXRange(npxStart, npxEnd);
        double npyStart = 1.0 - (zrect.getMaxY() - plotRect.getY()) / plotRect.getHeight();
        double npyEnd = 1.0 - (zrect.getMinY() - plotRect.getY()) / plotRect.getHeight();
        plot.zoomYRange(npyStart, npyEnd);
        env.endBatch(token, UINoticeType.getInstance());
    }
}

