/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import org.jplot2d.interaction.GenericMouseEvent;

public class MouseButtonCombination {
    private static int modifiersAllMask = 16320;
    public static final int ANY_CLICK_COUNT = 7;
    public static final int ANY_BUTTON = 15;
    private int modifiersOnMask;
    private int modifiersOffMask;
    private int clickCount;
    private int button;

    public MouseButtonCombination(int modifiers, int clickCount, int button) {
        this.modifiersOnMask = modifiers;
        this.modifiersOffMask = ~modifiers & modifiersAllMask;
        this.clickCount = clickCount;
        this.button = button;
    }

    public MouseButtonCombination(int modifiersOnMask, int modifiersOffMask, int clickCount, int button) {
        this.modifiersOnMask = modifiersOnMask;
        this.modifiersOffMask = modifiersOffMask;
        this.clickCount = clickCount;
        this.button = button;
    }

    public int getModifiers() {
        return this.modifiersOnMask;
    }

    public int getButton() {
        return this.button;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MouseButtonCombination) {
            MouseButtonCombination a = (MouseButtonCombination)obj;
            return this.modifiersOnMask == a.modifiersOnMask && this.clickCount == a.clickCount && this.button == a.button;
        }
        return false;
    }

    public int hashCode() {
        return this.button + this.modifiersOnMask + (this.clickCount << 16);
    }

    public boolean match(GenericMouseEvent e) {
        return this.match(e.getModifiers(), e.getCount(), e.getButton());
    }

    public boolean match(int modifiers, int clickCount, int button) {
        return !((modifiers & (this.modifiersOnMask | this.modifiersOffMask)) != this.modifiersOnMask || this.clickCount != 7 && this.clickCount != clickCount || this.button != 15 && this.button != button);
    }
}

