/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jplot2d.interaction.MouseBehavior;
import org.jplot2d.interaction.MouseButtonCombination;
import org.jplot2d.interaction.MouseClickBehavior;
import org.jplot2d.interaction.MouseDragBehavior;
import org.jplot2d.interaction.MouseMoveBehavior;
import org.jplot2d.interaction.MouseWheelBehavior;
import org.jplot2d.interaction.ValueChangeBehavior;

public class InteractionMode {
    private String name;
    private Set<MouseBehavior> availableBehaviors = new LinkedHashSet<MouseBehavior>();
    private Set<ValueChangeBehavior> vcBehaviors = new HashSet<ValueChangeBehavior>();
    final Map<MouseBehavior, Integer> modifiersKeyMap = new LinkedHashMap<MouseBehavior, Integer>();
    final Map<MouseBehavior, MouseButtonCombination> clickMap = new LinkedHashMap<MouseBehavior, MouseButtonCombination>();
    final Map<MouseBehavior, MouseButtonCombination> pressMap = new LinkedHashMap<MouseBehavior, MouseButtonCombination>();
    final Map<MouseBehavior, MouseButtonCombination> releaseMap = new LinkedHashMap<MouseBehavior, MouseButtonCombination>();
    final Map<MouseBehavior, MouseButtonCombination> dragMap = new LinkedHashMap<MouseBehavior, MouseButtonCombination>();
    final Map<MouseBehavior, MouseButtonCombination> moveMap = new LinkedHashMap<MouseBehavior, MouseButtonCombination>();
    final Map<MouseWheelBehavior, MouseButtonCombination> wheelMap = new LinkedHashMap<MouseWheelBehavior, MouseButtonCombination>();

    public InteractionMode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public MouseBehavior[] getAvailableMouseBehaviors() {
        return this.availableBehaviors.toArray(new MouseBehavior[0]);
    }

    public void setAvailableMouseBehaviors(MouseBehavior ... behaviors) {
        for (MouseBehavior behavior : behaviors) {
            this.availableBehaviors.add(behavior);
        }
    }

    public void setValueChangeBehaviors(ValueChangeBehavior ... feedbacks) {
        for (ValueChangeBehavior feedback : feedbacks) {
            this.vcBehaviors.add(feedback);
        }
    }

    public ValueChangeBehavior[] getValueChangeBehaviors() {
        return this.vcBehaviors.toArray(new ValueChangeBehavior[0]);
    }

    public void bindMoveBehavior(MouseMoveBehavior behavior, MouseButtonCombination mbc) {
        if (mbc == null) {
            this.moveMap.remove(behavior);
            this.modifiersKeyMap.remove(behavior);
        } else {
            this.moveMap.put(behavior, mbc);
            if (mbc.getModifiers() != 0) {
                this.modifiersKeyMap.put(behavior, mbc.getModifiers());
            }
        }
    }

    public void bindClickBehavior(MouseClickBehavior behavior, MouseButtonCombination mbc) {
        if (mbc == null) {
            this.clickMap.remove(behavior);
        } else {
            this.clickMap.put(behavior, mbc);
        }
    }

    public void bindDragBehavior(MouseDragBehavior behavior, MouseButtonCombination mbc) {
        if (mbc == null) {
            this.pressMap.remove(behavior);
            this.dragMap.remove(behavior);
            this.releaseMap.remove(behavior);
        } else {
            MouseButtonCombination pressmbc = new MouseButtonCombination(mbc.getModifiers(), mbc.getClickCount(), mbc.getButton());
            this.pressMap.put(behavior, pressmbc);
            MouseButtonCombination dragmbc = new MouseButtonCombination(mbc.getModifiers(), 7, 15);
            this.dragMap.put(behavior, dragmbc);
            MouseButtonCombination releasembc = new MouseButtonCombination(0, 0, 7, 15);
            this.releaseMap.put(behavior, releasembc);
        }
    }

    public void bindWheelBehavior(MouseWheelBehavior behavior, MouseButtonCombination mbc) {
        if (mbc == null) {
            this.wheelMap.remove(behavior);
        } else {
            MouseButtonCombination wheelmbc = new MouseButtonCombination(mbc.getModifiers(), 7, 15);
            this.wheelMap.put(behavior, wheelmbc);
        }
    }

    public String toString() {
        return this.name;
    }
}

