/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.image;

import java.awt.Dimension;
import org.jplot2d.data.ByteDataBuffer;
import org.jplot2d.data.DoubleDataBuffer;
import org.jplot2d.data.FloatDataBuffer;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.data.IntDataBuffer;
import org.jplot2d.data.ShortDataBuffer;
import org.jplot2d.image.LimitsCalculator;
import org.jplot2d.image.MinMaxCalculator;
import org.jplot2d.util.DoubleBottomNFinder;
import org.jplot2d.util.DoubleTopNFinder;
import org.jplot2d.util.FloatBottomNFinder;
import org.jplot2d.util.FloatTopNFinder;
import org.jplot2d.util.IntBottomNFinder;
import org.jplot2d.util.IntTopNFinder;
import org.jplot2d.util.ShortBottomNFinder;
import org.jplot2d.util.ShortTopNFinder;

public class PercentCalculator
implements LimitsCalculator {
    private final double percentage;

    public PercentCalculator(double percentage) {
        this.percentage = percentage;
    }

    @Override
    public double[] calcLimits(ImageDataBuffer[] dbufArray, Dimension[] sizeArray) {
        if (this.percentage == 100.0) {
            return MinMaxCalculator.calcMinMax(dbufArray, sizeArray);
        }
        int numberCount = 0;
        for (int a = 0; a < dbufArray.length; ++a) {
            numberCount = (int)((double)numberCount + dbufArray[a].countValid(sizeArray[a].width, sizeArray[a].height));
        }
        if (numberCount == 0) {
            return null;
        }
        if (numberCount == 1) {
            return MinMaxCalculator.calcMinMax(dbufArray, sizeArray);
        }
        double cutoff = (double)numberCount * (100.0 - this.percentage) / 100.0 / 2.0;
        int maxDataByes = 0;
        for (int i = 0; i < dbufArray.length; ++i) {
            int dataBytes = 0;
            if (dbufArray[i] instanceof ByteDataBuffer) {
                dataBytes = 1;
            } else if (dbufArray[i] instanceof ShortDataBuffer) {
                dataBytes = 2;
            } else if (dbufArray[i] instanceof IntDataBuffer) {
                dataBytes = 4;
            } else if (dbufArray[i] instanceof FloatDataBuffer) {
                dataBytes = 6;
            } else if (dbufArray[i] instanceof DoubleDataBuffer) {
                dataBytes = 8;
            }
            if (maxDataByes >= dataBytes) continue;
            maxDataByes = dataBytes;
        }
        switch (maxDataByes) {
            case 1: {
                return PercentCalculator.calcByteLimits(dbufArray, sizeArray, cutoff);
            }
            case 2: {
                return PercentCalculator.calcShortLimits(dbufArray, sizeArray, cutoff);
            }
            case 4: {
                return PercentCalculator.calcIntLimits(dbufArray, sizeArray, cutoff);
            }
            case 6: {
                return PercentCalculator.calcFloatLimits(dbufArray, sizeArray, cutoff);
            }
            case 8: {
                return PercentCalculator.calcDoubleLimits(dbufArray, sizeArray, cutoff);
            }
        }
        throw new IllegalArgumentException("Unsupported ImageDataBuffer");
    }

    private static double[] calcByteLimits(ImageDataBuffer[] dbufArray, Dimension[] sizeArray, double cutoff) {
        double offsetrate = (double)((int)cutoff + 1) - cutoff;
        int cutoffLess = (int)cutoff + 1;
        int cutoffMore = (int)cutoff + 2;
        int valueN = 512;
        int[] valueCounter = new int[valueN];
        for (int a = 0; a < dbufArray.length; ++a) {
            byte v;
            int j;
            int i;
            ImageDataBuffer dbuf = dbufArray[a];
            int w = sizeArray[a].width;
            int h = sizeArray[a].height;
            if (!dbuf.hasMasks()) {
                for (i = 0; i < h; ++i) {
                    for (j = 0; j < w; ++j) {
                        v = ((ByteDataBuffer)dbuf).get(i, j);
                        int n = v - -128;
                        valueCounter[n] = valueCounter[n] + 1;
                    }
                }
                continue;
            }
            for (i = 0; i < h; ++i) {
                for (j = 0; j < w; ++j) {
                    if (dbuf.isMasked(i, j)) continue;
                    v = ((ByteDataBuffer)dbuf).get(i, j);
                    int n = v - -128;
                    valueCounter[n] = valueCounter[n] + 1;
                }
            }
        }
        int bottomMax = -1;
        int bottomMax2nd = -1;
        int cutN = 0;
        block5: for (int i = 0; i < valueN; ++i) {
            if ((cutN += valueCounter[i]) >= cutoffMore) {
                bottomMax2nd = bottomMax = i + -128;
                break;
            }
            if (cutN < cutoffLess) continue;
            bottomMax2nd = i + -128;
            for (int j = i + 1; j < valueN; ++j) {
                if (valueCounter[j] <= 0) continue;
                bottomMax = j + -128;
                break block5;
            }
            break;
        }
        double lowCut = (double)bottomMax * (1.0 - offsetrate) + (double)bottomMax2nd * offsetrate;
        int topMin = 128;
        int topMin2nd = 128;
        cutN = 0;
        block7: for (int i = valueN - 1; i >= 0; --i) {
            if ((cutN += valueCounter[i]) >= cutoffMore) {
                topMin2nd = topMin = i + -128;
                break;
            }
            if (cutN < cutoffLess) continue;
            topMin2nd = i + -128;
            for (int j = i - 1; j >= 0; --j) {
                if (valueCounter[j] <= 0) continue;
                topMin = j + -128;
                break block7;
            }
            break;
        }
        double highCut = (double)topMin * (1.0 - offsetrate) + (double)topMin2nd * offsetrate;
        return new double[]{lowCut, highCut};
    }

    private static double[] calcShortLimits(ImageDataBuffer[] dbufArray, Dimension[] sizeArray, double cutoff) {
        double offsetrate = (double)((int)cutoff + 1) - cutoff;
        int cutoffMore = (int)cutoff + 2;
        short[] lowCuts = new short[cutoffMore];
        short[] highCuts = new short[cutoffMore];
        int m = -1;
        int n = -1;
        int c = 0;
        block0: for (int a = 0; a < dbufArray.length; ++a) {
            short v;
            int j;
            int i;
            ImageDataBuffer dbuf = dbufArray[a];
            int w = sizeArray[a].width;
            int h = sizeArray[a].height;
            if (!dbuf.hasMasks()) {
                for (i = 0; i < h; ++i) {
                    for (j = 0; j < w; ++j) {
                        lowCuts[c] = v = dbuf.getShort(i, j);
                        highCuts[c] = v;
                        if (++c != cutoffMore) continue;
                        m = i;
                        n = j;
                        break;
                    }
                    if (n != -1) continue block0;
                }
                continue;
            }
            for (i = 0; i < h; ++i) {
                for (j = 0; j < w; ++j) {
                    if (dbuf.isMasked(i, j)) continue;
                    lowCuts[c] = v = dbuf.getShort(i, j);
                    highCuts[c] = v;
                    if (++c != cutoffMore) continue;
                    m = i;
                    n = j;
                    break;
                }
                if (n != -1) continue block0;
            }
        }
        ShortBottomNFinder bf = new ShortBottomNFinder(lowCuts);
        ShortTopNFinder tf = new ShortTopNFinder(highCuts);
        ++n;
        for (int a = 0; a < dbufArray.length; ++a) {
            short v;
            int j;
            int i;
            ImageDataBuffer dbuf = dbufArray[a];
            int w = sizeArray[a].width;
            int h = sizeArray[a].height;
            if (!dbuf.hasMasks()) {
                for (i = m; i < h; ++i) {
                    for (j = n; j < w; ++j) {
                        v = dbuf.getShort(i, j);
                        bf.check(v);
                        tf.check(v);
                    }
                    n = 0;
                }
                continue;
            }
            for (i = m; i < h; ++i) {
                for (j = n; j < w; ++j) {
                    if (dbuf.isMasked(i, j)) continue;
                    v = dbuf.getShort(i, j);
                    bf.check(v);
                    tf.check(v);
                }
                n = 0;
            }
        }
        double lowCut = (double)bf.getMax() * (1.0 - offsetrate) + (double)bf.getMax2nd() * offsetrate;
        double highCut = (double)tf.getMin() * (1.0 - offsetrate) + (double)tf.getMin2nd() * offsetrate;
        return new double[]{lowCut, highCut};
    }

    private static double[] calcIntLimits(ImageDataBuffer[] dbufArray, Dimension[] sizeArray, double cutoff) {
        double offsetrate = (double)((int)cutoff + 1) - cutoff;
        int cutoffMore = (int)cutoff + 2;
        int[] lowCuts = new int[cutoffMore];
        int[] highCuts = new int[cutoffMore];
        int m = -1;
        int n = -1;
        int c = 0;
        block0: for (int a = 0; a < dbufArray.length; ++a) {
            int v;
            int j;
            int i;
            ImageDataBuffer dbuf = dbufArray[a];
            int w = sizeArray[a].width;
            int h = sizeArray[a].height;
            if (!dbuf.hasMasks()) {
                for (i = 0; i < h; ++i) {
                    for (j = 0; j < w; ++j) {
                        lowCuts[c] = v = dbuf.getInt(i, j);
                        highCuts[c] = v;
                        if (++c != cutoffMore) continue;
                        m = i;
                        n = j;
                        break;
                    }
                    if (n != -1) continue block0;
                }
                continue;
            }
            for (i = 0; i < h; ++i) {
                for (j = 0; j < w; ++j) {
                    if (dbuf.isMasked(i, j)) continue;
                    lowCuts[c] = v = dbuf.getInt(i, j);
                    highCuts[c] = v;
                    if (++c != cutoffMore) continue;
                    m = i;
                    n = j;
                    break;
                }
                if (n != -1) continue block0;
            }
        }
        IntBottomNFinder bf = new IntBottomNFinder(lowCuts);
        IntTopNFinder tf = new IntTopNFinder(highCuts);
        ++n;
        for (int a = 0; a < dbufArray.length; ++a) {
            int v;
            int j;
            int i;
            ImageDataBuffer dbuf = dbufArray[a];
            int w = sizeArray[a].width;
            int h = sizeArray[a].height;
            if (!dbuf.hasMasks()) {
                for (i = m; i < h; ++i) {
                    for (j = n; j < w; ++j) {
                        v = dbuf.getInt(i, j);
                        bf.check(v);
                        tf.check(v);
                    }
                    n = 0;
                }
                continue;
            }
            for (i = m; i < h; ++i) {
                for (j = n; j < w; ++j) {
                    if (dbuf.isMasked(i, j)) continue;
                    v = dbuf.getInt(i, j);
                    bf.check(v);
                    tf.check(v);
                }
                n = 0;
            }
        }
        double lowCut = (double)bf.getMax() * (1.0 - offsetrate) + (double)bf.getMax2nd() * offsetrate;
        double highCut = (double)tf.getMin() * (1.0 - offsetrate) + (double)tf.getMin2nd() * offsetrate;
        return new double[]{lowCut, highCut};
    }

    private static double[] calcFloatLimits(ImageDataBuffer[] dbufArray, Dimension[] sizeArray, double cutoff) {
        double offsetrate = (double)((int)cutoff + 1) - cutoff;
        int cutoffMore = (int)cutoff + 2;
        float[] lowCuts = new float[cutoffMore];
        float[] highCuts = new float[cutoffMore];
        int m = -1;
        int n = -1;
        int c = 0;
        block0: for (int a = 0; a < dbufArray.length; ++a) {
            float v;
            int j;
            int i;
            ImageDataBuffer dbuf = dbufArray[a];
            int w = sizeArray[a].width;
            int h = sizeArray[a].height;
            if (!dbuf.hasMasks()) {
                for (i = 0; i < h; ++i) {
                    for (j = 0; j < w; ++j) {
                        v = dbuf.getFloat(i, j);
                        if (v != v || v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY) continue;
                        lowCuts[c] = v;
                        highCuts[c] = v;
                        if (++c != cutoffMore) continue;
                        m = i;
                        n = j;
                        break;
                    }
                    if (n != -1) continue block0;
                }
                continue;
            }
            for (i = 0; i < h; ++i) {
                for (j = 0; j < w; ++j) {
                    if (dbuf.isMasked(i, j) || (v = dbuf.getFloat(i, j)) != v || v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY) continue;
                    lowCuts[c] = v;
                    highCuts[c] = v;
                    if (++c != cutoffMore) continue;
                    m = i;
                    n = j;
                    break;
                }
                if (n != -1) continue block0;
            }
        }
        FloatBottomNFinder bf = new FloatBottomNFinder(lowCuts);
        FloatTopNFinder tf = new FloatTopNFinder(highCuts);
        ++n;
        for (int a = 0; a < dbufArray.length; ++a) {
            float v;
            int j;
            int i;
            ImageDataBuffer dbuf = dbufArray[a];
            int w = sizeArray[a].width;
            int h = sizeArray[a].height;
            if (!dbuf.hasMasks()) {
                for (i = m; i < h; ++i) {
                    for (j = n; j < w; ++j) {
                        v = dbuf.getFloat(i, j);
                        if (v != v || v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY) continue;
                        bf.check(v);
                        tf.check(v);
                    }
                    n = 0;
                }
                continue;
            }
            for (i = m; i < h; ++i) {
                for (j = n; j < w; ++j) {
                    if (dbuf.isMasked(i, j) || (v = dbuf.getFloat(i, j)) != v || v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY) continue;
                    bf.check(v);
                    tf.check(v);
                }
                n = 0;
            }
        }
        double lowCut = (double)bf.getMax() * (1.0 - offsetrate) + (double)bf.getMax2nd() * offsetrate;
        double highCut = (double)tf.getMin() * (1.0 - offsetrate) + (double)tf.getMin2nd() * offsetrate;
        return new double[]{lowCut, highCut};
    }

    private static double[] calcDoubleLimits(ImageDataBuffer[] dbufArray, Dimension[] sizeArray, double cutoff) {
        double offsetrate = (double)((int)cutoff + 1) - cutoff;
        int cutoffMore = (int)cutoff + 2;
        double[] lowCuts = new double[cutoffMore];
        double[] highCuts = new double[cutoffMore];
        int m = -1;
        int n = -1;
        int c = 0;
        block0: for (int a = 0; a < dbufArray.length; ++a) {
            double v;
            int j;
            int i;
            ImageDataBuffer dbuf = dbufArray[a];
            int w = sizeArray[a].width;
            int h = sizeArray[a].height;
            if (!dbuf.hasMasks()) {
                for (i = 0; i < h; ++i) {
                    for (j = 0; j < w; ++j) {
                        v = dbuf.getDouble(i, j);
                        if (v != v || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY) continue;
                        lowCuts[c] = v;
                        highCuts[c] = v;
                        if (++c != cutoffMore) continue;
                        m = i;
                        n = j;
                        break;
                    }
                    if (n != -1) continue block0;
                }
                continue;
            }
            for (i = 0; i < h; ++i) {
                for (j = 0; j < w; ++j) {
                    if (dbuf.isMasked(i, j) || (v = dbuf.getDouble(i, j)) != v || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY) continue;
                    lowCuts[c] = v;
                    highCuts[c] = v;
                    if (++c != cutoffMore) continue;
                    m = i;
                    n = j;
                    break;
                }
                if (n != -1) continue block0;
            }
        }
        DoubleBottomNFinder bf = new DoubleBottomNFinder(lowCuts);
        DoubleTopNFinder tf = new DoubleTopNFinder(highCuts);
        ++n;
        for (int a = 0; a < dbufArray.length; ++a) {
            double v;
            int j;
            int i;
            ImageDataBuffer dbuf = dbufArray[a];
            int w = sizeArray[a].width;
            int h = sizeArray[a].height;
            if (!dbuf.hasMasks()) {
                for (i = m; i < h; ++i) {
                    for (j = n; j < w; ++j) {
                        v = dbuf.getDouble(i, j);
                        if (v != v || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY) continue;
                        bf.check(v);
                        tf.check(v);
                    }
                    n = 0;
                }
                continue;
            }
            for (i = m; i < h; ++i) {
                for (j = n; j < w; ++j) {
                    if (dbuf.isMasked(i, j) || (v = dbuf.getDouble(i, j)) != v || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY) continue;
                    bf.check(v);
                    tf.check(v);
                }
                n = 0;
            }
        }
        double lowCut = bf.getMax() * (1.0 - offsetrate) + bf.getMax2nd() * offsetrate;
        double highCut = tf.getMin() * (1.0 - offsetrate) + tf.getMin2nd() * offsetrate;
        return new double[]{lowCut, highCut};
    }
}

