/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.env;

public class UndoManager<E> {
    private int csn;
    private Entry<E> header = new Entry<Object>(null, null, null);
    private int curIdx = -1;
    private Entry<E> cur = this.header;
    private int capacity;

    public UndoManager() {
        this.header.previous = this.header;
        this.header.next = this.header.previous;
    }

    public UndoManager(int capacity) throws IllegalArgumentException {
        this();
        if (capacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + capacity);
        }
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + capacity);
        }
        this.capacity = capacity;
    }

    public int getUndoSize() {
        return this.curIdx == -1 ? 0 : this.curIdx;
    }

    public E current() {
        return this.cur == this.header ? null : (E)this.cur.element;
    }

    public int getCSN() {
        return this.csn;
    }

    public void add(E cs) {
        ++this.csn;
        if (this.curIdx == 0 && this.capacity == 0) {
            this.cur.element = cs;
            return;
        }
        this.cur = new Entry<E>(cs, this.header, this.cur);
        this.cur.previous.next = this.cur;
        this.cur.next.previous = this.cur;
        ++this.curIdx;
        while (this.curIdx > this.capacity) {
            this.header.next = this.header.next.next;
            this.header.next.next.previous = this.header;
            --this.curIdx;
        }
    }

    public boolean canUndo() {
        return this.cur != this.header && this.cur.previous != this.header;
    }

    public E undo() {
        if (this.canUndo()) {
            --this.csn;
            --this.curIdx;
            this.cur = this.cur.previous;
            return this.cur.element;
        }
        return null;
    }

    public boolean canRedo() {
        return this.cur != null && this.cur.next != this.header;
    }

    public E redo() {
        if (this.canRedo()) {
            ++this.csn;
            ++this.curIdx;
            this.cur = this.cur.next;
            return this.cur.element;
        }
        return null;
    }

    private static class Entry<E> {
        E element;
        Entry<E> next;
        Entry<E> previous;

        Entry(E element, Entry<E> next, Entry<E> previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }
    }
}

