/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.env;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jplot2d.element.PComponent;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.env.ElementAddition;
import org.jplot2d.env.PlotEnvironment;
import org.jplot2d.renderer.CacheableBlock;
import org.jplot2d.renderer.EpsExporter;
import org.jplot2d.renderer.PdfExporter;
import org.jplot2d.renderer.PngFileExporter;
import org.jplot2d.renderer.Renderer;

public class RenderEnvironment
extends PlotEnvironment {
    private final List<Renderer> rendererList = Collections.synchronizedList(new ArrayList());
    protected static volatile File defaultExportDirectory;
    private volatile File exportDirectory;

    public RenderEnvironment(boolean threadSafe) {
        super(threadSafe);
    }

    public Renderer[] getRenderers() {
        return this.rendererList.toArray(new Renderer[0]);
    }

    public boolean addRenderer(Renderer renderer) {
        return this.rendererList.add(renderer);
    }

    public boolean removeRenderer(Renderer renderer) {
        return this.rendererList.remove(renderer);
    }

    @Override
    protected void render() {
        if (!this.plotImpl.isRerenderNeeded()) {
            return;
        }
        this.plotImpl.setRerenderNeeded(false);
        for (ElementEx element : this.proxyMap.keySet()) {
            if (!(element instanceof ComponentEx)) continue;
            ((ComponentEx)element).setRedrawNeeded(false);
        }
        for (Renderer r : this.getRenderers()) {
            r.render(this.plotCopy, this.cacheBlockList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPlot(Renderer renderer) {
        this.begin();
        try {
            renderer.render(this.plotCopy, this.cacheBlockList);
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportComponent(PComponent comp, Renderer renderer) {
        this.begin();
        ComponentEx compImpl = (ComponentEx)((ElementAddition)((Object)comp)).getImpl();
        ComponentEx compCopy = (ComponentEx)this.copyMap.get(compImpl);
        ArrayList<CacheableBlock> cbs = new ArrayList<CacheableBlock>();
        for (CacheableBlock cb : this.cacheBlockList) {
            if (RenderEnvironment.isAncestor(compImpl, cb.getUid())) {
                cbs.add(cb);
                continue;
            }
            if (!cb.getSubcomps().contains(compCopy)) continue;
            ArrayList<ComponentEx> subcomps = new ArrayList<ComponentEx>();
            for (ComponentEx scomp : cb.getSubcomps()) {
                if (!RenderEnvironment.isAncestor(compCopy, scomp)) continue;
                subcomps.add(scomp);
            }
            cbs.add(new CacheableBlock(compImpl, compCopy, subcomps));
        }
        try {
            renderer.render(compCopy, cbs);
        }
        finally {
            this.end();
        }
    }

    public static String getDefaultExportDirectory() {
        return defaultExportDirectory.getAbsolutePath();
    }

    public static void setDefaultExportDirectory(String dir) {
        File dirFile;
        if (dir == null) {
            String home = System.getProperty("user.home");
            dirFile = new File(home);
        } else {
            dirFile = new File(dir);
            if (!dirFile.isDirectory()) {
                throw new IllegalArgumentException("The given dir " + dir + " is not a directory.");
            }
            if (!dirFile.isAbsolute()) {
                String home = System.getProperty("user.home");
                dirFile = new File(home, dir);
            }
        }
        defaultExportDirectory = dirFile;
    }

    public String getExportDirectory() {
        return this.exportDirectory == null ? null : this.exportDirectory.getAbsolutePath();
    }

    public void setExportDirectory(String dir) {
        File dirFile;
        if (dir == null) {
            dirFile = null;
        } else {
            dirFile = new File(dir);
            if (!dirFile.isDirectory()) {
                throw new IllegalArgumentException("The given dir " + dir + " is not a directory.");
            }
            if (!dirFile.isAbsolute()) {
                String home = System.getProperty("user.home");
                dirFile = new File(home, dir);
            }
        }
        this.exportDirectory = dirFile;
    }

    public File getExportFile(String filename) {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            File dir = this.exportDirectory == null ? defaultExportDirectory : this.exportDirectory;
            file = new File(dir, filename);
        }
        return file;
    }

    public void exportToEPS(String filename) throws IOException {
        this.exportPlot(new EpsExporter(this.getExportFile(filename)));
    }

    public void exportToPDF(String filename) throws IOException {
        this.exportPlot(new PdfExporter(this.getExportFile(filename)));
    }

    public void exportToPNG(String filename) throws IOException {
        this.exportPlot(new PngFileExporter(this.getExportFile(filename)));
    }

    static {
        RenderEnvironment.setDefaultExportDirectory(null);
    }
}

