/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jplot2d.data.XYGraphData;
import org.jplot2d.element.impl.LayerEx;
import org.jplot2d.element.impl.XYGraphEx;
import org.jplot2d.transform.Transform1D;

public class XYGraphDataChunker
implements Iterable<ChunkData> {
    private static final ThreadLocal<XYGraphDataChunker> _threadLocalBuilder = new ThreadLocal();
    private static final int CHUNK_SIZE = 1000;
    private LayerEx layer;
    private XYGraphEx graph;
    private XYGraphData graphData;
    private Rectangle2D clip;
    private Transform1D xW2D;
    private Transform1D yW2D;
    private final DataChunkIterator ite = new DataChunkIterator();

    private XYGraphDataChunker() {
    }

    private void setLineData(XYGraphEx dp) {
        this.graphData = dp.getData();
        this.layer = dp.getParent();
        this.graph = dp;
        this.calcTransformXY();
    }

    private void setClip(Rectangle2D clip) {
        this.clip = clip;
    }

    private void calcTransformXY() {
        this.xW2D = this.layer.getXAxisTransform().getNormalTransform().createTransform(this.layer.getPaperTransform().getXPtoD(0.0), this.layer.getPaperTransform().getXPtoD(this.layer.getSize().getWidth()));
        this.yW2D = this.layer.getYAxisTransform().getNormalTransform().createTransform(this.layer.getPaperTransform().getYPtoD(0.0), this.layer.getPaperTransform().getYPtoD(this.layer.getSize().getHeight()));
    }

    public DataChunkIterator iterator() {
        this.ite.reset();
        return this.ite;
    }

    private static final boolean isBigNumber(double utoD2) {
        return utoD2 <= -32768.0 || utoD2 >= 32767.0;
    }

    private static Point2D intersecate(Rectangle2D clip, Point2D a, Point2D b) {
        Line2D.Double line = new Line2D.Double(a, b);
        Point2D.Double result = null;
        double offset = 10.0;
        double slope = (b.getY() - a.getY()) / (b.getX() - a.getX());
        if (clip.intersectsLine(line)) {
            if (a.getX() < clip.getX() - offset) {
                result = new Point2D.Double(clip.getX() - offset, slope * (clip.getX() - offset - b.getX()) + b.getY());
            }
            if (a.getX() > clip.getMaxX() + offset) {
                result = new Point2D.Double(clip.getMaxX() + offset, slope * (clip.getMaxX() + offset - b.getX()) + b.getY());
            }
            if (a.getY() < clip.getY() - offset) {
                result = new Point2D.Double((clip.getY() - offset - b.getY()) / slope + b.getX(), clip.getY() - offset);
            }
            if (a.getY() > clip.getMaxY() + offset) {
                result = new Point2D.Double((clip.getMaxY() + offset - b.getY()) / slope + b.getX(), clip.getMaxY() + offset);
            }
        }
        return result;
    }

    public static XYGraphDataChunker getInstance(XYGraphEx dp, Rectangle clip) {
        XYGraphDataChunker builder = _threadLocalBuilder.get();
        if (builder == null) {
            builder = new XYGraphDataChunker();
            _threadLocalBuilder.set(builder);
        }
        builder.setLineData(dp);
        builder.setClip(clip);
        return builder;
    }

    private class DataChunkIterator
    implements Iterator<ChunkData> {
        private ChunkData _chunk = new ChunkData(1000);
        private ChunkData _nextChunk = new ChunkData(1000);
        private int i;

        private DataChunkIterator() {
        }

        private void reset() {
            this.i = 0;
            this.prepareNextChunk(this._chunk);
        }

        @Override
        public boolean hasNext() {
            return this._chunk != null && this._chunk.size > 0;
        }

        @Override
        public ChunkData next() {
            if (this._chunk.size == 0) {
                throw new NoSuchElementException();
            }
            this.prepareNextChunk(this._nextChunk);
            ChunkData result = this._chunk;
            this._chunk = this._nextChunk;
            this._nextChunk = result;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void prepareNextChunk(ChunkData data) {
            data.reset();
            while (this.i < XYGraphDataChunker.this.graphData.size()) {
                this.fillChunk(data);
                if (data.size <= 0) continue;
                break;
            }
        }

        private void fillChunk(ChunkData data) {
            while (this.i < XYGraphDataChunker.this.graphData.size() && (Double.isNaN(XYGraphDataChunker.this.graphData.getX(this.i)) || Double.isNaN(XYGraphDataChunker.this.graphData.getY(this.i)))) {
                ++this.i;
            }
            if (this.i >= XYGraphDataChunker.this.graphData.size()) {
                return;
            }
            boolean drawMark = XYGraphDataChunker.this.graph.isSymbolVisible();
            boolean haspre = false;
            double prex = Double.NaN;
            double prey = Double.NaN;
            boolean isPreBigNumber = false;
            while (this.i < XYGraphDataChunker.this.graphData.size()) {
                boolean isThisBigNumber;
                double x = XYGraphDataChunker.this.xW2D.convert(XYGraphDataChunker.this.graphData.getX(this.i));
                double y = XYGraphDataChunker.this.yW2D.convert(XYGraphDataChunker.this.graphData.getY(this.i));
                if (Double.isNaN(XYGraphDataChunker.this.graphData.getX(this.i)) || Double.isNaN(XYGraphDataChunker.this.graphData.getY(this.i))) {
                    ++this.i;
                    break;
                }
                boolean bl = isThisBigNumber = XYGraphDataChunker.isBigNumber(x) || XYGraphDataChunker.isBigNumber(y);
                if (haspre) {
                    Point2D.Double b;
                    Point2D.Double a;
                    if (isPreBigNumber) {
                        a = new Point2D.Double(x, y);
                        b = new Point2D.Double(prex, prey);
                        Point2D newb = XYGraphDataChunker.intersecate(XYGraphDataChunker.this.clip, b, a);
                        if (newb != null) {
                            data.addPoint((float)newb.getX(), (float)newb.getY());
                        }
                    }
                    if (isThisBigNumber) {
                        a = new Point2D.Double(x, y);
                        b = new Point2D.Double(prex, prey);
                        Point2D newa = XYGraphDataChunker.intersecate(XYGraphDataChunker.this.clip, a, b);
                        if (newa != null) {
                            data.addPoint((float)newa.getX(), (float)newa.getY());
                        }
                    }
                } else {
                    haspre = true;
                }
                prex = x;
                prey = y;
                isPreBigNumber = isThisBigNumber;
                if (!isThisBigNumber) {
                    data.xBuf[data.size] = (float)x;
                    data.yBuf[data.size] = (float)y;
                    if (drawMark) {
                        data.markColorBuf[data.size] = XYGraphDataChunker.this.graph.getEffectiveSymbolColor(this.i);
                    }
                    if (XYGraphDataChunker.this.graphData.getXError() != null && this.i < XYGraphDataChunker.this.graphData.getXError().size()) {
                        boolean vxhigh;
                        boolean vxlow = !Double.isNaN(XYGraphDataChunker.this.graphData.getXErrorLow(this.i));
                        boolean bl2 = vxhigh = !Double.isNaN(XYGraphDataChunker.this.graphData.getXErrorHigh(this.i));
                        if (vxlow || vxhigh) {
                            data.xErrorSize = data.size + 1;
                            data.xLowBuf[data.size] = vxlow ? (float)XYGraphDataChunker.this.xW2D.convert(XYGraphDataChunker.this.graphData.getX(this.i) - XYGraphDataChunker.this.graphData.getXErrorLow(this.i)) : data.xBuf[data.size];
                            data.xHighBuf[data.size] = vxhigh ? (float)XYGraphDataChunker.this.xW2D.convert(XYGraphDataChunker.this.graphData.getX(this.i) + XYGraphDataChunker.this.graphData.getXErrorHigh(this.i)) : data.xBuf[data.size];
                        }
                    }
                    if (XYGraphDataChunker.this.graphData.getYError() != null && this.i < XYGraphDataChunker.this.graphData.getYError().size()) {
                        boolean vyhigh;
                        boolean vylow = !Double.isNaN(XYGraphDataChunker.this.graphData.getYErrorLow(this.i));
                        boolean bl3 = vyhigh = !Double.isNaN(XYGraphDataChunker.this.graphData.getYErrorHigh(this.i));
                        if (vylow || vyhigh) {
                            data.yErrorSize = data.size + 1;
                            data.yLowBuf[data.size] = vylow ? (float)XYGraphDataChunker.this.yW2D.convert(XYGraphDataChunker.this.graphData.getY(this.i) - XYGraphDataChunker.this.graphData.getYErrorLow(this.i)) : data.yBuf[data.size];
                            data.yHighBuf[data.size] = vyhigh ? (float)XYGraphDataChunker.this.yW2D.convert(XYGraphDataChunker.this.graphData.getY(this.i) + XYGraphDataChunker.this.graphData.getYErrorHigh(this.i)) : data.yBuf[data.size];
                        }
                    }
                    ++data.size;
                }
                if (data.size >= 999) break;
                ++this.i;
            }
        }
    }

    public static class ChunkData {
        public int size;
        public float[] xBuf;
        public float[] yBuf;
        public Color[] markColorBuf;
        public int xErrorSize;
        public float[] xLowBuf;
        public float[] xHighBuf;
        public int yErrorSize;
        public float[] yLowBuf;
        public float[] yHighBuf;

        private ChunkData(int bufferSize) {
            this.xBuf = new float[bufferSize];
            this.yBuf = new float[bufferSize];
            this.markColorBuf = new Color[bufferSize];
            this.xLowBuf = new float[bufferSize];
            this.xHighBuf = new float[bufferSize];
            this.yLowBuf = new float[bufferSize];
            this.yHighBuf = new float[bufferSize];
            this.size = 0;
            this.xErrorSize = 0;
            this.yErrorSize = 0;
        }

        private void reset() {
            this.size = 0;
            this.xErrorSize = 0;
            this.yErrorSize = 0;
        }

        private void addPoint(float x, float y) {
            this.xBuf[this.size] = x;
            this.yBuf[this.size] = y;
            this.markColorBuf[this.size] = null;
            this.xHighBuf[this.size] = 0.0f;
            this.xLowBuf[this.size] = 0.0f;
            this.yHighBuf[this.size] = 0.0f;
            this.yLowBuf[this.size] = 0.0f;
            ++this.size;
        }
    }
}

