/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.impl.AnnotationImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.VStripAnnotationEx;
import org.jplot2d.transform.PaperTransform;
import org.jplot2d.util.DoubleDimension2D;
import org.jplot2d.util.Range;

public class VStripAnnotationImpl
extends AnnotationImpl
implements VStripAnnotationEx {
    private static Paint DEFAULT_PAINT = new Color(192, 192, 192, 128);
    private Range range;
    private Paint paint = DEFAULT_PAINT;

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "VStripAnnotation" + this.getParent().indexOf(this);
        }
        return "VStripAnnotation@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public Point2D getLocation() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getXAxisTransform() == null) {
            return null;
        }
        double locX = this.getXWtoP(this.range.getStart());
        return new Point2D.Double(locX, 0.0);
    }

    @Override
    public void setLocation(double x, double y) {
        Point2D loc = this.getLocation();
        if (loc != null && loc.getX() != x) {
            double endX = this.getXWtoP(this.range.getEnd()) - loc.getX() + x;
            double valueX = this.getXPtoW(x);
            double valueEnd = this.getXPtoW(endX);
            this.range = new Range.Double(valueX, valueEnd);
            VStripAnnotationImpl.redraw(this);
        }
    }

    @Override
    public Dimension2D getSize() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getXAxisTransform() == null) {
            return null;
        }
        double paperThickness = this.getXWtoP(this.range.getEnd()) - this.getXWtoP(this.range.getStart());
        return new DoubleDimension2D(this.getParent().getSize().getHeight(), Math.abs(paperThickness));
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getXAxisTransform() == null) {
            return null;
        }
        double paperThickness = this.getXWtoP(this.range.getEnd()) - this.getXWtoP(this.range.getStart());
        if (paperThickness >= 0.0) {
            return new Rectangle2D.Double(0.0, -paperThickness, this.getParent().getSize().getHeight(), paperThickness);
        }
        return new Rectangle2D.Double(0.0, 0.0, this.getParent().getSize().getHeight(), -paperThickness);
    }

    @Override
    public Rectangle2D getSelectableBounds() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getXAxisTransform() == null) {
            return null;
        }
        double paperThickness = this.getXWtoP(this.range.getEnd()) - this.getXWtoP(this.range.getStart());
        if (-2.0 < paperThickness && paperThickness < 2.0) {
            return new Rectangle2D.Double(-1.0, 0.0, 2.0, this.getParent().getSize().getHeight());
        }
        return this.getBounds();
    }

    @Override
    public PaperTransform getPaperTransform() {
        PaperTransform pxf = super.getPaperTransform();
        if (pxf == null) {
            return null;
        }
        return pxf.rotate(1.5707963267948966);
    }

    @Override
    public Range getValueRange() {
        return this.range;
    }

    @Override
    public void setValueRange(Range value) {
        this.range = value;
        VStripAnnotationImpl.redraw(this);
    }

    @Override
    public Paint getFillPaint() {
        return this.paint;
    }

    @Override
    public void setFillPaint(Paint paint) {
        this.paint = paint;
    }

    @Override
    public void draw(Graphics2D g) {
        Point2D loc = this.getLocation();
        if (loc == null) {
            return;
        }
        AffineTransform oldTransform = g.getTransform();
        Shape oldClip = g.getClip();
        g.transform(this.getParent().getPaperTransform().getTransform());
        g.setClip(this.getParent().getBounds());
        g.setPaint(this.paint);
        double paperThickness = this.getXWtoP(this.range.getEnd()) - this.getXWtoP(this.range.getStart());
        if (paperThickness == 0.0) {
            Line2D.Double line = new Line2D.Double(loc.getX(), 0.0, loc.getX(), this.getParent().getSize().getHeight());
            Stroke oldStroke = g.getStroke();
            g.setStroke(ZERO_WIDTH_STROKE);
            g.draw(line);
            g.setStroke(oldStroke);
        } else {
            Rectangle2D.Double strip = paperThickness > 0.0 ? new Rectangle2D.Double(loc.getX(), 0.0, paperThickness, this.getParent().getSize().getHeight()) : new Rectangle2D.Double(loc.getX() + paperThickness, 0.0, -paperThickness, this.getParent().getSize().getHeight());
            g.fill(strip);
        }
        g.setTransform(oldTransform);
        g.setClip(oldClip);
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        VStripAnnotationImpl lm = (VStripAnnotationImpl)src;
        this.range = lm.range;
        this.paint = lm.paint;
    }
}

