/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.impl.AnnotationImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.RectangleAnnotationEx;
import org.jplot2d.util.DoubleDimension2D;
import org.jplot2d.util.Range;

public class RectangleAnnotationImpl
extends AnnotationImpl
implements RectangleAnnotationEx {
    private static Paint DEFAULT_PAINT = new Color(192, 192, 192, 128);
    private Range xrange;
    private Range yrange;
    private Paint paint = DEFAULT_PAINT;

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "RectangleAnnotation" + this.getParent().indexOf(this);
        }
        return "RectangleAnnotation@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public Point2D getLocation() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getXAxisTransform() == null || this.getParent().getYAxisTransform() == null) {
            return null;
        }
        double locX = this.getXWtoP(this.xrange.getStart());
        double locY = this.getYWtoP(this.yrange.getStart());
        return new Point2D.Double(locX, locY);
    }

    @Override
    public void setLocation(double x, double y) {
        double valueEnd;
        Point2D loc = this.getLocation();
        if (loc != null && loc.getX() != x) {
            double endX = this.getXWtoP(this.xrange.getEnd()) - loc.getX() + x;
            double valueX = this.getXPtoW(x);
            valueEnd = this.getXPtoW(endX);
            this.xrange = new Range.Double(valueX, valueEnd);
            RectangleAnnotationImpl.redraw(this);
        }
        if (loc != null && loc.getY() != y) {
            double endY = this.getYWtoP(this.yrange.getEnd()) - loc.getY() + y;
            double valueY = this.getYPtoW(y);
            valueEnd = this.getYPtoW(endY);
            this.yrange = new Range.Double(valueY, valueEnd);
            RectangleAnnotationImpl.redraw(this);
        }
    }

    @Override
    public Dimension2D getSize() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getXAxisTransform() == null || this.getParent().getYAxisTransform() == null) {
            return null;
        }
        double paperWidth = this.getXWtoP(this.xrange.getEnd()) - this.getXWtoP(this.xrange.getStart());
        double paperHeight = this.getYWtoP(this.yrange.getEnd()) - this.getYWtoP(this.yrange.getStart());
        return new DoubleDimension2D(Math.abs(paperWidth), Math.abs(paperHeight));
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getXAxisTransform() == null || this.getParent().getYAxisTransform() == null) {
            return null;
        }
        double paperWidth = this.getXWtoP(this.xrange.getEnd()) - this.getXWtoP(this.xrange.getStart());
        double paperHeight = this.getYWtoP(this.yrange.getEnd()) - this.getYWtoP(this.yrange.getStart());
        return new Rectangle2D.Double(Math.min(paperWidth, 0.0), Math.min(paperHeight, 0.0), Math.abs(paperWidth), Math.abs(paperHeight));
    }

    @Override
    public Rectangle2D getSelectableBounds() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getXAxisTransform() == null || this.getParent().getYAxisTransform() == null) {
            return null;
        }
        double paperWidth = this.getXWtoP(this.xrange.getEnd()) - this.getXWtoP(this.xrange.getStart());
        double paperHeight = this.getYWtoP(this.yrange.getEnd()) - this.getYWtoP(this.yrange.getStart());
        double rx = Math.min(paperWidth, 0.0);
        double ry = Math.min(paperHeight, 0.0);
        double rw = Math.abs(paperWidth);
        double rh = Math.abs(paperHeight);
        if (rw < 2.0) {
            rx = -1.0;
            rw = 2.0;
        }
        if (rh < 2.0) {
            ry = -1.0;
            rh = 2.0;
        }
        return new Rectangle2D.Double(rx, ry, rw, rh);
    }

    @Override
    public Range getXValueRange() {
        return this.xrange;
    }

    @Override
    public void setXValueRange(Range value) {
        this.xrange = value;
        if (this.getParent() != null && this.getParent().getXAxisTransform() != null) {
            RectangleAnnotationImpl.redraw(this);
        }
    }

    @Override
    public Range getYValueRange() {
        return this.yrange;
    }

    @Override
    public void setYValueRange(Range value) {
        this.yrange = value;
        if (this.getParent() != null && this.getParent().getYAxisTransform() != null) {
            RectangleAnnotationImpl.redraw(this);
        }
    }

    @Override
    public Paint getFillPaint() {
        return this.paint;
    }

    @Override
    public void setFillPaint(Paint paint) {
        this.paint = paint;
    }

    @Override
    public void draw(Graphics2D g) {
        Point2D loc = this.getLocation();
        if (loc == null) {
            return;
        }
        AffineTransform oldTransform = g.getTransform();
        Shape oldClip = g.getClip();
        g.transform(this.getParent().getPaperTransform().getTransform());
        g.setClip(this.getParent().getBounds());
        g.setPaint(this.paint);
        double paperWidth = this.getXWtoP(this.xrange.getEnd()) - this.getXWtoP(this.xrange.getStart());
        double paperHeight = this.getYWtoP(this.yrange.getEnd()) - this.getYWtoP(this.yrange.getStart());
        double rx = Math.min(paperWidth, 0.0);
        double ry = Math.min(paperHeight, 0.0);
        double rw = Math.abs(paperWidth);
        double rh = Math.abs(paperHeight);
        if (paperWidth == 0.0 || paperHeight == 0.0) {
            Line2D.Double line = new Line2D.Double(loc.getX() + rx, loc.getY() + ry, loc.getX() + rw, loc.getY() + rh);
            Stroke oldStroke = g.getStroke();
            g.setStroke(ZERO_WIDTH_STROKE);
            g.draw(line);
            g.setStroke(oldStroke);
        } else {
            Rectangle2D.Double strip = new Rectangle2D.Double(loc.getX() + rx, loc.getY() + ry, rw, rh);
            g.fill(strip);
        }
        g.setTransform(oldTransform);
        g.setClip(oldClip);
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        RectangleAnnotationImpl lm = (RectangleAnnotationImpl)src;
        this.xrange = lm.xrange;
        this.yrange = lm.yrange;
        this.paint = lm.paint;
    }
}

