/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jplot2d.element.Annotation;
import org.jplot2d.element.AxisTransform;
import org.jplot2d.element.Element;
import org.jplot2d.element.Graph;
import org.jplot2d.element.Plot;
import org.jplot2d.element.impl.AnnotationEx;
import org.jplot2d.element.impl.AxisTransformEx;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.element.impl.ContainerImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.GraphEx;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.element.impl.LayerEx;
import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.element.impl.XYGraphEx;
import org.jplot2d.transform.PaperTransform;

public class LayerImpl
extends ContainerImpl
implements LayerEx {
    private List<GraphEx> graphs = new ArrayList<GraphEx>();
    private AxisTransformEx xarm;
    private AxisTransformEx yarm;
    private List<AnnotationEx> annotations = new ArrayList<AnnotationEx>();

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "Layer" + this.getParent().indexOf(this);
        }
        return "Layer@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public String getShortId() {
        if (this.getParent() != null) {
            String pid = this.getParent().getShortId();
            if (pid == null) {
                return this.getId();
            }
            return this.getId() + "." + pid;
        }
        return this.getId();
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        Method method;
        if (this.parent == null) {
            return null;
        }
        try {
            method = Plot.class.getMethod("getLayer", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method, this.getParent().indexOf(this));
    }

    @Override
    public PlotEx getParent() {
        return (PlotEx)super.getParent();
    }

    @Override
    public Map<Element, Element> getMooringMap() {
        return super.getMooringMap();
    }

    @Override
    public Point2D getLocation() {
        if (this.getParent() == null) {
            return null;
        }
        return new Point2D.Double(0.0, 0.0);
    }

    @Override
    public Dimension2D getSize() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getContentSize();
    }

    @Override
    public PaperTransform getPaperTransform() {
        if (this.getParent() != null) {
            return this.getParent().getPaperTransform();
        }
        return null;
    }

    @Override
    public void transformChanged() {
        for (GraphEx graph : this.graphs) {
            LayerImpl.redraw(graph);
        }
        for (AnnotationEx annotation : this.annotations) {
            LayerImpl.redraw(annotation);
        }
    }

    @Override
    public ComponentEx[] getComponents() {
        int i;
        int size = this.graphs.size() + this.annotations.size();
        ComponentEx[] comps = new ComponentEx[size];
        int n = 0;
        for (i = 0; i < this.graphs.size(); ++i) {
            comps[n++] = this.graphs.get(i);
        }
        for (i = 0; i < this.annotations.size(); ++i) {
            comps[n++] = this.annotations.get(i);
        }
        return comps;
    }

    @Override
    public Graph getGraph(int index) {
        return this.graphs.get(index);
    }

    @Override
    public GraphEx[] getGraphs() {
        return this.graphs.toArray(new GraphEx[this.graphs.size()]);
    }

    @Override
    public void addGraph(Graph graph) {
        GraphEx gx = (GraphEx)graph;
        this.graphs.add(gx);
        gx.setParent(this);
        if (this.getParent() != null && gx instanceof XYGraphEx) {
            this.getParent().getLegend().addLegendItem(((XYGraphEx)gx).getLegendItem());
        }
        LayerImpl.redraw(gx);
        if (gx.isVisible()) {
            if (this.xarm != null && this.xarm.getLockGroup().isAutoRange()) {
                this.xarm.getLockGroup().reAutoRange();
            }
            if (this.yarm != null && this.yarm.getLockGroup().isAutoRange()) {
                this.yarm.getLockGroup().reAutoRange();
            }
        }
    }

    @Override
    public void removeGraph(Graph graph) {
        GraphEx gx = (GraphEx)graph;
        LayerImpl.redraw(gx);
        this.graphs.remove(gx);
        gx.setParent(null);
        if (this.getParent() != null && gx instanceof XYGraphEx) {
            this.getParent().getLegend().removeLegendItem(((XYGraphEx)gx).getLegendItem());
        }
        if (gx.isVisible()) {
            if (this.xarm != null && this.xarm.getLockGroup().isAutoRange()) {
                this.xarm.getLockGroup().reAutoRange();
            }
            if (this.yarm != null && this.yarm.getLockGroup().isAutoRange()) {
                this.yarm.getLockGroup().reAutoRange();
            }
        }
    }

    @Override
    public int indexOf(GraphEx graph) {
        return this.graphs.indexOf(graph);
    }

    @Override
    public AnnotationEx[] getAnnotations() {
        return this.annotations.toArray(new AnnotationEx[this.annotations.size()]);
    }

    @Override
    public Annotation getAnnotation(int idx) {
        return this.annotations.get(idx);
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        AnnotationEx annx = (AnnotationEx)annotation;
        this.annotations.add(annx);
        annx.setParent(this);
        LayerImpl.redraw(annx);
    }

    @Override
    public void removeAnnotation(Annotation annotation) {
        AnnotationEx annx = (AnnotationEx)annotation;
        LayerImpl.redraw(annx);
        this.annotations.remove(annx);
        annx.setParent(null);
    }

    @Override
    public int indexOf(AnnotationEx annotation) {
        return this.annotations.indexOf(annotation);
    }

    @Override
    public boolean canContribute() {
        return false;
    }

    @Override
    public AxisTransformEx getXAxisTransform() {
        return this.xarm;
    }

    @Override
    public AxisTransformEx getYAxisTransform() {
        return this.yarm;
    }

    @Override
    public void linkXAxisTransform(AxisTransformEx axt) {
        this.xarm = axt;
    }

    @Override
    public void linkYAxisTransform(AxisTransformEx axt) {
        this.yarm = axt;
    }

    @Override
    public void setXAxisTransform(AxisTransform axis) {
        if (this.xarm != null) {
            this.xarm.removeLayer(this);
        }
        this.xarm = (AxisTransformEx)axis;
        if (this.xarm != null) {
            this.xarm.addLayer(this);
        }
        if (axis != null) {
            this.transformChanged();
        }
    }

    @Override
    public void setYAxisTransform(AxisTransform axis) {
        if (this.yarm != null) {
            this.yarm.removeLayer(this);
        }
        this.yarm = (AxisTransformEx)axis;
        if (this.yarm != null) {
            this.yarm.addLayer(this);
        }
        if (axis != null) {
            this.transformChanged();
        }
    }

    @Override
    public void setAxesTransform(AxisTransform xaxis, AxisTransform yaxis) {
        this.setXAxisTransform(xaxis);
        this.setYAxisTransform(yaxis);
    }

    @Override
    public LayerEx copyStructure(Map<ElementEx, ElementEx> orig2copyMap) {
        LayerImpl result = (LayerImpl)super.copyStructure((Map)orig2copyMap);
        for (GraphEx graph : this.graphs) {
            GraphEx graphCopy = (GraphEx)graph.copyStructure(orig2copyMap);
            graphCopy.setParent(result);
            result.graphs.add(graphCopy);
        }
        for (AnnotationEx annotation : this.annotations) {
            AnnotationEx copy = (AnnotationEx)annotation.copyStructure(orig2copyMap);
            copy.setParent(result);
            result.annotations.add(copy);
        }
        return result;
    }
}

