/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.util.WeakHashMap;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.image.IntensityTransform;

public class ImageZscaleCache {
    private static final int MAX_BITS = 16;
    private static final WeakHashMap<Key, ValueRef> map = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Key createCacheFor(ImageDataBuffer dbuf, int w, int h, double[] limits, IntensityTransform intensityTransform, double bias, double gain, int outputBits) {
        Key key = new Key(dbuf, w, h, limits, intensityTransform, bias, gain, outputBits);
        WeakHashMap<Key, ValueRef> weakHashMap = map;
        synchronized (weakHashMap) {
            ValueRef vref = map.remove(key);
            if (vref == null) {
                vref = new ValueRef();
            }
            map.put(key, vref);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(ImageDataBuffer dbuf, int w, int h, double[] limits, IntensityTransform intensityTransform, double bias, double gain, int outputBits) {
        ValueRef vref;
        Key key = new Key(dbuf, w, h, limits, intensityTransform, bias, gain, outputBits);
        Object object = map;
        synchronized (object) {
            vref = map.get(key);
        }
        if (vref == null) {
            return ImageZscaleCache.zscaleLimits(key);
        }
        object = vref;
        synchronized (object) {
            if (vref.v != null) {
                return vref.v;
            }
            vref.v = ImageZscaleCache.zscaleLimits(key);
            return vref.v;
        }
    }

    private static Object zscaleLimits(Key key) {
        ImageDataBuffer idb = key.dbuf;
        int w = key.w;
        int h = key.h;
        double[] limits = key.limits;
        int lutInputBits = ImageZscaleCache.getILUTInputBits(key.intensityTransform, key.bias, key.gain, key.outputBits);
        if (key.outputBits <= 8) {
            byte[] lut = ImageZscaleCache.createByteILUT(key.intensityTransform, key.bias, key.gain, lutInputBits, key.outputBits);
            return ImageZscaleCache.zscaleBytes(idb, 0, 0, w, h, limits, lut, lutInputBits);
        }
        short[] lut = ImageZscaleCache.createShortILUT(key.intensityTransform, key.bias, key.gain, lutInputBits, key.outputBits);
        return ImageZscaleCache.zscaleShorts(idb, 0, 0, w, h, limits, lut, lutInputBits);
    }

    private static int getILUTInputBits(IntensityTransform intensityTransform, double bias, double gain, int outputBits) {
        int bits = outputBits;
        if (intensityTransform != null || gain != 0.5 || bias != 0.5) {
            bits += 2;
        }
        if (bits > 16) {
            bits = 16;
        }
        return bits;
    }

    private static byte[] createByteILUT(IntensityTransform intensityTransform, double bias, double gain, int inputBits, int outputBits) {
        if (intensityTransform == null && gain == 0.5 && bias == 0.5) {
            return null;
        }
        int lutIndexes = 1 << inputBits;
        int outputRange = 1 << outputBits;
        byte[] lut = new byte[lutIndexes + 2];
        for (int i = 0; i <= lutIndexes; ++i) {
            int v;
            double t = (double)i / (double)lutIndexes;
            if (intensityTransform != null) {
                t = intensityTransform.transform(t);
            }
            if (bias != 0.5) {
                t /= (1.0 / bias - 2.0) * (1.0 - t) + 1.0;
            }
            if (gain != 0.5) {
                double f = (1.0 / gain - 2.0) * (1.0 - 2.0 * t);
                t = t < 0.5 ? (t /= f + 1.0) : (f - t) / (f - 1.0);
            }
            if ((v = (int)((double)outputRange * t)) < 0) {
                v = 0;
            } else if (v >= outputRange) {
                v = outputRange - 1;
            }
            lut[i] = (byte)v;
        }
        lut[lutIndexes + 1] = lut[lutIndexes];
        return lut;
    }

    private static byte[] zscaleBytes(ImageDataBuffer idb, int xoff, int yoff, int w, int h, double[] limits, byte[] lut, int lutInputBits) {
        byte[] result = new byte[w * h];
        if (limits == null) {
            return result;
        }
        double lowCut = limits[0];
        double highCut = limits[1];
        int outputRange = 1 << lutInputBits;
        double scale = (double)outputRange / (highCut - lowCut);
        int n = 0;
        if (lut == null) {
            for (int r = yoff; r < yoff + h; ++r) {
                for (int c = xoff; c < xoff + w; ++c) {
                    double scaled = (idb.getDouble(c, r) - lowCut) * scale;
                    int ilutIndex = (int)scaled;
                    if (ilutIndex >= outputRange) {
                        ilutIndex = outputRange - 1;
                    }
                    result[n++] = (byte)ilutIndex;
                }
            }
        } else {
            for (int r = yoff; r < yoff + h; ++r) {
                for (int c = xoff; c < xoff + w; ++c) {
                    double scaled = (idb.getDouble(c, r) - lowCut) * scale;
                    int ilutIndex = (int)scaled;
                    double idelta = ilutIndex - ilutIndex;
                    int a = lut[ilutIndex] & 0xFF;
                    int b = lut[ilutIndex + 1] & 0xFF;
                    result[n++] = (byte)((double)a + idelta * (double)(b - a));
                }
            }
        }
        return result;
    }

    private static short[] createShortILUT(IntensityTransform intensityTransform, double bias, double gain, int inputBits, int outputBits) {
        if (intensityTransform == null && gain == 0.5 && bias == 0.5) {
            return null;
        }
        int lutIndexes = 1 << inputBits;
        int outputRange = 1 << outputBits;
        short[] lut = new short[lutIndexes + 2];
        for (int i = 0; i <= lutIndexes; ++i) {
            int v;
            double t = (double)i / (double)lutIndexes;
            if (intensityTransform != null) {
                t = intensityTransform.transform(t);
            }
            if (bias != 0.5) {
                t /= (1.0 / bias - 2.0) * (1.0 - t) + 1.0;
            }
            if (gain != 0.5) {
                double f = (1.0 / gain - 2.0) * (1.0 - 2.0 * t);
                t = t < 0.5 ? (t /= f + 1.0) : (f - t) / (f - 1.0);
            }
            if ((v = (int)((double)outputRange * t)) < 0) {
                v = 0;
            } else if (v >= outputRange) {
                v = outputRange - 1;
            }
            lut[i] = (short)v;
        }
        lut[lutIndexes + 1] = lut[lutIndexes];
        return lut;
    }

    private static short[] zscaleShorts(ImageDataBuffer idb, int xoff, int yoff, int w, int h, double[] limits, short[] lut, int lutInputBits) {
        short[] result = new short[w * h];
        if (limits == null) {
            return result;
        }
        double lowCut = limits[0];
        double highCut = limits[1];
        int outputRange = 1 << lutInputBits;
        double scale = (double)outputRange / (highCut - lowCut);
        int n = 0;
        if (lut == null) {
            for (int r = yoff; r < yoff + h; ++r) {
                for (int c = xoff; c < xoff + w; ++c) {
                    double scaled = (idb.getDouble(c, r) - lowCut) * scale;
                    int ilutIndex = (int)scaled;
                    if (ilutIndex >= outputRange) {
                        ilutIndex = outputRange - 1;
                    }
                    result[n++] = (short)ilutIndex;
                }
            }
        } else {
            for (int r = yoff; r < yoff + h; ++r) {
                for (int c = xoff; c < xoff + w; ++c) {
                    double scaled = (idb.getDouble(c, r) - lowCut) * scale;
                    int ilutIndex = (int)scaled;
                    double idelta = ilutIndex - ilutIndex;
                    int a = lut[ilutIndex] & 0xFFFF;
                    int b = lut[ilutIndex + 1] & 0xFFFF;
                    result[n++] = (short)((double)a + idelta * (double)(b - a));
                }
            }
        }
        return result;
    }

    private static class ValueRef {
        private Object v;

        private ValueRef() {
        }
    }

    public static class Key {
        private final ImageDataBuffer dbuf;
        private final int w;
        private final int h;
        private final double[] limits;
        private final IntensityTransform intensityTransform;
        private final double bias;
        private final double gain;
        private final int outputBits;

        private Key(ImageDataBuffer dbuf, int w, int h, double[] limits, IntensityTransform intensityTransform, double bias, double gain, int outputBits) {
            this.dbuf = dbuf;
            this.w = w;
            this.h = h;
            this.limits = limits;
            this.intensityTransform = intensityTransform;
            this.bias = bias;
            this.gain = gain;
            this.outputBits = outputBits;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ImageZscaleCache) {
                return false;
            }
            Key key = (Key)obj;
            boolean limitsMatch = key.limits == this.limits || key.limits != null && key != null && key.limits[0] == this.limits[0] && key.limits[1] == this.limits[1];
            return key.dbuf.equals(this.dbuf) && key.w == this.w && key.h == this.h && limitsMatch && key.intensityTransform == this.intensityTransform && key.bias == this.bias && key.gain == this.gain && key.outputBits == this.outputBits;
        }

        public int hashCode() {
            return this.dbuf.hashCode();
        }
    }
}

