/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Dimension;
import java.lang.reflect.Method;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.element.RGBImageMapping;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.ElementImpl;
import org.jplot2d.element.impl.ImageBandTransformEx;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.element.impl.RGBImageGraphEx;
import org.jplot2d.element.impl.RGBImageMappingEx;
import org.jplot2d.image.IntensityTransform;
import org.jplot2d.image.LimitsAlgorithm;
import org.jplot2d.image.MinMaxAlgorithm;

public class ImageBandTransformImpl
extends ElementImpl
implements ImageBandTransformEx {
    private LimitsAlgorithm algo = new MinMaxAlgorithm();
    private double[] limits;
    private IntensityTransform intensityTransform;
    private double bias = 0.5;
    private double gain = 0.5;
    private boolean calcLimitsNeeded;

    @Override
    public RGBImageMappingEx getParent() {
        return (RGBImageMappingEx)this.parent;
    }

    @Override
    public String getId() {
        if (this.getParent() != null) {
            if (this == this.getParent().getRedTransform()) {
                return "ImageBandTransform(Red)";
            }
            if (this == this.getParent().getGreenTransform()) {
                return "ImageBandTransform(Green)";
            }
            if (this == this.getParent().getBlueTransform()) {
                return "ImageBandTransform(Blue)";
            }
        }
        return "ImageBandTransform@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        if (this.parent == null) {
            return null;
        }
        Method method = null;
        try {
            if (this == this.getParent().getRedTransform()) {
                method = RGBImageMapping.class.getMethod("getRedTransform", new Class[0]);
            } else if (this == this.getParent().getGreenTransform()) {
                method = RGBImageMapping.class.getMethod("getGreenTransform", new Class[0]);
            } else if (this == this.getParent().getBlueTransform()) {
                method = RGBImageMapping.class.getMethod("getBlueTransform", new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method);
    }

    @Override
    public LimitsAlgorithm getLimitsAlgorithm() {
        return this.algo;
    }

    @Override
    public void setLimitsAlgorithm(LimitsAlgorithm algo) {
        this.algo = algo;
        this.redrawGraphs();
    }

    @Override
    public IntensityTransform getIntensityTransform() {
        return this.intensityTransform;
    }

    @Override
    public void setIntensityTransform(IntensityTransform it) {
        this.intensityTransform = it;
        this.redrawGraphs();
    }

    @Override
    public double getBias() {
        return this.bias;
    }

    @Override
    public void setBias(double bias) {
        this.bias = bias;
        this.redrawGraphs();
    }

    @Override
    public double getGain() {
        return this.gain;
    }

    @Override
    public void setGain(double gain) {
        this.gain = gain;
        this.redrawGraphs();
    }

    private void redrawGraphs() {
        for (RGBImageGraphEx graph : this.getParent().getGraphs()) {
            graph.mappingChanged();
        }
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        ImageBandTransformImpl imapping = (ImageBandTransformImpl)src;
        this.algo = imapping.algo;
        this.limits = imapping.limits;
        this.intensityTransform = imapping.intensityTransform;
        this.bias = imapping.bias;
        this.gain = imapping.gain;
        this.calcLimitsNeeded = imapping.calcLimitsNeeded;
    }

    @Override
    public void recalcLimits() {
        this.calcLimitsNeeded = true;
    }

    @Override
    public void calcLimits(ImageDataBuffer[] dataBuffers, Dimension[] sizeArray) {
        if (this.calcLimitsNeeded || this.limits == null) {
            double[] newlimits = this.algo.getCalculator().calcLimits(dataBuffers, sizeArray);
            if (this.limits == null || newlimits == null || this.limits[0] != newlimits[0] || this.limits[1] != newlimits[1]) {
                this.limits = newlimits;
                this.redrawGraphs();
            }
        }
    }

    @Override
    public double[] getLimits() {
        return this.limits;
    }
}

