/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.impl.AnnotationImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.HStripAnnotationEx;
import org.jplot2d.util.DoubleDimension2D;
import org.jplot2d.util.Range;

public class HStripAnnotationImpl
extends AnnotationImpl
implements HStripAnnotationEx {
    private static Paint DEFAULT_PAINT = new Color(192, 192, 192, 128);
    private Range range;
    private Paint paint = DEFAULT_PAINT;

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "HStripAnnotation" + this.getParent().indexOf(this);
        }
        return "HStripAnnotation@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public Point2D getLocation() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getYAxisTransform() == null) {
            return null;
        }
        double locY = this.getYWtoP(this.range.getStart());
        return new Point2D.Double(0.0, locY);
    }

    @Override
    public void setLocation(double x, double y) {
        Point2D loc = this.getLocation();
        if (loc != null && loc.getY() != y) {
            double endY = this.getYWtoP(this.range.getEnd()) - loc.getY() + y;
            double valueY = this.getYPtoW(y);
            double valueEnd = this.getYPtoW(endY);
            this.range = new Range.Double(valueY, valueEnd);
            HStripAnnotationImpl.redraw(this);
        }
    }

    @Override
    public Dimension2D getSize() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getYAxisTransform() == null) {
            return null;
        }
        double paperThickness = this.getYWtoP(this.range.getEnd()) - this.getYWtoP(this.range.getStart());
        return new DoubleDimension2D(this.getParent().getSize().getWidth(), Math.abs(paperThickness));
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getYAxisTransform() == null) {
            return null;
        }
        double paperThickness = this.getYWtoP(this.range.getEnd()) - this.getYWtoP(this.range.getStart());
        if (paperThickness >= 0.0) {
            return new Rectangle2D.Double(0.0, 0.0, this.getParent().getSize().getWidth(), paperThickness);
        }
        return new Rectangle2D.Double(0.0, paperThickness, this.getParent().getSize().getWidth(), -paperThickness);
    }

    @Override
    public Rectangle2D getSelectableBounds() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getYAxisTransform() == null) {
            return null;
        }
        double paperThickness = this.getYWtoP(this.range.getEnd()) - this.getYWtoP(this.range.getStart());
        if (-2.0 < paperThickness && paperThickness < 2.0) {
            return new Rectangle2D.Double(0.0, -1.0, this.getParent().getSize().getWidth(), 2.0);
        }
        return this.getBounds();
    }

    @Override
    public Range getValueRange() {
        return this.range;
    }

    @Override
    public void setValueRange(Range value) {
        this.range = value;
        HStripAnnotationImpl.redraw(this);
    }

    @Override
    public Paint getFillPaint() {
        return this.paint;
    }

    @Override
    public void setFillPaint(Paint paint) {
        this.paint = paint;
    }

    @Override
    public void draw(Graphics2D g) {
        Point2D loc = this.getLocation();
        if (loc == null) {
            return;
        }
        AffineTransform oldTransform = g.getTransform();
        Shape oldClip = g.getClip();
        g.transform(this.getParent().getPaperTransform().getTransform());
        g.setClip(this.getParent().getBounds());
        g.setPaint(this.paint);
        double paperThickness = this.getYWtoP(this.range.getEnd()) - this.getYWtoP(this.range.getStart());
        if (paperThickness == 0.0) {
            Line2D.Double line = new Line2D.Double(0.0, loc.getY(), this.getParent().getSize().getWidth(), loc.getY());
            Stroke oldStroke = g.getStroke();
            g.setStroke(ZERO_WIDTH_STROKE);
            g.draw(line);
            g.setStroke(oldStroke);
        } else {
            Rectangle2D.Double strip = paperThickness > 0.0 ? new Rectangle2D.Double(0.0, loc.getY(), this.getParent().getSize().getWidth(), paperThickness) : new Rectangle2D.Double(0.0, loc.getY() + paperThickness, this.getParent().getSize().getWidth(), -paperThickness);
            g.fill(strip);
        }
        g.setTransform(oldTransform);
        g.setClip(oldClip);
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        HStripAnnotationImpl lm = (HStripAnnotationImpl)src;
        this.range = lm.range;
        this.paint = lm.paint;
    }
}

