/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Map;
import org.jplot2d.element.Element;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.element.impl.ContainerEx;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.ElementImpl;
import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.transform.PaperTransform;

public abstract class ComponentImpl
extends ElementImpl
implements ComponentEx {
    private boolean visible = true;
    private boolean cacheable;
    private boolean selectable;
    private boolean movable;
    private int zOrder;
    private Color color = null;
    private String fontName;
    private int fontStyle = -1;
    private float fontSize = Float.NaN;
    private float fontScale = 1.0f;
    protected PropertyChangeSupport _changes = new PropertyChangeSupport(this);
    private boolean redrawNeeded;

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this._changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this._changes.removePropertyChangeListener(l);
    }

    @Override
    public ContainerEx getParent() {
        return (ContainerEx)this.parent;
    }

    @Override
    public Map<Element, Element> getMooringMap() {
        return Collections.emptyMap();
    }

    @Override
    public boolean canContribute() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        ComponentImpl.redrawCascade(this);
        this.visible = visible;
        ComponentImpl.redrawCascade(this);
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public void setCacheable(boolean cacheMode) {
        ComponentImpl.redraw(this);
        this.cacheable = cacheMode;
        ComponentImpl.redraw(this);
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean movable) {
        this.movable = movable;
    }

    @Override
    public int getZOrder() {
        return this.zOrder;
    }

    @Override
    public void setZOrder(int z) {
        this.zOrder = z;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        Color oldEC = this.getEffectiveColor();
        this.color = color;
        if (!this.getEffectiveColor().equals(oldEC)) {
            this.thisEffectiveColorChanged();
        }
    }

    @Override
    public Color getEffectiveColor() {
        if (this.color != null) {
            return this.color;
        }
        if (this.getParent() != null) {
            return this.getParent().getEffectiveColor();
        }
        return null;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public void setFontName(String name) {
        String oldEFN = this.getEffectiveFontName();
        this.fontName = name;
        if (!this.getEffectiveFontName().equals(oldEFN)) {
            this.thisEffectiveFontChanged();
        }
    }

    @Override
    public int getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public void setFontStyle(int style) {
        int oldEFS = this.getEffectiveFontStyle();
        this.fontStyle = style;
        if (this.getEffectiveFontStyle() != oldEFS) {
            this.thisEffectiveFontChanged();
        }
    }

    @Override
    public float getFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(float size) {
        float oldEFS = this.getEffectiveFontSize();
        this.fontSize = size;
        if (this.getEffectiveFontSize() != oldEFS) {
            this.thisEffectiveFontChanged();
        }
    }

    @Override
    public float getFontScale() {
        return this.fontScale;
    }

    @Override
    public void setFontScale(float scale) {
        float oldEFS = this.getEffectiveFontSize();
        this.fontScale = scale;
        if (this.getEffectiveFontSize() != oldEFS) {
            this.thisEffectiveFontChanged();
        }
    }

    @Override
    public void setFont(Font font) {
        Font oldEF = this.getEffectiveFont();
        if (font == null) {
            this.fontName = null;
            this.fontStyle = -1;
            this.fontSize = Float.NaN;
        } else {
            this.fontName = font.getName();
            this.fontStyle = font.getStyle();
            this.fontSize = font.getSize2D();
        }
        if (!this.getEffectiveFont().equals(oldEF)) {
            this.thisEffectiveFontChanged();
        }
    }

    @Override
    public String getEffectiveFontName() {
        if (this.fontName != null) {
            return this.fontName;
        }
        if (this.getParent() != null) {
            return this.getParent().getEffectiveFontName();
        }
        return null;
    }

    @Override
    public int getEffectiveFontStyle() {
        if ((this.fontStyle & 0xFFFFFFFC) == 0) {
            return this.fontStyle;
        }
        if (this.getParent() != null) {
            return this.getParent().getEffectiveFontStyle();
        }
        return -1;
    }

    @Override
    public float getEffectiveFontSize() {
        if (!Float.isNaN(this.fontSize)) {
            return this.fontSize;
        }
        if (this.getParent() != null) {
            return this.getParent().getEffectiveFontSize() * this.fontScale;
        }
        return Float.NaN;
    }

    @Override
    public Font getEffectiveFont() {
        float size = this.getEffectiveFontSize();
        return new Font(this.getEffectiveFontName(), this.getEffectiveFontStyle(), (int)size).deriveFont(size);
    }

    @Override
    public final void parentEffectiveColorChanged() {
        if (this.color == null) {
            this.thisEffectiveColorChanged();
        }
    }

    @Override
    public final void parentEffectiveFontChanged() {
        if (this.fontName == null || (this.fontStyle & 0xFFFFFFFC) != 0 || Float.isNaN(this.fontSize)) {
            this.thisEffectiveFontChanged();
        }
    }

    @Override
    public PaperTransform getPaperTransform() {
        PaperTransform pxf;
        PaperTransform paperTransform = pxf = this.getParent() == null ? null : this.getParent().getPaperTransform();
        if (pxf == null) {
            return null;
        }
        Point2D loc = this.getLocation();
        if (loc == null) {
            return null;
        }
        return pxf.translate(loc.getX(), loc.getY());
    }

    @Override
    public Rectangle2D getBounds() {
        Dimension2D size = this.getSize();
        if (size == null) {
            return null;
        }
        return new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight());
    }

    @Override
    public Rectangle2D getSelectableBounds() {
        return this.getBounds();
    }

    @Override
    public boolean isRedrawNeeded() {
        return this.redrawNeeded;
    }

    @Override
    public void setRedrawNeeded(boolean flag) {
        this.redrawNeeded = flag;
    }

    protected static void redrawCascade(ComponentEx comp) {
        if (comp.isVisible()) {
            ComponentImpl.redraw(comp);
            if (comp instanceof ContainerEx) {
                for (ComponentEx subcomp : ((ContainerEx)comp).getComponents()) {
                    ComponentImpl.redrawCascade(subcomp);
                }
            }
        }
    }

    protected static void redraw(ComponentEx comp) {
        if (comp.isVisible() && comp.canContribute()) {
            ComponentImpl.markRedraw(comp);
        }
    }

    private static void markRedraw(ComponentEx comp) {
        if (comp.isVisible()) {
            if (!comp.isCacheable() && comp.getParent() != null) {
                ComponentImpl.markRedraw(comp.getParent());
            } else {
                comp.setRedrawNeeded(true);
                ComponentImpl.markRerender(comp);
            }
        }
    }

    private static void markRerender(ComponentEx comp) {
        if (comp.getParent() != null) {
            ComponentImpl.markRerender(comp.getParent());
        } else if (comp instanceof PlotEx) {
            ((PlotEx)comp).setRerenderNeeded(true);
        }
    }

    @Override
    public ComponentEx copyStructure(Map<ElementEx, ElementEx> orig2copyMap) {
        return (ComponentEx)super.copyStructure(orig2copyMap);
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        ComponentImpl comp = (ComponentImpl)src;
        this.visible = comp.visible;
        this.cacheable = comp.cacheable;
        this.selectable = comp.selectable;
        this.movable = comp.movable;
        this.zOrder = comp.zOrder;
        this.color = comp.color;
        this.fontName = comp.fontName;
        this.fontStyle = comp.fontStyle;
        this.fontSize = comp.fontSize;
        this.fontScale = comp.fontScale;
        this.redrawNeeded = comp.redrawNeeded;
    }

    protected void drawBounds(Graphics2D g) {
        g.setColor(Color.RED);
        Rectangle rect = this.getPaperTransform().getPtoD(this.getBounds()).getBounds();
        g.draw(new Rectangle(rect.x, rect.y, rect.width - 1, rect.height - 1));
        g.drawLine(rect.x, rect.y, (int)rect.getMaxX() - 1, (int)rect.getMaxY() - 1);
        g.drawLine(rect.x, (int)rect.getMaxY() - 1, (int)rect.getMaxX() - 1, rect.y);
        g.drawString(this.getClass().getSimpleName(), rect.x, (int)(rect.getMaxY() - 1.0));
    }
}

