/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jplot2d.axtype.AxisType;
import org.jplot2d.element.AxisRangeLockGroup;
import org.jplot2d.element.impl.AxisEx;
import org.jplot2d.element.impl.AxisRangeLockGroupEx;
import org.jplot2d.element.impl.AxisRangeUtils;
import org.jplot2d.element.impl.AxisTickManagerEx;
import org.jplot2d.element.impl.AxisTransformEx;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.ElementImpl;
import org.jplot2d.element.impl.GraphEx;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.element.impl.LayerEx;
import org.jplot2d.element.impl.PrecisionState;
import org.jplot2d.element.impl.RangeStatus;
import org.jplot2d.notice.Notice;
import org.jplot2d.notice.RangeAdjustedToValueBoundsNotice;
import org.jplot2d.notice.RangeSelectionNotice;
import org.jplot2d.transform.NormalTransform;
import org.jplot2d.transform.TransformType;
import org.jplot2d.util.Range;

public class AxisTransformImpl
extends ElementImpl
implements AxisTransformEx {
    public static final double DEFAULT_MARGIN_FACTOR = 0.03125;
    private AxisType type;
    private TransformType txfType;
    private boolean autoMargin = true;
    private double marginFactor = 0.03125;
    private Range coreRange;
    private NormalTransform ntf;
    private AxisRangeLockGroupEx group;
    private final List<AxisTickManagerEx> tickManagers = new ArrayList<AxisTickManagerEx>();
    private final List<LayerEx> layers = new ArrayList<LayerEx>();

    public AxisTransformImpl() {
        this.type = AxisType.NUMBER;
        this.txfType = this.type.getDefaultTransformType();
        this.ntf = this.txfType.createNormalTransform(this.type.getDefaultWorldRange(this.txfType));
    }

    @Override
    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append("AxisTransform");
        for (AxisTickManagerEx tick : this.tickManagers) {
            sb.append("(");
            for (AxisEx axis : tick.getAxes()) {
                sb.append(axis.getShortId()).append(',');
            }
            sb.replace(sb.length() - 1, sb.length(), ")");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")(");
        for (LayerEx layer : this.layers) {
            sb.append(layer.getShortId()).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getFullId() {
        if (this.group != null) {
            int xidx = this.group.indexOfRangeManager(this);
            return "AxisTransform" + xidx + "." + this.group.getFullId();
        }
        return "AxisTransform@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        Method method;
        if (this.tickManagers.size() == 0) {
            return null;
        }
        try {
            method = AxisTickManagerEx.class.getMethod("getAxisTransform", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method);
    }

    @Override
    public AxisTickManagerEx getParent() {
        return (AxisTickManagerEx)super.getParent();
    }

    @Override
    public ElementEx getPrim() {
        if (this.tickManagers.size() == 0) {
            return null;
        }
        return this.tickManagers.get(0);
    }

    @Override
    public void notify(Notice msg) {
        if (this.getPrim() != null) {
            this.getPrim().notify(msg);
        }
    }

    @Override
    public boolean isInverted() {
        return this.ntf.isInverted();
    }

    @Override
    public void setInverted(boolean flag) {
        if (this.ntf.isInverted() != flag) {
            this.setNormalTransfrom(this.ntf.invert());
        }
    }

    @Override
    public boolean isAutoMargin() {
        return this.autoMargin;
    }

    @Override
    public void setAutoMargin(boolean autoMargin) {
        this.autoMargin = autoMargin;
        if (this.group.isAutoRange() && this.group.getPrimaryAxis() == this) {
            this.group.reAutoRange();
        } else if (this.coreRange != null) {
            Range irng = this.coreRange.copy();
            this.setRange(this.coreRange, true);
            this.coreRange = irng;
        }
    }

    @Override
    public double getMarginFactor() {
        return this.marginFactor;
    }

    @Override
    public void setMarginFactor(double factor) {
        this.marginFactor = factor;
        if (this.group.isAutoRange() && this.group.getPrimaryAxis() == this) {
            this.group.reAutoRange();
        } else if (this.coreRange != null) {
            Range irng = this.coreRange.copy();
            this.setRange(this.coreRange, true);
            this.coreRange = irng;
        }
    }

    @Override
    public AxisType getType() {
        return this.type;
    }

    @Override
    public void setType(AxisType type) {
        if (this.group.getRangeManagers().length > 1) {
            throw new IllegalStateException("The axis type can only be changed when the axis doses not lock with other axes.");
        }
        this.type = type;
        if (!type.canSupport(this.txfType)) {
            this.txfType = type.getDefaultTransformType();
        }
        for (AxisTickManagerEx atm : this.tickManagers) {
            atm.transformTypeChanged();
        }
        this.group.validateAxesRange();
    }

    @Override
    public TransformType getTransform() {
        return this.txfType;
    }

    @Override
    public void setTransform(TransformType txfType) {
        if (this.group.getRangeManagers().length > 1) {
            throw new IllegalStateException("The axis type can only be changed when the axis doses not lock with other axes.");
        }
        this.txfType = txfType;
        for (AxisTickManagerEx atm : this.tickManagers) {
            atm.transformTypeChanged();
        }
        this.group.validateAxesRange();
    }

    @Override
    public void changeTransformType(TransformType txfType) {
        this.txfType = txfType;
        for (AxisTickManagerEx atm : this.tickManagers) {
            atm.transformTypeChanged();
        }
    }

    @Override
    public AxisRangeLockGroupEx getLockGroup() {
        return this.group;
    }

    @Override
    public void setLockGroup(AxisRangeLockGroup group) {
        if (this.group != null) {
            this.group.removeRangeManager(this);
        }
        this.group = (AxisRangeLockGroupEx)group;
        if (this.group != null) {
            this.group.addRangeManager(this);
        }
    }

    @Override
    public NormalTransform getNormalTransform() {
        return this.ntf;
    }

    @Override
    public void setNormalTransfrom(NormalTransform ntf) {
        if (this.ntf.equals(ntf)) {
            return;
        }
        boolean sameRange = this.ntf.equals(ntf.invert());
        this.ntf = ntf;
        if (!sameRange) {
            for (LayerEx layer : this.layers) {
                AxisRangeLockGroupEx orth;
                if (layer.getXAxisTransform() == this) {
                    orth = layer.getYAxisTransform().getLockGroup();
                    if (orth == null || !orth.isAutoRange()) continue;
                    orth.reAutoRange();
                    continue;
                }
                if (layer.getYAxisTransform() != this || (orth = layer.getXAxisTransform().getLockGroup()) == null || !orth.isAutoRange()) continue;
                orth.reAutoRange();
            }
        }
        for (LayerEx layer : this.layers) {
            layer.transformChanged();
        }
    }

    @Override
    public AxisTickManagerEx[] getTickManagers() {
        return this.tickManagers.toArray(new AxisTickManagerEx[this.tickManagers.size()]);
    }

    @Override
    public void addTickManager(AxisTickManagerEx tickManager) {
        this.tickManagers.add(tickManager);
        this.parent = this.tickManagers.size() == 1 ? (ElementEx)this.tickManagers.get(0) : null;
    }

    @Override
    public void removeTickManager(AxisTickManagerEx tickManager) {
        this.tickManagers.remove(tickManager);
        this.parent = this.tickManagers.size() == 1 ? (ElementEx)this.tickManagers.get(0) : null;
    }

    @Override
    public int indexOfTickManager(AxisTickManagerEx tickManager) {
        return this.tickManagers.indexOf(tickManager);
    }

    @Override
    public LayerEx[] getLayers() {
        return this.layers.toArray(new LayerEx[this.layers.size()]);
    }

    @Override
    public void addLayer(LayerEx layer) {
        this.layers.add(layer);
        if (this.group.isAutoRange()) {
            for (GraphEx graph : layer.getGraphs()) {
                if (!graph.isVisible()) continue;
                this.group.reAutoRange();
                break;
            }
        }
    }

    @Override
    public void removeLayer(LayerEx layer) {
        this.layers.remove(layer);
        if (this.group.isAutoRange()) {
            for (GraphEx graph : layer.getGraphs()) {
                if (!graph.isVisible()) continue;
                this.group.reAutoRange();
                break;
            }
        }
    }

    @Override
    public void linkLayer(LayerEx layer) {
        this.layers.add(layer);
    }

    @Override
    public Range getCoreRange() {
        return this.coreRange;
    }

    @Override
    public void setCoreRange(Range crange) {
        if (crange == null) {
            this.coreRange = null;
        } else {
            if (crange.isInverted() != this.ntf.isInverted()) {
                crange = crange.invert();
            }
            if (!crange.equals(this.coreRange)) {
                this.coreRange = crange;
                this.setRange(this.coreRange, true);
            }
        }
    }

    @Override
    public Range getRange() {
        return this.ntf.getValueRange();
    }

    @Override
    public void setRange(Range urange) {
        if (urange.isInverted() != this.ntf.isInverted()) {
            urange = urange.invert();
        }
        if (!urange.equals(this.getRange())) {
            this.setRange(urange, false);
        }
    }

    private void setRange(Range urange, boolean appendMargin) {
        Range extRange;
        RangeStatus<PrecisionState> rs;
        Range pRange;
        if (Double.isNaN(urange.getStart()) || Double.isNaN(urange.getEnd())) {
            throw new IllegalArgumentException("Range cannot start or end at NaN.");
        }
        Map<AxisTransformEx, NormalTransform> vtMap = AxisRangeUtils.createVirtualTransformMap(Arrays.asList(this.group.getRangeManagers()));
        NormalTransform vnt = vtMap.get(this);
        Range pr = vnt.convToNR(urange);
        if (appendMargin) {
            double span = pr.getSpan();
            double mpStart = pr.getStart() - span * this.getMarginFactor();
            double mpEnd = pr.getEnd() + span * this.getMarginFactor();
            pr = new Range.Double(mpStart, mpEnd);
        }
        if ((pRange = AxisRangeUtils.validateNormalRange(pr, vtMap, false)) == null) {
            throw new IllegalArgumentException(this.getFullId() + ": The given range is not valid.");
        }
        double pLo = pRange.getMin();
        double pHi = pRange.getMax();
        if (!pRange.equals(pr)) {
            this.notify(new RangeAdjustedToValueBoundsNotice(this.getFullId() + ": the given range contains invalid value, range adjusted to [" + this.ntf.convFromNR(pLo) + ", " + this.ntf.convFromNR(pHi) + "]"));
        }
        if ((rs = AxisRangeUtils.ensurePrecision(pRange, vtMap)).getStatus() != null) {
            this.notify(new RangeSelectionNotice(rs.getStatus().getMessage()));
        }
        if (appendMargin && this.isAutoMargin()) {
            Range ur = vnt.convFromNR(rs);
            Range exur = this.expandRangeToTick(ur);
            extRange = vnt.convToNR(exur);
        } else {
            extRange = rs;
        }
        RangeStatus<PrecisionState> xrs = AxisRangeUtils.ensureCircleSpan(extRange, vtMap);
        if (xrs.getStatus() != null) {
            this.notify(new RangeSelectionNotice(xrs.getStatus().getMessage()));
        }
        this.group.zoomVirtualRange(xrs, vtMap);
    }

    @Override
    public Range expandRangeToTick(Range ur) {
        if (this.tickManagers.size() > 0) {
            return this.tickManagers.get(0).expandRangeToTick(this.getTransform(), ur);
        }
        return null;
    }

    @Override
    public AxisTransformEx copyStructure(Map<ElementEx, ElementEx> orig2copyMap) {
        AxisRangeLockGroupEx algCopy;
        AxisTransformImpl result = new AxisTransformImpl();
        if (orig2copyMap != null) {
            orig2copyMap.put(this, result);
        }
        if ((algCopy = (AxisRangeLockGroupEx)orig2copyMap.get(this.group)) == null) {
            algCopy = (AxisRangeLockGroupEx)this.group.copyStructure(orig2copyMap);
        }
        result.group = algCopy;
        algCopy.addRangeManager(result);
        return result;
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        AxisTransformImpl arm = (AxisTransformImpl)src;
        this.type = arm.type;
        this.txfType = arm.txfType;
        this.autoMargin = arm.autoMargin;
        this.marginFactor = arm.marginFactor;
        this.coreRange = arm.coreRange;
        this.ntf = arm.ntf;
    }
}

