/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.demo;

import java.awt.Color;
import java.io.FileNotFoundException;
import org.jplot2d.element.Axis;
import org.jplot2d.element.ElementFactory;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.element.Title;
import org.jplot2d.element.XYGraph;
import org.jplot2d.env.RenderEnvironment;
import org.jplot2d.renderer.EpsExporter;
import org.jplot2d.renderer.PdfExporter;
import org.jplot2d.renderer.PngFileExporter;
import org.jplot2d.util.LineHatchPaint;

public class ExportFileDemo {
    public static void main(String[] args) throws FileNotFoundException {
        int n = 21;
        double[] x = new double[n];
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = (double)i / 10.0 - 1.0;
            y[i] = x[i] * x[i];
        }
        ElementFactory ef = ElementFactory.getInstance();
        Plot plot = ef.createPlot();
        plot.setScale(0.5);
        Title title = ef.createTitle("Title");
        title.setFontScale(2.0f);
        plot.addTitle(title);
        Axis xaxis = ef.createAxis();
        Axis yaxis = ef.createAxis();
        xaxis.getTitle().setText("x axis");
        plot.addXAxis(xaxis);
        yaxis.getTitle().setText("y axis");
        plot.addYAxis(yaxis);
        XYGraph graph = ef.createXYGraph(x, y, "lineA");
        float[] dash = new float[]{6.0f, 2.0f, 1.0f, 2.0f, 1.0f, 2.0f};
        graph.setLineStroke(ef.createStroke(1.0f, dash));
        graph.setFillEnabled(true);
        LineHatchPaint hatch = new LineHatchPaint(Color.RED, ElementFactory.getInstance().createStroke(1.0f, dash), 45.0, 10.0);
        graph.setFillPaint(hatch);
        Layer layer0 = ef.createLayer();
        layer0.addGraph(graph);
        plot.addLayer(layer0, xaxis.getTickManager().getAxisTransform(), yaxis.getTickManager().getAxisTransform());
        RenderEnvironment env = new RenderEnvironment(false);
        env.setPlot(plot);
        env.exportPlot(new EpsExporter("/tmp/demo.eps"));
        env.exportPlot(new PdfExporter("/tmp/demo.pdf"));
        env.exportPlot(new PngFileExporter("/tmp/demo.png"));
    }
}

