/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.data;

import java.nio.DoubleBuffer;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.data.ImageMaskBuffer;

public abstract class DoubleDataBuffer
extends ImageDataBuffer {
    public DoubleDataBuffer(ImageMaskBuffer mask) {
        super(mask);
    }

    @Override
    public byte getByte(int x, int y) {
        return (byte)this.get(x, y);
    }

    @Override
    public short getShort(int x, int y) {
        return (short)this.get(x, y);
    }

    @Override
    public int getInt(int x, int y) {
        return (int)this.get(x, y);
    }

    @Override
    public float getFloat(int x, int y) {
        return (float)this.get(x, y);
    }

    @Override
    public double getDouble(int x, int y) {
        return this.get(x, y);
    }

    public abstract double get(int var1, int var2);

    @Override
    public double countValid(int w, int h) {
        int count = 0;
        if (!this.hasMasks()) {
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    double v = this.get(i, j);
                    if (v != v || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY) continue;
                    ++count;
                }
            }
        } else {
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    double v;
                    if (this.isMasked(i, j) || (v = this.get(i, j)) != v || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    public double[] calcMinMax(int w, int h) {
        double v;
        int i;
        int j;
        double min = Double.NaN;
        double max = Double.NaN;
        int m = -1;
        int n = -1;
        for (j = 0; j < h; ++j) {
            for (i = 0; i < w; ++i) {
                v = this.get(i, j);
                if (this.isMasked(i, j) || v != v || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY) continue;
                min = v;
                max = v;
                m = i;
                n = j;
                break;
            }
            if (n != -1) break;
        }
        if (n == -1) {
            return null;
        }
        ++m;
        for (j = n; j < h; ++j) {
            for (i = m; i < w; ++i) {
                v = this.get(i, j);
                if (this.isMasked(i, j) || v != v || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY) continue;
                if (min > v) {
                    min = v;
                }
                if (!(max < v)) continue;
                max = v;
            }
            m = 0;
        }
        return new double[]{min, max};
    }

    public static class NioBuffer
    extends DoubleDataBuffer {
        private final DoubleBuffer data;
        private final int offset;

        public NioBuffer(DoubleBuffer data) {
            this(data, 0, null);
        }

        public NioBuffer(DoubleBuffer data, ImageMaskBuffer mask) {
            this(data, 0, mask);
        }

        public NioBuffer(DoubleBuffer data, int offset, ImageMaskBuffer mask) {
            super(mask);
            this.data = data;
            this.offset = offset;
        }

        @Override
        public double get(int x, int y) {
            return this.data.get(this.offset + x + y);
        }
    }

    public static class Array2D
    extends DoubleDataBuffer {
        private final double[][] data;
        private final int xoffset;
        private final int yoffset;

        public Array2D(double[][] data) {
            this(data, 0, 0, null);
        }

        public Array2D(double[][] data, ImageMaskBuffer mask) {
            this(data, 0, 0, mask);
        }

        public Array2D(double[][] data, int xoffset, int yoffset, ImageMaskBuffer mask) {
            super(mask);
            this.data = data;
            this.xoffset = xoffset;
            this.yoffset = yoffset;
        }

        @Override
        public double get(int x, int y) {
            return this.data[this.yoffset + y][this.xoffset + x];
        }
    }

    public static class Array
    extends DoubleDataBuffer {
        private final double[] data;
        private final int offset;

        public Array(double[] data) {
            this(data, 0, null);
        }

        public Array(double[] data, ImageMaskBuffer mask) {
            this(data, 0, mask);
        }

        public Array(double[] data, int offset, ImageMaskBuffer mask) {
            super(mask);
            this.data = data;
            this.offset = offset;
        }

        @Override
        public double get(int x, int y) {
            return this.data[this.offset + x + y];
        }
    }
}

