/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.lang.reflect.Array;
import java.text.Format;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jplot2d.tex.MathElement;
import org.jplot2d.tex.TeXMathUtils;
import org.jplot2d.util.Range;

public abstract class TickCalculator {
    public static final int AUTO_MINORTICK_NUMBER = -1;
    public static final double DOUBLE_PRECISION_TOLERANCE = 9.094947017729282E-13;
    private static final Pattern M_CONVERSION_PATTERN = Pattern.compile("(%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?)(m)");
    private static final Pattern M_RESULT_PATTERN = Pattern.compile("-->>([+-]?[0-9](?:[.][0-9]+)?)e([+-]?([0-9])+)<<--");

    public abstract Range getRange();

    public abstract void setRange(Range var1);

    public abstract void calcValuesByTickNumber(int var1, int var2);

    public abstract void calcValuesByTickInterval(double var1, double var3, int var5);

    public abstract double getInterval();

    public abstract int getMinorNumber();

    protected int calcMinorNumber(int majorInterval, int minorNumber) {
        int itv;
        int sdi;
        for (sdi = majorInterval; sdi > 10 && sdi % 10 == 0; sdi /= 10) {
        }
        int minorInterval = sdi / (minorNumber + 1);
        if (minorInterval == 0) {
            ++minorInterval;
        }
        int itvA = 1;
        int itvB = sdi;
        for (itv = minorInterval; itv > 1; --itv) {
            if (sdi % itv != 0) continue;
            itvA = itv;
            break;
        }
        for (itv = minorInterval + 1; itv < sdi; ++itv) {
            if (sdi % itv != 0) continue;
            itvB = itv;
            break;
        }
        int tickNumA = sdi / itvA - 1;
        int tickNumB = sdi / itvB - 1;
        if (tickNumB == 0) {
            return tickNumA;
        }
        if (tickNumA - minorNumber < minorNumber - tickNumB) {
            return tickNumA;
        }
        return tickNumB;
    }

    public abstract Object getValues();

    public abstract Object getMinorValues();

    public abstract int[] getInRangeValuesIdx(Object var1);

    public abstract Format calcLabelTextFormat(Object var1);

    public abstract String calcLabelFormatString(Object var1);

    public abstract String getLabelFormate();

    public abstract boolean isValidFormat(String var1);

    public MathElement[] formatValues(String format, Object values) {
        int n = Array.getLength(values);
        MathElement[] labels = new MathElement[n];
        for (int i = 0; i < n; ++i) {
            labels[i] = this.format(format, Array.get(values, i));
        }
        return labels;
    }

    protected MathElement format(String format, Object v) {
        String texString;
        boolean hasMConversion = false;
        StringBuffer convFormatBuffer = new StringBuffer();
        Matcher formatMatcher = M_CONVERSION_PATTERN.matcher(format);
        while (formatMatcher.find()) {
            hasMConversion = true;
            formatMatcher.appendReplacement(convFormatBuffer, "-->>$1e<<--");
        }
        formatMatcher.appendTail(convFormatBuffer);
        if (!hasMConversion) {
            texString = new Formatter(Locale.US).format(format, v).toString();
        } else {
            format = convFormatBuffer.toString();
            String intermediatResult = new Formatter(Locale.US).format(format, v).toString();
            int lastEnd = 0;
            Matcher resultMatcher = M_RESULT_PATTERN.matcher(intermediatResult);
            StringBuffer finalResultBuffer = new StringBuffer();
            while (resultMatcher.find()) {
                int mv;
                String s = intermediatResult.substring(lastEnd, resultMatcher.start());
                String a = resultMatcher.group(1);
                String m = resultMatcher.group(2);
                finalResultBuffer.append(s);
                boolean mathPart = false;
                if (m.startsWith("+")) {
                    m = m.substring(1);
                }
                if ((mv = Integer.parseInt(m)) != 0) {
                    mathPart = true;
                }
                if (!mathPart) {
                    finalResultBuffer.append(a);
                } else {
                    if (!a.equals("1")) {
                        finalResultBuffer.append(a);
                        finalResultBuffer.append(" ");
                    }
                    finalResultBuffer.append("$10^{");
                    finalResultBuffer.append(mv);
                    finalResultBuffer.append("}$");
                }
                lastEnd = resultMatcher.end();
            }
            texString = finalResultBuffer.toString();
        }
        if (texString.indexOf(36) == -1) {
            return new MathElement.Mtext(texString);
        }
        return TeXMathUtils.parseText(texString);
    }

    public MathElement[] formatValues(Format format, Object values) {
        int n = Array.getLength(values);
        MathElement[] labels = new MathElement[n];
        for (int i = 0; i < n; ++i) {
            labels[i] = this.format(format, Array.get(values, i));
        }
        return labels;
    }

    protected MathElement format(Format format, Object v) {
        String s = format.format(v);
        if (s.indexOf(36) == -1) {
            return new MathElement.Mtext(s);
        }
        return TeXMathUtils.parseText(s);
    }
}

