/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.lang.reflect.Array;
import java.text.Format;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Formatter;
import java.util.Locale;
import java.util.TimeZone;
import org.jplot2d.axtick.DateInterval;
import org.jplot2d.axtick.DateTickCalculator;
import org.jplot2d.axtick.LongTickCalculator;
import org.jplot2d.axtick.RangeAdvisor;
import org.jplot2d.axtick.TAIMicrosCalendar;
import org.jplot2d.tex.MathElement;
import org.jplot2d.tex.TeXMathUtils;

public class TAIMicrosTickCalculator
extends LongTickCalculator
implements RangeAdvisor {
    private final TimeZone zone;
    private final Locale locale;
    private DateInterval dateInterval;
    private int minorNumber;
    private long[] tickValues;
    private long[] minorValues;

    public TAIMicrosTickCalculator(TimeZone zone, Locale locale) {
        this.zone = zone;
        this.locale = locale;
    }

    protected static DateInterval calcInterval(long start, long end, int tickNumber) {
        int tickNumB;
        DateInterval itvB;
        DateInterval itvA;
        long hi;
        long lo;
        if (start == end) {
            throw new IllegalArgumentException("The range span must be great than zero");
        }
        if (tickNumber <= 0) {
            throw new IllegalArgumentException("The ticks number must be great than zero");
        }
        if (tickNumber == 1) {
            tickNumber = 2;
        }
        if (end > start) {
            lo = start;
            hi = end;
        } else {
            lo = end;
            hi = start;
        }
        tickNumber = Math.abs(tickNumber);
        double rough = (double)(hi - lo) / (double)(tickNumber - 1);
        if (rough < 1000.0) {
            int scale = rough < 10.0 ? 1 : (rough < 100.0 ? 10 : 100);
            double coeff = rough / (double)scale;
            if (coeff < 2.0) {
                itvA = new DateInterval(DateInterval.Unit.MICROSECOND, scale * 1);
                itvB = new DateInterval(DateInterval.Unit.MICROSECOND, scale * 2);
            } else if (coeff < 5.0) {
                itvA = new DateInterval(DateInterval.Unit.MICROSECOND, scale * 2);
                itvB = new DateInterval(DateInterval.Unit.MICROSECOND, scale * 5);
            } else {
                itvA = new DateInterval(DateInterval.Unit.MICROSECOND, scale * 5);
                itvB = new DateInterval(DateInterval.Unit.MICROSECOND, scale * 10);
            }
        } else {
            DateInterval[] itvAB = DateTickCalculator.calcCandidateIntervals(rough / 1000.0);
            itvA = itvAB[0];
            itvB = itvAB[1];
        }
        long iLoA = lo / itvA.getTimeInMicros();
        long iHiA = hi / itvA.getTimeInMicros();
        if (hi % itvA.getTimeInMicros() != 0L) {
            ++iHiA;
        }
        int tickNumA = (int)(iHiA - iLoA + 1L);
        long iLoB = lo / itvB.getTimeInMicros();
        long iHiB = hi / itvB.getTimeInMicros();
        if (hi % itvB.getTimeInMicros() != 0L) {
            ++iHiB;
        }
        if (tickNumA - tickNumber <= tickNumber - (tickNumB = (int)(iHiB - iLoB + 1L))) {
            return itvA;
        }
        return itvB;
    }

    protected void calcValues() {
        int i;
        if (this.dateInterval.getValue() == 0) {
            throw new IllegalArgumentException("delta cannot be zero");
        }
        TAIMicrosCalendar loCal = new TAIMicrosCalendar(this.zone, this.locale);
        loCal.setTimeInMicros(this.lo);
        TAIMicrosCalendar hiCal = new TAIMicrosCalendar(this.zone, this.locale);
        hiCal.setTimeInMicros(this.hi);
        TAIMicrosCalendar t1cal = (TAIMicrosCalendar)loCal.clone();
        TAIMicrosTickCalculator.setCalendarBelowToMin(t1cal, this.dateInterval.getUnit());
        if (t1cal.before(loCal)) {
            TAIMicrosTickCalculator.add(t1cal, this.dateInterval.getUnit(), 1);
        }
        ArrayList<Long> ticks = new ArrayList<Long>();
        ArrayList<Long> mticks = new ArrayList<Long>();
        if (this.minorNumber == 0) {
            int delta = TAIMicrosTickCalculator.distanceToIntervalBoundary(t1cal, this.dateInterval);
            if (delta != 0) {
                TAIMicrosTickCalculator.add(t1cal, this.dateInterval.getUnit(), this.dateInterval.getValue() - delta);
            }
            while (!t1cal.after(hiCal)) {
                ticks.add(t1cal.getTimeInMicros());
                TAIMicrosTickCalculator.add(t1cal, this.dateInterval.getUnit(), this.dateInterval.getValue());
            }
        } else {
            int mitv = this.dateInterval.getValue() / (this.minorNumber + 1);
            DateInterval minorInterval = new DateInterval(this.dateInterval.getUnit(), mitv);
            int delta = TAIMicrosTickCalculator.distanceToIntervalBoundary(t1cal, minorInterval);
            if (delta != 0) {
                TAIMicrosTickCalculator.add(t1cal, this.dateInterval.getUnit(), mitv - delta);
            }
            while (!t1cal.after(hiCal)) {
                if (TAIMicrosTickCalculator.distanceToIntervalBoundary(t1cal, this.dateInterval) == 0) {
                    ticks.add(t1cal.getTimeInMicros());
                } else {
                    mticks.add(t1cal.getTimeInMicros());
                }
                TAIMicrosTickCalculator.add(t1cal, this.dateInterval.getUnit(), mitv);
            }
        }
        this.tickValues = new long[ticks.size()];
        this.minorValues = new long[mticks.size()];
        if (this.inverted) {
            i = 0;
            int j = this.tickValues.length - 1;
            while (i < this.tickValues.length) {
                this.tickValues[i] = (Long)ticks.get(j);
                ++i;
                --j;
            }
            i = 0;
            j = this.minorValues.length - 1;
            while (i < this.minorValues.length) {
                this.minorValues[i] = (Long)mticks.get(j);
                ++i;
                --j;
            }
        } else {
            for (i = 0; i < this.tickValues.length; ++i) {
                this.tickValues[i] = (Long)ticks.get(i);
            }
            for (i = 0; i < this.minorValues.length; ++i) {
                this.minorValues[i] = (Long)mticks.get(i);
            }
        }
    }

    @Override
    public void expandRangeByTickNumber(int tickNumber) {
        long span;
        if (tickNumber <= 0) {
            throw new IllegalArgumentException("tick number must be positive.");
        }
        if (tickNumber == 1) {
            tickNumber = 2;
        }
        if ((span = this.hi - this.lo) < (long)(tickNumber - 1)) {
            long halfXpand = ((long)(tickNumber - 1) - span) / 2L;
            long odd = ((long)(tickNumber - 1) - span) % 2L;
            this.lo -= halfXpand;
            this.hi += halfXpand;
            this.hi += odd;
            if (this.lo < 0L) {
                this.lo = 0L;
                this.hi -= this.lo;
            }
            this.dateInterval = new DateInterval(DateInterval.Unit.MICROSECOND, 1);
        } else {
            this.dateInterval = TAIMicrosTickCalculator.calcInterval(this.lo, this.hi, tickNumber);
            this.expandRangeByTickInterval();
        }
    }

    @Override
    public void expandRangeByTickInterval(double interval) {
        this.dateInterval = DateInterval.createWithMicros(Math.round(interval));
        this.expandRangeByTickInterval();
        if (this.lo == this.hi) {
            TAIMicrosCalendar hiCal = new TAIMicrosCalendar(this.zone, this.locale);
            hiCal.setTimeInMicros(this.hi);
            TAIMicrosTickCalculator.add(hiCal, this.dateInterval.getUnit(), this.dateInterval.getValue());
            this.hi = hiCal.getTimeInMicros();
        }
    }

    protected void expandRangeByTickInterval() {
        int hiDelta;
        TAIMicrosCalendar loCal = new TAIMicrosCalendar(this.zone, this.locale);
        loCal.setTimeInMicros(this.lo);
        TAIMicrosCalendar hiCal = new TAIMicrosCalendar(this.zone, this.locale);
        hiCal.setTimeInMicros(this.hi);
        TAIMicrosTickCalculator.setCalendarBelowToMin(loCal, this.dateInterval.getUnit());
        int loDelta = TAIMicrosTickCalculator.distanceToIntervalBoundary(loCal, this.dateInterval);
        if (loDelta != 0) {
            TAIMicrosTickCalculator.add(loCal, this.dateInterval.getUnit(), -loDelta);
        }
        TAIMicrosTickCalculator.setCalendarBelowToMin(hiCal, this.dateInterval.getUnit());
        if (hiCal.getTimeInMicros() < this.hi) {
            TAIMicrosTickCalculator.add(hiCal, this.dateInterval.getUnit(), 1);
        }
        if ((hiDelta = TAIMicrosTickCalculator.distanceToIntervalBoundary(hiCal, this.dateInterval)) != 0) {
            TAIMicrosTickCalculator.add(hiCal, this.dateInterval.getUnit(), this.dateInterval.getValue() - hiDelta);
        }
        this.lo = loCal.getTimeInMicros();
        this.hi = hiCal.getTimeInMicros();
    }

    @Override
    public void calcValuesByTickNumber(int tickNumber, int minorTickNumber) {
        DateInterval interval = TAIMicrosTickCalculator.calcInterval(this.lo, this.hi, tickNumber);
        this.calcValuesByTickInterval(interval, 0L, minorTickNumber);
    }

    @Override
    public void calcValuesByTickInterval(long interval, long offset, int minorTickNumber) {
        this.calcValuesByTickInterval(DateInterval.createWithMicros(interval), offset, minorTickNumber);
    }

    private void calcValuesByTickInterval(DateInterval interval, long offset, int minorTickNumber) {
        this.dateInterval = interval;
        if (this.dateInterval.getValue() == 1) {
            this.minorNumber = 0;
        } else {
            if (minorTickNumber == -1) {
                minorTickNumber = 3;
            }
            this.minorNumber = this.calcMinorNumber(this.dateInterval.getValue(), minorTickNumber);
        }
        this.calcValues();
    }

    @Override
    public double getInterval() {
        return this.dateInterval.getTimeInMicros();
    }

    @Override
    public int getMinorNumber() {
        return this.minorNumber;
    }

    @Override
    public long[] getValues() {
        return this.tickValues;
    }

    @Override
    public long[] getMinorValues() {
        return this.minorValues;
    }

    @Override
    public String getLabelFormate() {
        TAIMicrosCalendar loCal = new TAIMicrosCalendar(this.zone, this.locale);
        loCal.setTimeInMicros(this.lo);
        TAIMicrosCalendar hiCal = new TAIMicrosCalendar(this.zone, this.locale);
        hiCal.setTimeInMicros(this.hi);
        DateInterval.Unit umax = TAIMicrosTickCalculator.getFirsNonEqualField(loCal, hiCal);
        return DateTickCalculator.calcLabelFormat(this.dateInterval.getUnit(), umax);
    }

    @Override
    public Format calcLabelTextFormat(Object canonicalValues) {
        return null;
    }

    @Override
    public String calcLabelFormatString(Object values) {
        if (((long[])values).length == 0) {
            return "";
        }
        TAIMicrosCalendar cal = new TAIMicrosCalendar(this.zone, this.locale);
        DateInterval.Unit umin = DateInterval.Unit.YEAR;
        long lo = Long.MAX_VALUE;
        long hi = 0L;
        for (long v : (long[])values) {
            if (lo > v) {
                lo = v;
            }
            if (hi < v) {
                hi = v;
            }
            cal.setTimeInMicros(v);
            DateInterval.Unit lnmf = TAIMicrosTickCalculator.getLastNonMinField(cal);
            if (umin.time <= lnmf.time) continue;
            umin = lnmf;
        }
        TAIMicrosCalendar loCal = new TAIMicrosCalendar(this.zone, this.locale);
        loCal.setTimeInMicros(lo);
        TAIMicrosCalendar hiCal = new TAIMicrosCalendar(this.zone, this.locale);
        hiCal.setTimeInMicros(hi);
        DateInterval.Unit umax = TAIMicrosTickCalculator.getFirsNonEqualField(loCal, hiCal);
        return DateTickCalculator.calcLabelFormat(umin, umax);
    }

    @Override
    public boolean isValidFormat(String format) {
        try {
            String.format(format, Calendar.getInstance(this.zone, this.locale));
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected static DateInterval.Unit getLastNonMinField(TAIMicrosCalendar cal) {
        if (cal.get(TAIMicrosCalendar.MICROSECOND) > cal.getMinimum(TAIMicrosCalendar.MICROSECOND)) {
            return DateInterval.Unit.MICROSECOND;
        }
        return DateTickCalculator.getLastNonMinField(cal.calendar);
    }

    protected static DateInterval.Unit getFirsNonEqualField(TAIMicrosCalendar a, TAIMicrosCalendar b) {
        DateInterval.Unit u = DateTickCalculator.getFirsNonEqualField(a.calendar, b.calendar);
        if (u != null) {
            return u;
        }
        if (a.get(TAIMicrosCalendar.MICROSECOND) != b.get(TAIMicrosCalendar.MICROSECOND)) {
            return DateInterval.Unit.MICROSECOND;
        }
        return null;
    }

    protected static void setCalendarBelowToMin(TAIMicrosCalendar cal, DateInterval.Unit unit) {
        switch (unit) {
            case MICROSECOND: {
                break;
            }
            default: {
                DateTickCalculator.setCalendarBelowToMin(cal.calendar, unit);
                cal.set(TAIMicrosCalendar.MICROSECOND, 0);
            }
        }
    }

    protected static void add(TAIMicrosCalendar cal, DateInterval.Unit unit, int amount) {
        switch (unit) {
            case MICROSECOND: {
                cal.add(TAIMicrosCalendar.MICROSECOND, amount);
                break;
            }
            case MILLISECOND: {
                cal.add(14, amount);
                break;
            }
            case SECOND: {
                cal.add(13, amount);
                break;
            }
            case MINUTE: {
                cal.add(12, amount);
                break;
            }
            case HOUR: {
                cal.add(11, amount);
                break;
            }
            case DAY: {
                cal.add(5, amount);
                break;
            }
            case WEEK: {
                cal.add(3, amount);
                break;
            }
            case MONTH: {
                cal.add(2, amount);
                break;
            }
            case YEAR: {
                cal.add(1, amount);
            }
        }
    }

    protected static int distanceToIntervalBoundary(TAIMicrosCalendar cal, DateInterval itv) {
        switch (itv.getUnit()) {
            case MICROSECOND: {
                return cal.get(TAIMicrosCalendar.MICROSECOND) % itv.getValue();
            }
        }
        return DateTickCalculator.distanceToIntervalBoundary(cal.calendar, itv);
    }

    @Override
    public MathElement[] formatValues(String format, Object values) {
        TAIMicrosCalendar cal = new TAIMicrosCalendar(this.zone, this.locale);
        int n = Array.getLength(values);
        MathElement[] labels = new MathElement[n];
        for (int i = 0; i < n; ++i) {
            cal.setTimeInMicros(Array.getLong(values, i));
            String microString = String.valueOf(cal.microsecond);
            if (microString.length() == 1) {
                microString = "00" + microString;
            } else if (microString.length() == 2) {
                microString = "0" + microString;
            }
            String texString = new Formatter(this.locale).format(format, cal.calendar).toString();
            int z6idx = texString.lastIndexOf("000000");
            texString = texString.substring(0, z6idx) + microString + texString.substring(z6idx + 6);
            labels[i] = texString.indexOf(36) == -1 ? new MathElement.Mtext(texString) : TeXMathUtils.parseText(texString);
        }
        return labels;
    }
}

