/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.text.Format;
import org.jplot2d.axtick.DoubleTickCalculator;
import org.jplot2d.axtick.Int10expn;
import org.jplot2d.axtick.LinearTickAlgorithm;
import org.jplot2d.axtick.LinearTickCalculator;
import org.jplot2d.axtick.RangeAdvisor;
import org.jplot2d.axtick.TickCalculator;
import org.jplot2d.util.NumberArrayUtils;

class LogTickCalculator
extends DoubleTickCalculator
implements RangeAdvisor {
    private LinearTickCalculator expCalculator = new LinearTickCalculator();
    private double[] _tickValues;
    private double[] _minorValues;

    @Override
    protected void setRange(double start, double end) {
        if (Double.isNaN(start) || Double.isInfinite(start) || Double.isNaN(end) || Double.isInfinite(end) || start <= 0.0 || end <= 0.0) {
            throw new IllegalArgumentException("Invalid range [" + start + "," + end + "].");
        }
        super.setRange(start, end);
        double expStart = Math.log10(start);
        double expEnd = Math.log10(end);
        this.expCalculator.setRange(expStart, expEnd);
    }

    protected int calcInterval(int tickNumber) {
        if (tickNumber <= 0) {
            throw new IllegalArgumentException("tickNumber must be great than zero");
        }
        if (tickNumber == 1) {
            tickNumber = 2;
        }
        this.expCalculator.calcInterval(tickNumber);
        if (this.expCalculator.getInterval() < 1.0) {
            return 1;
        }
        return (int)this.expCalculator.getInterval();
    }

    private void calcValuesExp1() {
        int coef;
        int minorEnd;
        double hi;
        double lo;
        boolean inverted;
        boolean bl = inverted = this.start > this.end;
        if (!inverted) {
            lo = this.start;
            hi = this.end;
        } else {
            lo = this.end;
            hi = this.start;
        }
        double expLo = Math.log10(lo);
        expLo -= Math.abs(expLo) * 9.094947017729282E-13;
        double expHi = Math.log10(hi);
        expHi += Math.abs(expHi) * 9.094947017729282E-13;
        int expStart = (int)Math.ceil(expLo);
        int expEnd = (int)Math.floor(expHi);
        int length = expEnd - expStart + 1;
        this._tickValues = new double[length];
        if (length == 0) {
            this._minorValues = new double[0];
            return;
        }
        int minorStart = (int)Math.ceil(Math.pow(10.0, expLo - (double)expStart + 1.0));
        int minorNum = 10 - minorStart + (length - 1) * 8 + ((minorEnd = (int)Math.floor(Math.pow(10.0, expHi - (double)expEnd))) - 1);
        if (minorNum == 0) {
            this._tickValues[0] = Math.pow(10.0, expStart);
            this._minorValues = new double[0];
            return;
        }
        this._minorValues = new double[minorNum];
        int mi = 0;
        for (coef = minorStart; coef <= 9; ++coef) {
            this._minorValues[mi++] = Math.pow(10.0, expStart - 1) * (double)coef;
        }
        int i = 0;
        block1: while (true) {
            int exp = expStart + i;
            double v = Math.pow(10.0, exp);
            this._tickValues[i++] = v;
            if (i == length) break;
            int coef2 = 2;
            while (true) {
                if (coef2 > 9) continue block1;
                this._minorValues[mi++] = v * (double)coef2;
                ++coef2;
            }
            break;
        }
        for (coef = 2; coef <= minorEnd; ++coef) {
            this._minorValues[mi++] = Math.pow(10.0, expEnd) * (double)coef;
        }
    }

    private void calcValues(int expInterval, int minorTickNumber) {
        if (expInterval == 1) {
            this.calcValuesExp1();
        } else {
            int i;
            this.expCalculator.calcValuesByTickInterval(expInterval, 0.0, minorTickNumber);
            this._tickValues = new double[this.expCalculator.getValues().length];
            this._minorValues = new double[this.expCalculator.getMinorValues().length];
            for (i = 0; i < this._tickValues.length; ++i) {
                this._tickValues[i] = Math.pow(10.0, this.expCalculator.getValues()[i]);
            }
            for (i = 0; i < this._minorValues.length; ++i) {
                this._minorValues[i] = Math.pow(10.0, this.expCalculator.getMinorValues()[i]);
            }
        }
    }

    private void calcAsLinear(int tickNumber, int minorTickNumber) {
        LinearTickCalculator tc = LinearTickAlgorithm.getInstance().createCalculator();
        ((DoubleTickCalculator)tc).setRange(this.start, this.end);
        ((TickCalculator)tc).calcValuesByTickNumber(tickNumber, minorTickNumber);
        this._tickValues = ((DoubleTickCalculator)tc).getValues();
        this._minorValues = ((DoubleTickCalculator)tc).getMinorValues();
    }

    private void calcAsLinear(double interval, double offset, int minorTickNumber) {
        LinearTickCalculator tc = LinearTickAlgorithm.getInstance().createCalculator();
        ((DoubleTickCalculator)tc).setRange(this.start, this.end);
        ((TickCalculator)tc).calcValuesByTickInterval(interval, offset, minorTickNumber);
        this._tickValues = ((DoubleTickCalculator)tc).getValues();
        this._minorValues = ((DoubleTickCalculator)tc).getMinorValues();
    }

    @Override
    public void expandRangeByTickNumber(int tickNumber) {
        if (tickNumber <= 0) {
            throw new IllegalArgumentException("tickNumber must be great than zero");
        }
        if (tickNumber == 1) {
            tickNumber = 2;
        }
        this.expCalculator.expandRangeByTickNumber(tickNumber);
        if (this.expCalculator.getInterval() < 1.0) {
            this.expCalculator.expandRangeByTickInterval(1.0);
        }
        this.start = Math.pow(10.0, this.expCalculator.getRange().getStart());
        this.end = Math.pow(10.0, this.expCalculator.getRange().getEnd());
    }

    @Override
    public void expandRangeByTickInterval(double interval) {
        if (interval < 0.0) {
            throw new IllegalArgumentException("LOG axis only accept a positive interval.");
        }
        int expi = Math.abs(new Int10expn(interval).getExponent());
        if (expi == 0) {
            expi = 1;
        }
        this.expCalculator.expandRangeByTickInterval(expi);
        this.start = Math.pow(10.0, this.expCalculator.getRange().getStart());
        this.end = Math.pow(10.0, this.expCalculator.getRange().getEnd());
    }

    @Override
    public void calcValuesByTickNumber(int tickNumber, int minorTickNumber) {
        int expInterval = this.calcInterval(tickNumber);
        this.calcValues(expInterval, minorTickNumber);
        if (this._tickValues.length == 0) {
            this.calcAsLinear(tickNumber, minorTickNumber);
            return;
        }
        if (minorTickNumber == 0) {
            this._minorValues = new double[0];
        }
        if (this.start > this.end) {
            this._tickValues = NumberArrayUtils.reverse(this._tickValues);
            this._minorValues = NumberArrayUtils.reverse(this._minorValues);
        }
    }

    @Override
    public void calcValuesByTickInterval(double interval, double offset, int minorTickNumber) {
        if (interval < 0.0) {
            throw new IllegalArgumentException("LOG axis only accept a positive interval.");
        }
        int expInterval = new Int10expn(interval).getExponent();
        if ((expInterval = Math.abs(expInterval)) == 0) {
            expInterval = 1;
        }
        this.calcValues(expInterval, minorTickNumber);
        if (this._tickValues.length == 0 || this._tickValues.length == 1 && this._minorValues.length == 0) {
            this.calcAsLinear(interval, offset, minorTickNumber);
        } else {
            if (minorTickNumber == 0) {
                this._minorValues = new double[0];
            }
            if (this.start > this.end) {
                this._tickValues = NumberArrayUtils.reverse(this._tickValues);
                this._minorValues = NumberArrayUtils.reverse(this._minorValues);
            }
        }
    }

    @Override
    public double getInterval() {
        return Math.pow(10.0, this.expCalculator.getInterval());
    }

    @Override
    public int getMinorNumber() {
        return this.expCalculator.getInterval() == 1.0 ? 9 : this.expCalculator.getMinorNumber();
    }

    @Override
    public double[] getValues() {
        return this._tickValues;
    }

    @Override
    public double[] getMinorValues() {
        return this._minorValues;
    }

    @Override
    public String getLabelFormate() {
        return this.calcLabelFormatString(this.getValues());
    }

    @Override
    public Format calcLabelTextFormat(Object canonicalValues) {
        return null;
    }
}

