/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.text.Format;
import org.jplot2d.axtick.AbstractLinearTickCalculator;
import org.jplot2d.axtick.DoubleInterval;
import org.jplot2d.axtick.Int10expn;

public class LinearTickCalculator
extends AbstractLinearTickCalculator {
    @Override
    protected DoubleInterval[] calcCandidateInterval(double rough) {
        Int10expn itvB;
        Int10expn itvA;
        int expn = (int)Math.floor(Math.log10(rough));
        double scale = Math.pow(10.0, expn);
        double coeff = rough / scale;
        if (coeff < 2.0) {
            itvA = new Int10expn(1, expn);
            itvB = new Int10expn(2, expn);
        } else if (coeff < 5.0) {
            itvA = new Int10expn(2, expn);
            itvB = new Int10expn(5, expn);
        } else {
            itvA = new Int10expn(5, expn);
            itvB = new Int10expn(1, expn + 1);
        }
        return new Int10expn[]{itvA, itvB};
    }

    @Override
    public void calcValuesByTickNumber(int tickNumber, int minorTickNumber) {
        block6: {
            block5: {
                Int10expn intv = (Int10expn)this.calcInterval(tickNumber);
                if (minorTickNumber != -1) break block5;
                switch (intv.getCoefficient()) {
                    case 1: {
                        this.minorNumber = 4;
                        break block6;
                    }
                    case 2: {
                        this.minorNumber = 3;
                        break block6;
                    }
                    case 5: {
                        this.minorNumber = 4;
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            this.minorNumber = minorTickNumber;
        }
        this.calcValues(this.interval, 0.0, this.minorNumber);
    }

    @Override
    protected int calcMinorNumber(double interval) {
        int mag = (int)Math.floor(Math.log10(interval));
        double coefficient = interval / Math.pow(10.0, mag);
        double s1dcoef = Math.round(coefficient);
        if (Math.abs(s1dcoef / coefficient - 1.0) > 9.094947017729282E-13) {
            return 0;
        }
        switch ((int)s1dcoef) {
            case 1: 
            case 10: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public String getLabelFormate() {
        return this.calcLabelFormatString(this.getValues());
    }

    @Override
    public Format calcLabelTextFormat(Object canonicalValues) {
        return null;
    }
}

