/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.lang.reflect.Array;
import java.text.Format;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Formatter;
import java.util.Locale;
import java.util.TimeZone;
import org.jplot2d.axtick.DateInterval;
import org.jplot2d.axtick.LongTickCalculator;
import org.jplot2d.axtick.RangeAdvisor;
import org.jplot2d.tex.MathElement;
import org.jplot2d.tex.TeXMathUtils;

public class DateTickCalculator
extends LongTickCalculator
implements RangeAdvisor {
    private final TimeZone zone;
    private final Locale locale;
    private DateInterval dateInterval;
    private int minorNumber;
    private long[] tickValues;
    private long[] minorValues;

    public DateTickCalculator(TimeZone zone, Locale locale) {
        this.zone = zone;
        this.locale = locale;
    }

    protected static DateInterval calcInterval(long start, long end, int tickNumber) {
        int tickNumB;
        long hi;
        long lo;
        if (start == end) {
            throw new IllegalArgumentException("The range span must be great than zero");
        }
        if (tickNumber <= 0) {
            throw new IllegalArgumentException("The ticks number must be great than zero");
        }
        if (tickNumber == 1) {
            tickNumber = 2;
        }
        if (end > start) {
            lo = start;
            hi = end;
        } else {
            lo = end;
            hi = start;
        }
        tickNumber = Math.abs(tickNumber);
        double rough = (double)(hi - lo) / (double)(tickNumber - 1);
        DateInterval[] itvAB = DateTickCalculator.calcCandidateIntervals(rough);
        DateInterval itvA = itvAB[0];
        DateInterval itvB = itvAB[1];
        long iLoA = lo / itvA.getTimeInMillis();
        long iHiA = hi / itvA.getTimeInMillis();
        if (hi % itvA.getTimeInMillis() != 0L) {
            ++iHiA;
        }
        int tickNumA = (int)(iHiA - iLoA + 1L);
        long iLoB = lo / itvB.getTimeInMillis();
        long iHiB = hi / itvB.getTimeInMillis();
        if (hi % itvB.getTimeInMillis() != 0L) {
            ++iHiB;
        }
        if (tickNumA - tickNumber <= tickNumber - (tickNumB = (int)(iHiB - iLoB + 1L))) {
            return itvA;
        }
        return itvB;
    }

    protected static DateInterval[] calcCandidateIntervals(double rough) {
        DateInterval itvB;
        DateInterval itvA;
        if (rough < 1000.0) {
            int scale = rough < 10.0 ? 1 : (rough < 100.0 ? 10 : 100);
            double coeff = rough / (double)scale;
            if (coeff < 2.0) {
                itvA = new DateInterval(DateInterval.Unit.MILLISECOND, scale * 1);
                itvB = new DateInterval(DateInterval.Unit.MILLISECOND, scale * 2);
            } else if (coeff < 5.0) {
                itvA = new DateInterval(DateInterval.Unit.MILLISECOND, scale * 2);
                itvB = new DateInterval(DateInterval.Unit.MILLISECOND, scale * 5);
            } else {
                itvA = new DateInterval(DateInterval.Unit.MILLISECOND, scale * 5);
                itvB = new DateInterval(DateInterval.Unit.MILLISECOND, scale * 10);
            }
        } else if (rough < (double)(DateInterval.Unit.SECOND.time * 2L)) {
            itvA = new DateInterval(DateInterval.Unit.SECOND, 1);
            itvB = new DateInterval(DateInterval.Unit.SECOND, 2);
        } else if (rough < (double)(DateInterval.Unit.SECOND.time * 5L)) {
            itvA = new DateInterval(DateInterval.Unit.SECOND, 2);
            itvB = new DateInterval(DateInterval.Unit.SECOND, 5);
        } else if (rough < (double)(DateInterval.Unit.SECOND.time * 10L)) {
            itvA = new DateInterval(DateInterval.Unit.SECOND, 5);
            itvB = new DateInterval(DateInterval.Unit.SECOND, 10);
        } else if (rough < (double)(DateInterval.Unit.SECOND.time * 15L)) {
            itvA = new DateInterval(DateInterval.Unit.SECOND, 10);
            itvB = new DateInterval(DateInterval.Unit.SECOND, 15);
        } else if (rough < (double)(DateInterval.Unit.SECOND.time * 30L)) {
            itvA = new DateInterval(DateInterval.Unit.SECOND, 15);
            itvB = new DateInterval(DateInterval.Unit.SECOND, 30);
        } else if (rough < (double)DateInterval.Unit.MINUTE.time) {
            itvA = new DateInterval(DateInterval.Unit.SECOND, 30);
            itvB = new DateInterval(DateInterval.Unit.MINUTE, 1);
        } else if (rough < (double)(DateInterval.Unit.MINUTE.time * 2L)) {
            itvA = new DateInterval(DateInterval.Unit.MINUTE, 1);
            itvB = new DateInterval(DateInterval.Unit.MINUTE, 2);
        } else if (rough < (double)(DateInterval.Unit.MINUTE.time * 5L)) {
            itvA = new DateInterval(DateInterval.Unit.MINUTE, 2);
            itvB = new DateInterval(DateInterval.Unit.MINUTE, 5);
        } else if (rough < (double)(DateInterval.Unit.MINUTE.time * 10L)) {
            itvA = new DateInterval(DateInterval.Unit.MINUTE, 5);
            itvB = new DateInterval(DateInterval.Unit.MINUTE, 10);
        } else if (rough < (double)(DateInterval.Unit.MINUTE.time * 15L)) {
            itvA = new DateInterval(DateInterval.Unit.MINUTE, 10);
            itvB = new DateInterval(DateInterval.Unit.MINUTE, 15);
        } else if (rough < (double)(DateInterval.Unit.MINUTE.time * 30L)) {
            itvA = new DateInterval(DateInterval.Unit.MINUTE, 15);
            itvB = new DateInterval(DateInterval.Unit.MINUTE, 30);
        } else if (rough < (double)DateInterval.Unit.HOUR.time) {
            itvA = new DateInterval(DateInterval.Unit.MINUTE, 30);
            itvB = new DateInterval(DateInterval.Unit.HOUR, 1);
        } else if (rough < (double)(DateInterval.Unit.HOUR.time * 2L)) {
            itvA = new DateInterval(DateInterval.Unit.HOUR, 1);
            itvB = new DateInterval(DateInterval.Unit.HOUR, 2);
        } else if (rough < (double)(DateInterval.Unit.HOUR.time * 3L)) {
            itvA = new DateInterval(DateInterval.Unit.HOUR, 2);
            itvB = new DateInterval(DateInterval.Unit.HOUR, 3);
        } else if (rough < (double)(DateInterval.Unit.HOUR.time * 6L)) {
            itvA = new DateInterval(DateInterval.Unit.HOUR, 3);
            itvB = new DateInterval(DateInterval.Unit.HOUR, 6);
        } else if (rough < (double)(DateInterval.Unit.HOUR.time * 12L)) {
            itvA = new DateInterval(DateInterval.Unit.HOUR, 6);
            itvB = new DateInterval(DateInterval.Unit.HOUR, 12);
        } else if (rough < (double)DateInterval.Unit.DAY.time) {
            itvA = new DateInterval(DateInterval.Unit.HOUR, 12);
            itvB = new DateInterval(DateInterval.Unit.DAY, 1);
        } else if (rough < (double)(DateInterval.Unit.DAY.time * 2L)) {
            itvA = new DateInterval(DateInterval.Unit.DAY, 1);
            itvB = new DateInterval(DateInterval.Unit.DAY, 2);
        } else if (rough < (double)DateInterval.Unit.WEEK.time) {
            itvA = new DateInterval(DateInterval.Unit.DAY, 2);
            itvB = new DateInterval(DateInterval.Unit.WEEK, 1);
        } else if (rough < (double)(DateInterval.Unit.WEEK.time * 2L)) {
            itvA = new DateInterval(DateInterval.Unit.WEEK, 1);
            itvB = new DateInterval(DateInterval.Unit.WEEK, 2);
        } else if (rough < (double)DateInterval.Unit.MONTH.time) {
            itvA = new DateInterval(DateInterval.Unit.WEEK, 2);
            itvB = new DateInterval(DateInterval.Unit.MONTH, 1);
        } else if (rough < (double)(DateInterval.Unit.MONTH.time * 3L)) {
            itvA = new DateInterval(DateInterval.Unit.MONTH, 1);
            itvB = new DateInterval(DateInterval.Unit.MONTH, 3);
        } else if (rough < (double)(DateInterval.Unit.MONTH.time * 6L)) {
            itvA = new DateInterval(DateInterval.Unit.MONTH, 3);
            itvB = new DateInterval(DateInterval.Unit.MONTH, 6);
        } else if (rough < (double)(DateInterval.Unit.YEAR.time * 1L)) {
            itvA = new DateInterval(DateInterval.Unit.MONTH, 6);
            itvB = new DateInterval(DateInterval.Unit.YEAR, 1);
        } else {
            double roughYear = rough / (double)DateInterval.Unit.YEAR.time;
            int expn = (int)Math.floor(Math.log10(roughYear));
            int scale = (int)Math.pow(10.0, expn);
            double coeff = roughYear / (double)scale;
            if (coeff < 2.0) {
                itvA = new DateInterval(DateInterval.Unit.YEAR, scale * 1);
                itvB = new DateInterval(DateInterval.Unit.YEAR, scale * 2);
            } else if (coeff < 5.0) {
                itvA = new DateInterval(DateInterval.Unit.YEAR, scale * 2);
                itvB = new DateInterval(DateInterval.Unit.YEAR, scale * 5);
            } else {
                itvA = new DateInterval(DateInterval.Unit.YEAR, scale * 5);
                itvB = new DateInterval(DateInterval.Unit.YEAR, scale * 10);
            }
        }
        return new DateInterval[]{itvA, itvB};
    }

    protected void calcValues() {
        int i;
        if (this.dateInterval.getValue() == 0) {
            throw new IllegalArgumentException("delta cannot be zero");
        }
        Calendar loCal = Calendar.getInstance(this.zone, this.locale);
        loCal.setTimeInMillis(this.lo);
        Calendar hiCal = Calendar.getInstance(this.zone, this.locale);
        hiCal.setTimeInMillis(this.hi);
        Calendar t1cal = (Calendar)loCal.clone();
        DateTickCalculator.setCalendarBelowToMin(t1cal, this.dateInterval.getUnit());
        if (t1cal.before(loCal)) {
            DateTickCalculator.add(t1cal, this.dateInterval.getUnit(), 1);
        }
        ArrayList<Long> ticks = new ArrayList<Long>();
        ArrayList<Long> mticks = new ArrayList<Long>();
        if (this.minorNumber == 0) {
            int delta = DateTickCalculator.distanceToIntervalBoundary(t1cal, this.dateInterval);
            if (delta != 0) {
                DateTickCalculator.add(t1cal, this.dateInterval.getUnit(), this.dateInterval.getValue() - delta);
            }
            while (!t1cal.after(hiCal)) {
                ticks.add(t1cal.getTimeInMillis());
                DateTickCalculator.add(t1cal, this.dateInterval.getUnit(), this.dateInterval.getValue());
            }
        } else {
            int mitv = this.dateInterval.getValue() / (this.minorNumber + 1);
            DateInterval minorInterval = new DateInterval(this.dateInterval.getUnit(), mitv);
            int delta = DateTickCalculator.distanceToIntervalBoundary(t1cal, minorInterval);
            if (delta != 0) {
                DateTickCalculator.add(t1cal, this.dateInterval.getUnit(), mitv - delta);
            }
            while (!t1cal.after(hiCal)) {
                if (DateTickCalculator.distanceToIntervalBoundary(t1cal, this.dateInterval) == 0) {
                    ticks.add(t1cal.getTimeInMillis());
                } else {
                    mticks.add(t1cal.getTimeInMillis());
                }
                DateTickCalculator.add(t1cal, this.dateInterval.getUnit(), mitv);
            }
        }
        this.tickValues = new long[ticks.size()];
        this.minorValues = new long[mticks.size()];
        if (this.inverted) {
            i = 0;
            int j = this.tickValues.length - 1;
            while (i < this.tickValues.length) {
                this.tickValues[i] = (Long)ticks.get(j);
                ++i;
                --j;
            }
            i = 0;
            j = this.minorValues.length - 1;
            while (i < this.minorValues.length) {
                this.minorValues[i] = (Long)mticks.get(j);
                ++i;
                --j;
            }
        } else {
            for (i = 0; i < this.tickValues.length; ++i) {
                this.tickValues[i] = (Long)ticks.get(i);
            }
            for (i = 0; i < this.minorValues.length; ++i) {
                this.minorValues[i] = (Long)mticks.get(i);
            }
        }
    }

    @Override
    public void expandRangeByTickNumber(int tickNumber) {
        long span;
        if (tickNumber <= 0) {
            throw new IllegalArgumentException("tick number must be positive.");
        }
        if (tickNumber == 1) {
            tickNumber = 2;
        }
        if ((span = this.hi - this.lo) < (long)(tickNumber - 1)) {
            long halfXpand = ((long)(tickNumber - 1) - span) / 2L;
            long odd = ((long)(tickNumber - 1) - span) % 2L;
            this.lo -= halfXpand;
            this.hi += halfXpand;
            this.hi += odd;
            if (this.lo < 0L) {
                this.lo = 0L;
                this.hi -= this.lo;
            }
            this.dateInterval = new DateInterval(DateInterval.Unit.MILLISECOND, 1);
        } else {
            this.dateInterval = DateTickCalculator.calcInterval(this.lo, this.hi, tickNumber);
            this.expandRangeByTickInterval();
        }
    }

    @Override
    public void expandRangeByTickInterval(double interval) {
        this.dateInterval = DateInterval.createWithMillis(Math.round(interval));
        this.expandRangeByTickInterval();
        if (this.lo == this.hi) {
            Calendar hiCal = Calendar.getInstance(this.zone, this.locale);
            hiCal.setTimeInMillis(this.hi);
            DateTickCalculator.add(hiCal, this.dateInterval.getUnit(), this.dateInterval.getValue());
            this.hi = hiCal.getTimeInMillis();
        }
    }

    protected void expandRangeByTickInterval() {
        int hiDelta;
        Calendar loCal = Calendar.getInstance(this.zone, this.locale);
        loCal.setTimeInMillis(this.lo);
        Calendar hiCal = Calendar.getInstance(this.zone, this.locale);
        hiCal.setTimeInMillis(this.hi);
        DateTickCalculator.setCalendarBelowToMin(loCal, this.dateInterval.getUnit());
        int loDelta = DateTickCalculator.distanceToIntervalBoundary(loCal, this.dateInterval);
        if (loDelta != 0) {
            DateTickCalculator.add(loCal, this.dateInterval.getUnit(), -loDelta);
        }
        DateTickCalculator.setCalendarBelowToMin(hiCal, this.dateInterval.getUnit());
        if (hiCal.getTimeInMillis() < this.hi) {
            DateTickCalculator.add(hiCal, this.dateInterval.getUnit(), 1);
        }
        if ((hiDelta = DateTickCalculator.distanceToIntervalBoundary(hiCal, this.dateInterval)) != 0) {
            DateTickCalculator.add(hiCal, this.dateInterval.getUnit(), this.dateInterval.getValue() - hiDelta);
        }
        this.lo = loCal.getTimeInMillis();
        this.hi = hiCal.getTimeInMillis();
    }

    @Override
    public void calcValuesByTickNumber(int tickNumber, int minorTickNumber) {
        DateInterval interval = DateTickCalculator.calcInterval(this.lo, this.hi, tickNumber);
        this.calcValuesByTickInterval(interval, 0L, minorTickNumber);
    }

    @Override
    public void calcValuesByTickInterval(long interval, long offset, int minorTickNumber) {
        this.calcValuesByTickInterval(DateInterval.createWithMillis(interval), offset, minorTickNumber);
    }

    private void calcValuesByTickInterval(DateInterval interval, long offset, int minorTickNumber) {
        this.dateInterval = interval;
        if (this.dateInterval.getValue() == 1) {
            this.minorNumber = 0;
        } else {
            if (minorTickNumber == -1) {
                minorTickNumber = 3;
            }
            this.minorNumber = this.calcMinorNumber(this.dateInterval.getValue(), minorTickNumber);
        }
        this.calcValues();
    }

    @Override
    public double getInterval() {
        return this.dateInterval.getTimeInMillis();
    }

    @Override
    public int getMinorNumber() {
        return this.minorNumber;
    }

    @Override
    public long[] getValues() {
        return this.tickValues;
    }

    @Override
    public long[] getMinorValues() {
        return this.minorValues;
    }

    @Override
    public String getLabelFormate() {
        Calendar loCal = Calendar.getInstance(this.zone, this.locale);
        loCal.setTimeInMillis(this.lo);
        Calendar hiCal = Calendar.getInstance(this.zone, this.locale);
        hiCal.setTimeInMillis(this.hi);
        DateInterval.Unit umax = DateTickCalculator.getFirsNonEqualField(loCal, hiCal);
        return DateTickCalculator.calcLabelFormat(this.dateInterval.getUnit(), umax);
    }

    @Override
    public Format calcLabelTextFormat(Object canonicalValues) {
        return null;
    }

    @Override
    public String calcLabelFormatString(Object values) {
        if (((long[])values).length == 0) {
            return "";
        }
        Calendar cal = Calendar.getInstance(this.zone, this.locale);
        DateInterval.Unit umin = DateInterval.Unit.YEAR;
        long lo = Long.MAX_VALUE;
        long hi = 0L;
        for (long v : (long[])values) {
            if (lo > v) {
                lo = v;
            }
            if (hi < v) {
                hi = v;
            }
            cal.setTimeInMillis(v);
            DateInterval.Unit lnmf = DateTickCalculator.getLastNonMinField(cal);
            if (umin.time <= lnmf.time) continue;
            umin = lnmf;
        }
        Calendar loCal = Calendar.getInstance(this.zone, this.locale);
        loCal.setTimeInMillis(lo);
        Calendar hiCal = Calendar.getInstance(this.zone, this.locale);
        hiCal.setTimeInMillis(hi);
        DateInterval.Unit umax = DateTickCalculator.getFirsNonEqualField(loCal, hiCal);
        return DateTickCalculator.calcLabelFormat(umin, umax);
    }

    @Override
    public boolean isValidFormat(String format) {
        try {
            String.format(format, Calendar.getInstance(this.zone, this.locale));
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected static String calcLabelFormat(DateInterval.Unit uprec, DateInterval.Unit umdiff) {
        String hms;
        if (uprec.time > umdiff.time) {
            throw new IllegalArgumentException("The MaxDiff unit must larger than precision unit.");
        }
        switch (uprec) {
            case MICROSECOND: {
                hms = "tT.%<tN";
                break;
            }
            case MILLISECOND: {
                hms = "tT.%<tL";
                break;
            }
            case SECOND: {
                hms = "tT";
                break;
            }
            case MINUTE: 
            case HOUR: {
                hms = "tR";
                break;
            }
            default: {
                hms = null;
            }
        }
        if (hms == null) {
            return "%tF";
        }
        if (umdiff.time >= DateInterval.Unit.DAY.time) {
            return "%tF %<" + hms;
        }
        return "%" + hms;
    }

    protected static DateInterval.Unit getLastNonMinField(Calendar cal) {
        if (cal.get(14) > cal.getMinimum(14)) {
            return DateInterval.Unit.MILLISECOND;
        }
        if (cal.get(13) > cal.getMinimum(13)) {
            return DateInterval.Unit.SECOND;
        }
        if (cal.get(12) > cal.getMinimum(12)) {
            return DateInterval.Unit.MINUTE;
        }
        if (cal.get(11) > cal.getMinimum(11)) {
            return DateInterval.Unit.HOUR;
        }
        if (cal.get(5) > cal.getMinimum(5)) {
            return DateInterval.Unit.DAY;
        }
        if (cal.get(2) > cal.getMinimum(2)) {
            return DateInterval.Unit.MONTH;
        }
        if (cal.get(1) > cal.getMinimum(1)) {
            return DateInterval.Unit.YEAR;
        }
        return null;
    }

    protected static DateInterval.Unit getFirsNonEqualField(Calendar a, Calendar b) {
        if (a.get(1) != b.get(1)) {
            return DateInterval.Unit.YEAR;
        }
        if (a.get(2) != b.get(2)) {
            return DateInterval.Unit.MONTH;
        }
        if (a.get(5) != b.get(5)) {
            return DateInterval.Unit.DAY;
        }
        if (a.get(11) != b.get(11)) {
            return DateInterval.Unit.HOUR;
        }
        if (a.get(12) != b.get(12)) {
            return DateInterval.Unit.MINUTE;
        }
        if (a.get(13) != b.get(13)) {
            return DateInterval.Unit.SECOND;
        }
        if (a.get(14) != b.get(14)) {
            return DateInterval.Unit.MILLISECOND;
        }
        return null;
    }

    protected static void setCalendarBelowToMin(Calendar cal, DateInterval.Unit unit) {
        switch (unit) {
            case MILLISECOND: {
                break;
            }
            case SECOND: {
                cal.set(14, cal.getMinimum(14));
                break;
            }
            case MINUTE: {
                cal.set(14, cal.getMinimum(14));
                cal.set(13, cal.getMinimum(13));
                break;
            }
            case HOUR: {
                cal.set(14, cal.getMinimum(14));
                cal.set(13, cal.getMinimum(13));
                cal.set(12, cal.getMinimum(12));
                break;
            }
            case DAY: {
                cal.set(14, cal.getMinimum(14));
                cal.set(13, cal.getMinimum(13));
                cal.set(12, cal.getMinimum(12));
                cal.set(11, cal.getMinimum(11));
                break;
            }
            case WEEK: {
                cal.set(14, cal.getMinimum(14));
                cal.set(13, cal.getMinimum(13));
                cal.set(12, cal.getMinimum(12));
                cal.set(11, cal.getMinimum(11));
                int woy = cal.get(3);
                cal.set(7, cal.getMinimum(7));
                cal.set(3, woy);
                break;
            }
            case MONTH: {
                cal.set(14, cal.getMinimum(14));
                cal.set(13, cal.getMinimum(13));
                cal.set(12, cal.getMinimum(12));
                cal.set(11, cal.getMinimum(11));
                cal.set(5, cal.getMinimum(5));
                break;
            }
            case YEAR: {
                cal.set(14, cal.getMinimum(14));
                cal.set(13, cal.getMinimum(13));
                cal.set(12, cal.getMinimum(12));
                cal.set(11, cal.getMinimum(11));
                cal.set(6, cal.getMinimum(6));
            }
        }
    }

    protected static void add(Calendar cal, DateInterval.Unit unit, int amount) {
        switch (unit) {
            case MILLISECOND: {
                cal.add(14, amount);
                break;
            }
            case SECOND: {
                cal.add(13, amount);
                break;
            }
            case MINUTE: {
                cal.add(12, amount);
                break;
            }
            case HOUR: {
                cal.add(11, amount);
                break;
            }
            case DAY: {
                cal.add(5, amount);
                break;
            }
            case WEEK: {
                cal.add(3, amount);
                break;
            }
            case MONTH: {
                cal.add(2, amount);
                break;
            }
            case YEAR: {
                cal.add(1, amount);
            }
        }
    }

    protected static int distanceToIntervalBoundary(Calendar cal, DateInterval itv) {
        int v = 0;
        int min = 0;
        switch (itv.getUnit()) {
            case MILLISECOND: {
                v = cal.get(14);
                min = cal.getMinimum(14);
                break;
            }
            case SECOND: {
                v = cal.get(13);
                min = cal.getMinimum(13);
                break;
            }
            case MINUTE: {
                v = cal.get(12);
                min = cal.getMinimum(12);
                break;
            }
            case HOUR: {
                v = cal.get(11);
                min = cal.getMinimum(11);
                break;
            }
            case DAY: {
                v = cal.get(5);
                min = cal.getMinimum(5);
                break;
            }
            case WEEK: {
                v = cal.get(3);
                min = cal.getMinimum(3);
                break;
            }
            case MONTH: {
                v = cal.get(2);
                min = cal.getMinimum(2);
                break;
            }
            case YEAR: {
                v = cal.get(1);
                min = 0;
            }
        }
        int delta = (v - min) % itv.getValue();
        return delta;
    }

    @Override
    public MathElement[] formatValues(String format, Object values) {
        Calendar cal = Calendar.getInstance(this.zone, this.locale);
        int n = Array.getLength(values);
        MathElement[] labels = new MathElement[n];
        for (int i = 0; i < n; ++i) {
            cal.setTimeInMillis(Array.getLong(values, i));
            String texString = new Formatter(this.locale).format(format, cal).toString();
            labels[i] = texString.indexOf(36) == -1 ? new MathElement.Mtext(texString) : TeXMathUtils.parseText(texString);
        }
        return labels;
    }
}

