/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import org.jplot2d.axtick.DoubleInterval;
import org.jplot2d.axtick.DoubleTickCalculator;
import org.jplot2d.axtick.RangeAdvisor;
import org.jplot2d.util.NumberArrayUtils;

public abstract class AbstractLinearTickCalculator
extends DoubleTickCalculator
implements RangeAdvisor {
    protected double interval;
    protected int minorNumber;
    protected double[] tickValues;
    protected double[] minorValues;

    @Override
    protected void setRange(double start, double end) {
        if (Double.isNaN(start) || Double.isInfinite(start) || Double.isNaN(end) || Double.isInfinite(end)) {
            throw new IllegalArgumentException("Invalid range [" + start + "," + end + "].");
        }
        super.setRange(start, end);
    }

    protected DoubleInterval calcInterval(int tickNumber) {
        double hi;
        double lo;
        if (this.start == this.end) {
            throw new IllegalArgumentException("The range span must be great than zero");
        }
        if (tickNumber <= 0) {
            throw new IllegalArgumentException("The ticks number must be great than zero");
        }
        if (tickNumber == 1) {
            tickNumber = 2;
        }
        if (this.end > this.start) {
            lo = this.start;
            hi = this.end;
        } else {
            lo = this.end;
            hi = this.start;
        }
        tickNumber = Math.abs(tickNumber);
        double rough = (hi - lo) / (double)(tickNumber - 1);
        DoubleInterval[] candidates = this.calcCandidateInterval(rough);
        DoubleInterval itvA = candidates[0];
        DoubleInterval itvB = candidates[1];
        double expandLo = lo - Math.abs(lo) * 9.094947017729282E-13;
        double expandHi = hi + Math.abs(hi) * 9.094947017729282E-13;
        long iLoA = (long)Math.ceil(expandLo / itvA.doubleValue());
        long iHiA = (long)Math.floor(expandHi / itvA.doubleValue());
        int tickNumA = (int)(iHiA - iLoA + 1L);
        long iLoB = (long)Math.ceil(expandLo / itvB.doubleValue());
        long iHiB = (long)Math.floor(expandHi / itvB.doubleValue());
        int tickNumB = (int)(iHiB - iLoB + 1L);
        if (tickNumA - tickNumber <= tickNumber - tickNumB) {
            this.interval = itvA.doubleValue();
            return itvA;
        }
        this.interval = itvB.doubleValue();
        return itvB;
    }

    protected abstract DoubleInterval[] calcCandidateInterval(double var1);

    @Override
    public void calcValuesByTickInterval(double interval, double offset, int minorTickNumber) {
        interval = Math.abs(interval);
        this.minorNumber = minorTickNumber == -1 ? this.calcMinorNumber(interval) : minorTickNumber;
        this.calcValues(interval, offset, this.minorNumber);
    }

    protected abstract int calcMinorNumber(double var1);

    protected void calcValues(double interval, double offset, int minorTickNumber) {
        double hi;
        double lo;
        boolean inverted;
        if (interval == 0.0 || Double.isNaN(interval)) {
            throw new IllegalArgumentException("delta cannot be zero or NaN");
        }
        boolean bl = inverted = this.start > this.end;
        if (!inverted) {
            lo = this.start;
            hi = this.end;
        } else {
            lo = this.end;
            hi = this.start;
        }
        double d = interval;
        double expandLo = lo - Math.abs(lo) * 9.094947017729282E-13 - offset;
        double expandHi = hi + Math.abs(hi) * 9.094947017729282E-13 - offset;
        long iLo = (long)Math.ceil(expandLo / d);
        long iHi = (long)Math.floor(expandHi / d);
        int tickNum = (int)(iHi - iLo + 1L);
        this.tickValues = new double[tickNum];
        double minorInterval = d / (double)(minorTickNumber + 1);
        if (tickNum == 0) {
            long miLo = (long)Math.ceil(expandLo / minorInterval);
            long miHi = (long)Math.floor(expandHi / minorInterval);
            int mTickNum = (int)(miHi - miLo + 1L);
            this.minorValues = new double[mTickNum];
            int mvi = 0;
            for (long mi = miLo; mi <= miHi; ++mi) {
                this.minorValues[mvi++] = minorInterval * (double)mi + offset;
            }
        } else {
            double lowMargine = -expandLo + d * (double)iLo;
            double hiMargine = expandHi - d * (double)iHi;
            int minorNumBeforeLow = (int)(lowMargine / minorInterval);
            int minorNumAfterHi = (int)(hiMargine / minorInterval);
            this.minorValues = new double[minorNumBeforeLow + (tickNum - 1) * minorTickNumber + minorNumAfterHi];
            int mvi = 0;
            int tvi = 0;
            double v = d * (double)iLo + offset;
            for (int im = minorNumBeforeLow; im > 0; --im) {
                this.minorValues[mvi++] = v - minorInterval * (double)im;
            }
            long i = iLo;
            block2: while (true) {
                v = d * (double)i + offset;
                this.tickValues[tvi++] = v;
                if (i++ == iHi) break;
                int im = 1;
                while (true) {
                    if (im > minorTickNumber) continue block2;
                    this.minorValues[mvi++] = v + minorInterval * (double)im;
                    ++im;
                }
                break;
            }
            for (int im = 1; im <= minorNumAfterHi; ++im) {
                this.minorValues[mvi++] = v + minorInterval * (double)im;
            }
            if (inverted) {
                this.tickValues = NumberArrayUtils.reverse(this.tickValues);
                this.minorValues = NumberArrayUtils.reverse(this.minorValues);
            }
        }
    }

    @Override
    public void expandRangeByTickNumber(int tickNumber) {
        double xHi;
        double xLo;
        double hi;
        double lo;
        if (tickNumber == 0) {
            throw new IllegalArgumentException("nticks cannot be zero");
        }
        if (tickNumber == 1) {
            tickNumber = 2;
        }
        if (this.end > this.start) {
            lo = this.start;
            hi = this.end;
        } else {
            lo = this.end;
            hi = this.start;
        }
        tickNumber = Math.abs(tickNumber);
        double rough = (hi - lo) / (double)(tickNumber - 1);
        DoubleInterval[] candidates = this.calcCandidateInterval(rough);
        DoubleInterval itvA = candidates[0];
        DoubleInterval itvB = candidates[1];
        double shrinkLo = lo + Math.abs(lo) * 9.094947017729282E-13;
        double shrinkHi = hi - Math.abs(hi) * 9.094947017729282E-13;
        long iLoA = (long)Math.floor(shrinkLo / itvA.doubleValue());
        long iHiA = (long)Math.ceil(shrinkHi / itvA.doubleValue());
        int tickNumA = (int)(iHiA - iLoA + 1L);
        long iLoB = (long)Math.floor(shrinkLo / itvB.doubleValue());
        long iHiB = (long)Math.ceil(shrinkHi / itvB.doubleValue());
        int tickNumB = (int)(iHiB - iLoB + 1L);
        if (tickNumA - tickNumber <= tickNumber - tickNumB) {
            this.interval = itvA.doubleValue();
            xLo = this.interval * (double)iLoA;
            xHi = this.interval * (double)iHiA;
        } else {
            this.interval = itvB.doubleValue();
            xLo = this.interval * (double)iLoB;
            xHi = this.interval * (double)iHiB;
        }
        if (this.end > this.start) {
            this.start = xLo;
            this.end = xHi;
        } else {
            this.start = xHi;
            this.end = xLo;
        }
    }

    @Override
    public void expandRangeByTickInterval(double interval) {
        double hi;
        double lo;
        if (this.end > this.start) {
            lo = this.start;
            hi = this.end;
        } else {
            lo = this.end;
            hi = this.start;
        }
        double d = Math.abs(interval);
        double shrinkLo = lo + Math.abs(lo) * 9.094947017729282E-13;
        double shrinkHi = hi - Math.abs(hi) * 9.094947017729282E-13;
        long iLo = (long)Math.floor(shrinkLo / d);
        long iHi = (long)Math.ceil(shrinkHi / d);
        double xLo = d * (double)iLo;
        double xHi = d * (double)iHi;
        interval = d;
        if (this.end > this.start) {
            this.start = xLo;
            this.end = xHi;
        } else {
            this.start = xHi;
            this.end = xLo;
        }
    }

    @Override
    public double getInterval() {
        return this.interval;
    }

    @Override
    public int getMinorNumber() {
        return this.minorNumber;
    }

    @Override
    public double[] getValues() {
        return this.tickValues;
    }

    @Override
    public double[] getMinorValues() {
        return this.minorValues;
    }
}

