/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.Color;
import javax.swing.JFrame;
import org.jplot2d.element.Axis;
import org.jplot2d.element.ElementFactory;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.element.SymbolAnnotation;
import org.jplot2d.element.Title;
import org.jplot2d.element.XYGraph;
import org.jplot2d.env.RenderEnvironment;
import org.jplot2d.renderer.SVGExporter;
import org.jplot2d.sizing.FillContainerSizeMode;
import org.jplot2d.swing.JPlot2DComponent;

public class Main {
    public static void main(String[] args) {
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "ERROR");
        ElementFactory ef = ElementFactory.getInstance();
        Plot plot = ef.createPlot();
        plot.setSizeMode(new FillContainerSizeMode(1.0));
        Title title = ef.createTitle("Custom Title");
        title.setFontScale(2.0f);
        plot.addTitle(title);
        Title subtitle = ef.createTitle("Custom Subtitle");
        subtitle.setFontScale(1.2f);
        plot.addTitle(subtitle);
        Title copyRight = ef.createTitle("\u00a9 2012 jplot2d project (LGPL)");
        copyRight.setFontScale(1.0f);
        copyRight.setColor(Color.BLUE.darker());
        plot.addTitle(copyRight);
        Axis xaxis = ef.createAxis();
        Axis yaxis = ef.createAxis();
        xaxis.getTitle().setText("x axis");
        yaxis.getTitle().setText("y axis");
        plot.addXAxis(xaxis);
        plot.addYAxis(yaxis);
        int n = 21;
        double[] x = new double[n];
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = (double)i / 10.0 - 1.0;
            y[i] = x[i] * x[i];
        }
        XYGraph graph = ef.createXYGraph(x, y, "Data");
        graph.setFillEnabled(true);
        Layer layer = ef.createLayer();
        layer.addGraph(graph);
        plot.addLayer(layer, xaxis.getTickManager().getAxisTransform(), yaxis.getTickManager().getAxisTransform());
        SymbolAnnotation ann0 = ef.createSymbolAnnotation(0.1, 4.0, "text annotation");
        layer.addAnnotation(ann0);
        RenderEnvironment env = new RenderEnvironment(true);
        env.setPlot(plot);
        JPlot2DComponent cc = new JPlot2DComponent(env);
        JFrame frame = new JFrame();
        frame.setSize(480, 480);
        frame.add(cc);
        frame.setVisible(true);
        try {
            env.exportPlot(new SVGExporter("demo.svg"));
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

