/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.transform;

import org.jplot2d.transform.Transform1D;

public class LinearTransform
implements Transform1D {
    private double k;
    private double a;

    public LinearTransform(double offset, double scale, double d1, double d2) {
        if (Double.isNaN(d1) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Transform is invalid");
        }
        this.k = (d2 - d1) / scale;
        this.a = d1 - this.k * offset;
    }

    @Override
    public double convert(double u) {
        return this.k * u + this.a;
    }
}

