/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.tex;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jplot2d.element.HAlign;
import org.jplot2d.element.VAlign;
import org.jplot2d.tex.MathElement;
import org.jplot2d.tex.MathLabelComp;

public class MathLabelXLines {
    private double _width;
    private double _height;
    private double _leftx;
    private double _topy;
    private HAlign _halign;
    private VAlign _valign;
    private List<MathLabelComp> _subEL = new ArrayList<MathLabelComp>();

    protected MathLabelXLines(MathElement me, Font font, HAlign halign, VAlign valign) {
        this._halign = halign;
        this._valign = valign;
        if (me == null) {
            this._width = 0.0;
            this._height = 0.0;
            return;
        }
        if (me instanceof MathElement.XLines) {
            MathElement[] es = ((MathElement.XLines)me).getElements();
            this._width = 0.0;
            double locy = 0.0;
            for (int i = 0; i < es.length; ++i) {
                MathLabelComp ml = MathLabelComp.getBoxInstance(es[i], 0.0, 0.0, font, false);
                if (i > 0) {
                    locy += ml.getLeading();
                }
                ml.pan(0.0, locy += ml.getAscent());
                this._subEL.add(ml);
                locy += ml.getDescent();
                if (!(this._width < ml.getWidth())) continue;
                this._width = ml.getWidth();
            }
            this._height = locy;
        } else {
            MathLabelComp mlc = MathLabelComp.getBoxInstance(me, 0.0, 0.0, font, false);
            mlc.pan(0.0, mlc.getAscent());
            this._subEL.add(mlc);
            this._width = mlc.getWidth();
            this._height = mlc.getAscent() + mlc.getDescent();
        }
        this.relocate();
    }

    protected void relayout(float fontSize) {
        this._width = 0.0;
        double locy = 0.0;
        for (int i = 0; i < this._subEL.size(); ++i) {
            MathLabelComp ml = this._subEL.get(i);
            ml.relayout(fontSize, 0.0, 0.0);
            if (i > 0) {
                locy += ml.getLeading();
            }
            ml.pan(0.0, locy += ml.getAscent());
            locy += ml.getDescent();
            if (!(this._width < ml.getWidth())) continue;
            this._width = ml.getWidth();
        }
        this._height = locy;
        this._topy = 0.0;
        this.relocate();
    }

    protected void pan(double xoff, double yoff) {
        if (xoff != 0.0 || yoff != 0.0) {
            for (MathLabelComp ml : this._subEL) {
                ml.pan(xoff, yoff);
            }
        }
    }

    protected void draw(Graphics2D g2) {
        for (MathLabelComp ml : this._subEL) {
            ml.draw(g2);
        }
    }

    protected Rectangle2D getBounds() {
        return new Rectangle2D.Double(this._leftx, this._topy, this._width, this._height);
    }

    protected void setHAlign(HAlign halign) {
        this._halign = halign;
        this.relocate();
    }

    protected void setVAlign(VAlign valign) {
        this._valign = valign;
        this.relocate();
    }

    private void relocate() {
        double xoff = 0.0;
        double yoff = 0.0;
        for (MathLabelComp ml : this._subEL) {
            switch (this._halign) {
                case LEFT: {
                    xoff = -ml._x;
                    break;
                }
                case CENTER: {
                    xoff = -ml.getWidth() / 2.0 - ml._x;
                    break;
                }
                case RIGHT: {
                    xoff = -ml.getWidth() - ml._x;
                }
            }
            ml.pan(xoff, 0.0);
        }
        switch (this._halign) {
            case LEFT: {
                this._leftx = 0.0;
                break;
            }
            case CENTER: {
                this._leftx = -this._width / 2.0;
                break;
            }
            case RIGHT: {
                this._leftx = -this._width;
            }
        }
        switch (this._valign) {
            case TOP: {
                yoff = -this._topy;
                this._topy = 0.0;
                break;
            }
            case MIDDLE: {
                yoff = -this._height / 2.0 - this._topy;
                this._topy = -this._height / 2.0;
                break;
            }
            case BOTTOM: {
                yoff = -this._height - this._topy;
                this._topy = -this._height;
            }
        }
        for (MathLabelComp ml : this._subEL) {
            ml.pan(0.0, yoff);
        }
    }
}

