/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.property;

import java.awt.geom.Dimension2D;
import org.jplot2d.env.PropertyInfo;
import org.jplot2d.swing.proptable.property.MainProperty;
import org.jplot2d.swing.proptable.property.Property;
import org.jplot2d.swing.proptable.property.PropertyDescriptorAdapter;
import org.jplot2d.swing.proptable.property.SubProperty;
import org.jplot2d.util.DoubleDimension2D;

public class Dimension2DProperty
extends PropertyDescriptorAdapter<Dimension2D> {
    private Property<?>[] subProperties;
    private Double _w;
    private Double _h;

    public Dimension2DProperty(PropertyInfo descriptor) {
        super(descriptor);
        this.initSubProperties();
    }

    @Override
    public Property<?>[] getSubProperties() {
        return this.subProperties;
    }

    @Override
    public void readFromObject(Object object) {
        super.readFromObject(object);
        if (this.getValue() != null) {
            this._w = ((Dimension2D)this.getValue()).getWidth();
            this._h = ((Dimension2D)this.getValue()).getHeight();
        }
    }

    private void updateValue() {
        if (this._w != null && this._h != null) {
            this.setValue(new DoubleDimension2D(this._w, this._h));
        }
        if (this._w == null && this._h == null) {
            this.setValue(null);
        }
    }

    private void initSubProperties() {
        this.subProperties = new Property[2];
        this.subProperties[0] = new SubProperty<Double>((MainProperty)this){

            @Override
            public String getName() {
                return "width";
            }

            @Override
            public Class<Double> getType() {
                return Double.class;
            }

            @Override
            public Double getValue() {
                return Dimension2DProperty.this._w;
            }

            @Override
            public void setValue(Double width) {
                Dimension2DProperty.this._w = width;
                Dimension2DProperty.this.updateValue();
            }
        };
        this.subProperties[1] = new SubProperty<Double>((MainProperty)this){

            @Override
            public String getName() {
                return "height";
            }

            @Override
            public Class<Double> getType() {
                return Double.class;
            }

            @Override
            public Double getValue() {
                return Dimension2DProperty.this._h;
            }

            @Override
            public void setValue(Double height) {
                Dimension2DProperty.this._h = height;
                Dimension2DProperty.this.updateValue();
            }
        };
    }
}

