/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.interaction;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jplot2d.env.RenderEnvironment;
import org.jplot2d.swing.components.PlotPropertiesFrame;
import org.jplot2d.swing.print.PrintRenderer;

public class PopupMenu
extends JPopupMenu
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected RenderEnvironment env;
    protected final String PROPERTIES_ACTION_COMMAND = "PROPERTIES";
    protected final String UNDO_ACTION_COMMAND = "UNDO";
    protected final String REDO_ACTION_COMMAND = "REDO";
    protected final String EXPORT_ACTION_COMMAND = "EXPORT";
    protected final String PRINT_PAGE_SETUP_COMMAND = "PAGE_SETUP";
    protected final String PRINT_ACTION_COMMAND = "PRINT";
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;
    protected JMenuItem autoRangeBothMenuItem;
    protected JMenuItem autoRangeHorizontalMenuItem;
    protected JMenuItem autoRangeVerticalMenuItem;
    protected JMenuItem pickCoordinateMenuItem;
    private static JFileChooser _saveFileChooser;

    public PopupMenu(RenderEnvironment env) {
        super("jplot2d");
        this.env = env;
        boolean separator = false;
        JMenuItem propertiesItem = new JMenuItem("Properties...");
        propertiesItem.setActionCommand("PROPERTIES");
        propertiesItem.addActionListener(this);
        super.add(propertiesItem);
        separator = true;
        if (separator) {
            super.addSeparator();
            separator = false;
        }
        this.undoItem = new JMenuItem("Undo");
        this.undoItem.setActionCommand("UNDO");
        this.undoItem.addActionListener(this);
        super.add(this.undoItem);
        this.redoItem = new JMenuItem("Redo");
        this.redoItem.setActionCommand("REDO");
        this.redoItem.addActionListener(this);
        super.add(this.redoItem);
        separator = true;
        if (separator) {
            super.addSeparator();
            separator = false;
        }
        JMenuItem saveItem = new JMenuItem("Export...");
        saveItem.setActionCommand("EXPORT");
        saveItem.addActionListener(this);
        super.add(saveItem);
        separator = true;
        if (separator) {
            super.addSeparator();
            separator = false;
        }
        JMenuItem pageSetupItem = new JMenuItem("Page setup ...");
        pageSetupItem.setActionCommand("PAGE_SETUP");
        pageSetupItem.addActionListener(this);
        super.add(pageSetupItem);
        JMenuItem printItem = new JMenuItem("Print...");
        printItem.setActionCommand("PRINT");
        printItem.addActionListener(this);
        super.add(printItem);
        separator = true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("PROPERTIES")) {
            this.showProperties();
            return;
        }
        if (command.equals("UNDO")) {
            this.env.undo();
            return;
        }
        if (command.equals("REDO")) {
            this.env.redo();
            return;
        }
        if (command.equals("EXPORT")) {
            try {
                this.doSaveAs();
            }
            catch (IOException e) {
                String msg = "I/O exception: " + e.getMessage();
                JOptionPane.showMessageDialog(this.getInvoker(), msg);
            }
            return;
        }
        if (command.equals("PAGE_SETUP")) {
            PrintRenderer.pageDialog();
            return;
        }
        if (command.equals("PRINT")) {
            try {
                PrintRenderer.printDialog(this.env);
            }
            catch (PrinterException e) {
                JOptionPane.showMessageDialog(this.getInvoker(), e.getMessage());
            }
            return;
        }
    }

    protected void showProperties() {
        PlotPropertiesFrame frame = new PlotPropertiesFrame(this.env);
        frame.setVisible(true);
    }

    public void updateStatus(int x, int y) {
        this.undoItem.setEnabled(this.env.canUndo());
        this.redoItem.setEnabled(this.env.canRedo());
    }

    public void doSaveAs() throws IOException {
        int option;
        AtomicReference<IOException> ar = new AtomicReference<IOException>();
        if (_saveFileChooser == null) {
            PopupMenu.initSaveFileChooser();
        }
        if ((option = _saveFileChooser.showSaveDialog(this.getInvoker())) == 0) {
            File fFile = _saveFileChooser.getSelectedFile();
            String filename = fFile.getPath();
            String fileDesc = _saveFileChooser.getFileFilter().getDescription();
            if (fileDesc.contains("PNG")) {
                if (!filename.substring(filename.length() - 4).equalsIgnoreCase(".png")) {
                    filename = filename + ".png";
                }
            } else if (fileDesc.contains("JPEG")) {
                if (!filename.substring(filename.length() - 4).equalsIgnoreCase(".jpg") && !filename.substring(filename.length() - 5).equalsIgnoreCase(".jpeg")) {
                    filename = filename + ".jpg";
                }
            } else if (fileDesc.contains("EPS")) {
                if (!filename.substring(filename.length() - 4).equalsIgnoreCase(".eps")) {
                    filename = filename + ".eps";
                }
            } else if (fileDesc.contains("PDF") && !filename.substring(filename.length() - 4).equalsIgnoreCase(".pdf")) {
                filename = filename + ".pdf";
            }
            if (this.confirmOverwrite(filename)) {
                try {
                    if (fileDesc.contains("PNG")) {
                        this.env.exportToPNG(filename);
                    } else if (fileDesc.contains("PDF")) {
                        this.env.exportToPDF(filename);
                    } else if (fileDesc.contains("EPS")) {
                        this.env.exportToEPS(filename);
                    }
                }
                catch (IOException e) {
                    ar.set(e);
                }
            }
        }
        if (ar.get() != null) {
            throw (IOException)ar.get();
        }
    }

    private boolean confirmOverwrite(String filename) {
        int response;
        File fFile = new File(filename);
        return !fFile.exists() || (response = JOptionPane.showConfirmDialog(this.getInvoker(), "Overwrite existing file?", "Confirm Overwrite", 2, 3)) != 2;
    }

    private static void initSaveFileChooser() {
        _saveFileChooser = new JFileChooser(RenderEnvironment.getDefaultExportDirectory());
        _saveFileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter PNG_FILE_FILTER = new FileNameExtensionFilter("PNG file", "png");
        FileNameExtensionFilter PDF_FILE_FILTER = new FileNameExtensionFilter("PDF file", "pdf");
        FileNameExtensionFilter EPS_FILE_FILTER = new FileNameExtensionFilter("EPS file", "eps");
        ArrayList<FileNameExtensionFilter> EXPORT_FILE_FILTERS = new ArrayList<FileNameExtensionFilter>(2);
        EXPORT_FILE_FILTERS.add(PNG_FILE_FILTER);
        EXPORT_FILE_FILTERS.add(PDF_FILE_FILTER);
        EXPORT_FILE_FILTERS.add(EPS_FILE_FILTER);
        for (FileNameExtensionFilter fnef : EXPORT_FILE_FILTERS) {
            _saveFileChooser.addChoosableFileFilter(fnef);
        }
        _saveFileChooser.setFileFilter(PNG_FILE_FILTER);
    }
}

