/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.sizing;

import java.awt.geom.Dimension2D;
import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.sizing.SizeMode;

public class FillContainerSizeMode
extends SizeMode {
    private final Dimension2D targetSize;
    private final double scale;

    public FillContainerSizeMode(double scale) {
        super(false);
        this.targetSize = null;
        this.scale = scale;
    }

    public FillContainerSizeMode(Dimension2D targetSize) {
        super(false);
        if (targetSize.getWidth() <= 0.0 || targetSize.getHeight() <= 0.0) {
            throw new IllegalArgumentException("Target size must be positive, " + targetSize.getWidth() + "x" + targetSize.getHeight() + " is invalid.");
        }
        this.targetSize = targetSize;
        this.scale = 1.0;
    }

    public Dimension2D getTargetSize() {
        return this.targetSize;
    }

    @Override
    public SizeMode.Result update(PlotEx plot) {
        Dimension2D containerSize = plot.getContainerSize();
        if (this.targetSize != null) {
            double scaleY;
            Dimension2D tcSize = this.targetSize;
            double scaleX = containerSize.getWidth() / tcSize.getWidth();
            double scale = scaleX < (scaleY = containerSize.getHeight() / tcSize.getHeight()) ? scaleX : scaleY;
            double width = containerSize.getWidth() / scale;
            double height = containerSize.getHeight() / scale;
            return new SizeMode.Result(width, height, scale);
        }
        double width = containerSize.getWidth() / this.scale;
        double height = containerSize.getHeight() / this.scale;
        return new SizeMode.Result(width, height, this.scale);
    }

    public String toString() {
        if (this.targetSize == null) {
            return "Fill container with scale " + this.scale;
        }
        return "Fill container with target size " + this.targetSize.getWidth() + "x" + this.targetSize.getHeight();
    }
}

