/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.renderer;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.renderer.CacheableBlock;
import org.jplot2d.renderer.Renderer;

public class PdfExporter
extends Renderer {
    private final OutputStream os;
    private String title;

    public PdfExporter(String pathname) throws FileNotFoundException {
        this(new File(pathname));
    }

    public PdfExporter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public PdfExporter(OutputStream out) {
        this.os = new BufferedOutputStream(out);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void render(ComponentEx comp, List<CacheableBlock> cacheBlockList) {
        Dimension size = PdfExporter.getDeviceBounds(comp).getSize();
        Document document = new Document(new Rectangle((float)size.width, (float)size.height), 0.0f, 0.0f, 0.0f, 0.0f);
        PdfWriter writer = null;
        try {
            writer = PdfWriter.getInstance((Document)document, (OutputStream)this.os);
        }
        catch (DocumentException e) {
            throw new RuntimeException("Error creating PDF document", e);
        }
        document.open();
        if (this.title != null) {
            document.addTitle(this.title);
        }
        PdfContentByte cb = writer.getDirectContent();
        Graphics2D g = cb.createGraphics((float)size.width, (float)size.height);
        for (CacheableBlock cblock : cacheBlockList) {
            List<ComponentEx> sublist = cblock.getSubcomps();
            for (ComponentEx subcomp : sublist) {
                subcomp.draw(g);
            }
        }
        g.dispose();
        document.close();
    }
}

