/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import org.jplot2d.renderer.ImageFactory;

public class GraphicsConfigurationCompatibleImageFactory
implements ImageFactory {
    private static final ThreadLocal<BufferedImage> tlImage = new ThreadLocal();
    private final GraphicsConfiguration gconf;
    private final Color bgColor;

    public GraphicsConfigurationCompatibleImageFactory(GraphicsConfiguration gconf, Color bgColor) {
        this.gconf = gconf;
        this.bgColor = bgColor == null ? TRANSPARENT_COLOR : bgColor;
    }

    @Override
    public BufferedImage createTransparentImage(int width, int height) {
        return this.gconf.createCompatibleImage(width, height, 3);
    }

    @Override
    public BufferedImage createImage(int width, int height) {
        BufferedImage image = tlImage.get();
        if (image == null || image.getWidth() != width || image.getHeight() != height) {
            image = this.gconf.createCompatibleImage(width, height);
        } else {
            tlImage.remove();
        }
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setBackground(this.bgColor);
        g.clearRect(0, 0, width, height);
        g.dispose();
        return image;
    }

    @Override
    public void cacheImage(BufferedImage image) {
        tlImage.set(image);
    }
}

