/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.layout;

import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.layout.BoundsConstraint;
import org.jplot2d.layout.SimpleLayoutDirector;
import org.jplot2d.util.DoubleDimension2D;
import org.jplot2d.util.Insets2D;

public class OverlayLayoutDirector
extends SimpleLayoutDirector {
    @Override
    public void layout(PlotEx plot) {
        super.layout(plot);
        this.layoutSubplots(plot);
    }

    private void layoutSubplots(PlotEx plot) {
        if (plot.getSubplots().length == 0) {
            return;
        }
        double baseX = 0.0;
        double baseY = 0.0;
        double baseW = plot.getContentSize().getWidth();
        double baseH = plot.getContentSize().getHeight();
        for (PlotEx sp : plot.getSubplots()) {
            double spacingL = 0.0;
            double spacingR = 0.0;
            double spacingT = 0.0;
            double spacingB = 0.0;
            BoundsConstraint bc = (BoundsConstraint)this.getConstraint(sp);
            if (bc != null) {
                Insets2D fixed = bc.getFixedInsets();
                Insets2D elastic = bc.getElasticInsets();
                spacingL = fixed.getLeft() + elastic.getLeft() * baseW;
                spacingR = fixed.getRight() + elastic.getRight() * baseW;
                spacingT = fixed.getTop() + elastic.getTop() * baseH;
                spacingB = fixed.getBottom() + elastic.getBottom() * baseH;
            }
            double spbX = baseX + spacingL;
            double spbY = baseY + spacingB;
            double spbW = baseW - spacingL - spacingR;
            double spbH = baseH - spacingT - spacingB;
            sp.setLocation(spbX, spbY);
            sp.setContentConstrant(new DoubleDimension2D(spbW, spbH));
        }
    }
}

