/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.jplot2d.interaction.InteractionModeHandler;
import org.jplot2d.interaction.InteractiveComp;
import org.jplot2d.interaction.MouseDragBehavior;
import org.jplot2d.interaction.MouseDragBehaviorHandler;
import org.jplot2d.interaction.VisualFeedbackDrawer;

public abstract class MouseMarqueeHandler<B extends MouseDragBehavior>
extends MouseDragBehaviorHandler<B>
implements VisualFeedbackDrawer {
    private Point marqueeStart;
    private Point marqueeEnd;
    private InteractiveComp icomp;

    public MouseMarqueeHandler(B behavior, InteractionModeHandler handler) {
        super(behavior, handler);
        this.icomp = (InteractiveComp)handler.getValue("INTERACTIVE_COMP");
    }

    @Override
    public void draggingStarted(int x, int y) {
        this.marqueeStart = new Point(x, y);
    }

    @Override
    public void draggingTo(int x, int y) {
        this.marqueeEnd = new Point(x, y);
        this.icomp.repaint();
    }

    @Override
    public void draggingFinished(int x, int y) {
        Rectangle marqueeRect = new Rectangle(0, 0, 0, 0);
        marqueeRect.setFrameFromDiagonal(this.marqueeStart.x, this.marqueeStart.y, x, y);
        if (marqueeRect.width > 1 || marqueeRect.height > 1) {
            this.handleMarquee(this.marqueeStart, new Point(x, y));
        }
        this.marqueeStart = null;
        this.icomp.repaint();
    }

    @Override
    public void draggingCancelled() {
        this.marqueeStart = null;
        this.icomp.repaint();
    }

    @Override
    public void draw(Object g) {
        if (this.marqueeStart == null) {
            return;
        }
        Rectangle marqueeRect = new Rectangle(0, 0, 0, 0);
        marqueeRect.setFrameFromDiagonal(this.marqueeStart, this.marqueeEnd);
        this.icomp.drawRectangle(g, Color.GRAY.getRGB(), marqueeRect.x, marqueeRect.y, marqueeRect.width, marqueeRect.height);
    }

    protected abstract void handleMarquee(Point var1, Point var2);
}

