/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Locale;
import org.jplot2d.element.AxisTransform;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.env.PlotEnvironment;
import org.jplot2d.interaction.InteractionModeHandler;
import org.jplot2d.interaction.InteractiveComp;
import org.jplot2d.interaction.MouseCoordinatesTooltipBehavior;
import org.jplot2d.interaction.MouseMoveBehaviorHandler;
import org.jplot2d.interaction.VisualFeedbackDrawer;
import org.jplot2d.util.NumberUtils;

public class MouseCoordinatesTooltipHandler
extends MouseMoveBehaviorHandler<MouseCoordinatesTooltipBehavior>
implements VisualFeedbackDrawer {
    private final InteractiveComp icomp;
    private boolean show;

    public MouseCoordinatesTooltipHandler(MouseCoordinatesTooltipBehavior behavior, InteractionModeHandler handler) {
        super(behavior, handler);
        this.icomp = (InteractiveComp)handler.getValue("INTERACTIVE_COMP");
    }

    @Override
    public boolean enterModifiersKey() {
        this.show = true;
        this.icomp.setCursor(InteractiveComp.CursorStyle.CROSSHAIR_CURSOR);
        this.icomp.repaint();
        return true;
    }

    @Override
    public boolean exitModifiersKey() {
        this.show = false;
        this.icomp.setCursor(InteractiveComp.CursorStyle.DEFAULT_CURSOR);
        this.icomp.repaint();
        return true;
    }

    @Override
    public boolean behaviorPerformed(int x, int y) {
        this.icomp.repaint();
        return true;
    }

    @Override
    public void draw(Object g) {
        if (!this.show) {
            return;
        }
        Point p = this.icomp.getCursorLocation();
        PlotEnvironment env = (PlotEnvironment)this.handler.getValue("PLOT_ENV");
        Plot plot = env.getPlotAt(p);
        if (plot == null) {
            return;
        }
        double nx = plot.getPaperTransform().getXDtoP(p.x) / plot.getContentSize().getWidth();
        double nxL = plot.getPaperTransform().getXDtoP(p.x - 1) / plot.getContentSize().getWidth();
        double nxH = plot.getPaperTransform().getXDtoP(p.x + 1) / plot.getContentSize().getWidth();
        double ny = plot.getPaperTransform().getYDtoP(p.y) / plot.getContentSize().getHeight();
        double nyL = plot.getPaperTransform().getYDtoP(p.y - 1) / plot.getContentSize().getHeight();
        double nyH = plot.getPaperTransform().getYDtoP(p.y + 1) / plot.getContentSize().getHeight();
        if (nx < 0.0 || nx > 1.0) {
            return;
        }
        if (ny < 0.0 || ny > 1.0) {
            return;
        }
        HashSet<AxisTransform> xats = new HashSet<AxisTransform>();
        HashSet<AxisTransform> yats = new HashSet<AxisTransform>();
        for (Layer layer : plot.getLayers()) {
            AxisTransform xaxt = layer.getXAxisTransform();
            if (xaxt != null) {
                xats.add(xaxt);
            }
            AxisTransform yaxt = layer.getYAxisTransform();
            if (xaxt == null) continue;
            yats.add(yaxt);
        }
        StringBuilder sb = new StringBuilder();
        if (xats.size() > 1 || yats.size() > 1) {
            String format;
            double deltaH;
            sb.append("X=");
            for (AxisTransform xat : xats) {
                double v = xat.getNormalTransform().convFromNR(nx);
                double deltaL = Math.abs(xat.getNormalTransform().convFromNR(nxL) - v);
                deltaH = Math.abs(xat.getNormalTransform().convFromNR(nxH) - v);
                format = NumberUtils.calcDeltaFormatStr(v, Math.min(deltaL, deltaH) / 2.0);
                sb.append(String.format((Locale)null, format, v)).append("; ");
            }
            sb.deleteCharAt(sb.length() - 1).deleteCharAt(sb.length() - 1);
            sb.append("\n");
            sb.append("Y=");
            for (AxisTransform yat : yats) {
                double v = yat.getNormalTransform().convFromNR(ny);
                double deltaL = Math.abs(yat.getNormalTransform().convFromNR(nyL) - v);
                deltaH = Math.abs(yat.getNormalTransform().convFromNR(nyH) - v);
                format = NumberUtils.calcDeltaFormatStr(v, Math.min(deltaL, deltaH) / 2.0);
                sb.append(String.format((Locale)null, format, v)).append("; ");
            }
            sb.deleteCharAt(sb.length() - 1).deleteCharAt(sb.length() - 1);
        } else {
            String format;
            double deltaH;
            for (AxisTransform xat : xats) {
                double v = xat.getNormalTransform().convFromNR(nx);
                double deltaL = Math.abs(xat.getNormalTransform().convFromNR(nxL) - v);
                deltaH = Math.abs(xat.getNormalTransform().convFromNR(nxH) - v);
                format = NumberUtils.calcDeltaFormatStr(v, Math.min(deltaL, deltaH) / 2.0);
                sb.append(String.format((Locale)null, format, v));
            }
            sb.append(", ");
            for (AxisTransform yat : yats) {
                double v = yat.getNormalTransform().convFromNR(ny);
                double deltaL = Math.abs(yat.getNormalTransform().convFromNR(nyL) - v);
                deltaH = Math.abs(yat.getNormalTransform().convFromNR(nyH) - v);
                format = NumberUtils.calcDeltaFormatStr(v, Math.min(deltaL, deltaH) / 2.0);
                sb.append(String.format((Locale)null, format, v));
            }
        }
        Dimension2D csize = plot.getContentSize();
        Rectangle2D.Double cbnds = new Rectangle2D.Double(0.0, 0.0, csize.getWidth(), csize.getHeight());
        Rectangle2D plotRect = plot.getPaperTransform().getPtoD(cbnds).getBounds2D();
        this.icomp.drawLine(g, Color.GRAY.getRGB(), (int)plotRect.getX(), p.y, (int)plotRect.getMaxX(), p.y);
        this.icomp.drawLine(g, Color.GRAY.getRGB(), p.x, (int)plotRect.getY(), p.x, (int)plotRect.getMaxY());
        this.icomp.drawTooltip(g, sb.toString(), p.x, p.y);
    }
}

