/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.HAlign;
import org.jplot2d.element.VAlign;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.PointAnnotationImpl;
import org.jplot2d.element.impl.SymbolAnnotationEx;
import org.jplot2d.tex.MathElement;
import org.jplot2d.tex.MathLabel;
import org.jplot2d.tex.TeXMathUtils;
import org.jplot2d.transform.PaperTransform;
import org.jplot2d.util.SymbolShape;

public class SymbolAnnotationImpl
extends PointAnnotationImpl
implements SymbolAnnotationEx {
    private SymbolShape symbolShape;
    private float symbolSize = Float.NaN;
    private float symbolScale = 1.0f;
    private double angle;
    private float offsetX = 1.25f;
    private float offsetY = 0.0f;
    private HAlign hAlign = HAlign.LEFT;
    private VAlign vAlign = VAlign.MIDDLE;
    protected MathElement textModel;
    private MathLabel label;

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "SymbolAnnotation" + this.getParent().indexOf(this);
        }
        return "SymbolAnnotation@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public PaperTransform getPaperTransform() {
        PaperTransform pxf = super.getPaperTransform();
        if (pxf == null || this.angle == 0.0) {
            return pxf;
        }
        return pxf.rotate(this.angle / 180.0 * Math.PI);
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        SymbolAnnotationImpl tc = (SymbolAnnotationImpl)src;
        this.symbolShape = tc.symbolShape;
        this.symbolSize = tc.symbolSize;
        this.symbolScale = tc.symbolScale;
        this.offsetX = tc.offsetX;
        this.offsetY = tc.offsetY;
        this.hAlign = tc.hAlign;
        this.vAlign = tc.vAlign;
        this.angle = tc.angle;
        this.textModel = tc.textModel;
        this.label = tc.label;
    }

    @Override
    public SymbolShape getSymbolShape() {
        return this.symbolShape;
    }

    @Override
    public void setSymbolShape(SymbolShape symbol) {
        this.symbolShape = symbol;
        SymbolAnnotationImpl.redraw(this);
    }

    @Override
    public float getSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public void setSymbolSize(float size) {
        this.symbolSize = size;
        SymbolAnnotationImpl.redraw(this);
    }

    @Override
    public float getSymbolScale() {
        return this.symbolScale;
    }

    @Override
    public void setSymbolScale(float scale) {
        this.symbolScale = scale;
        SymbolAnnotationImpl.redraw(this);
    }

    @Override
    public float getTextOffsetFactorX() {
        return this.offsetX;
    }

    @Override
    public void setTextOffsetFactorX(float offset) {
        this.offsetX = offset;
        SymbolAnnotationImpl.redraw(this);
    }

    @Override
    public float getTextOffsetFactorY() {
        return this.offsetY;
    }

    @Override
    public void setTextOffsetFactorY(float offset) {
        this.offsetY = offset;
        SymbolAnnotationImpl.redraw(this);
    }

    @Override
    public HAlign getHAlign() {
        return this.hAlign;
    }

    @Override
    public void setHAlign(HAlign hAlign) {
        this.hAlign = hAlign;
        this.label = null;
        SymbolAnnotationImpl.redraw(this);
    }

    @Override
    public VAlign getVAlign() {
        return this.vAlign;
    }

    @Override
    public void setVAlign(VAlign vAlign) {
        this.vAlign = vAlign;
        this.label = null;
        SymbolAnnotationImpl.redraw(this);
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public void setAngle(double angle) {
        this.angle = angle;
        SymbolAnnotationImpl.redraw(this);
    }

    @Override
    public String getText() {
        return TeXMathUtils.toString(this.getTextModel());
    }

    @Override
    public void setText(String text) {
        this.setTextModel(TeXMathUtils.parseText(text));
    }

    public MathElement getTextModel() {
        return this.textModel;
    }

    public void setTextModel(MathElement model) {
        this.textModel = model;
        this.label = null;
        SymbolAnnotationImpl.redraw(this);
    }

    private float getEffectiveSymbolSize() {
        if (this.symbolShape == null) {
            return 0.0f;
        }
        if (!Float.isNaN(this.symbolSize)) {
            return this.symbolSize;
        }
        return this.getEffectiveFontSize() * this.symbolScale;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.label == null) {
            this.label = new MathLabel(this.getTextModel(), this.getEffectiveFont(), this.getVAlign(), this.getHAlign());
        }
        if (this.symbolShape == null) {
            return this.label.getBounds();
        }
        float ess = this.getEffectiveSymbolSize();
        Rectangle2D.Double symbolBounds = new Rectangle2D.Double(-ess / 2.0f, -ess / 2.0f, ess, ess);
        if (this.getTextModel() == null) {
            return symbolBounds;
        }
        Rectangle2D lb = this.label.getBounds();
        float offx = this.offsetX * ess / 2.0f;
        float offy = this.offsetY * ess / 2.0f;
        Rectangle2D.Double bounds = new Rectangle2D.Double(lb.getX() + (double)offx, lb.getY() + (double)offy, lb.getWidth(), lb.getHeight());
        bounds.add(symbolBounds);
        return bounds;
    }

    @Override
    public void draw(Graphics2D g) {
        Point2D loc = this.getLocation();
        if (loc == null) {
            return;
        }
        Shape oldClip = g.getClip();
        AffineTransform oldTransform = g.getTransform();
        g.transform(this.getParent().getPaperTransform().getTransform());
        g.setClip(this.getParent().getBounds());
        g.translate(loc.getX(), loc.getY());
        g.setColor(this.getEffectiveColor());
        float ess = this.getEffectiveSymbolSize();
        if (this.symbolShape != null) {
            AffineTransform maf = AffineTransform.getScaleInstance(ess, ess);
            this.symbolShape.draw(g, maf);
        }
        if (this.label == null) {
            this.label = new MathLabel(this.getTextModel(), this.getEffectiveFont(), this.getVAlign(), this.getHAlign());
        }
        g.rotate(Math.PI * this.angle / 180.0);
        float offx = this.offsetX * ess / 2.0f;
        float offy = this.offsetY * ess / 2.0f;
        g.translate(offx, offy);
        g.scale(1.0, -1.0);
        this.label.draw(g);
        g.setTransform(oldTransform);
        g.setClip(oldClip);
    }
}

