/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jplot2d.element.Axis;
import org.jplot2d.element.AxisOrientation;
import org.jplot2d.element.AxisTransform;
import org.jplot2d.element.Element;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.element.Title;
import org.jplot2d.element.TitlePosition;
import org.jplot2d.element.impl.AxisEx;
import org.jplot2d.element.impl.AxisRangeLockGroupEx;
import org.jplot2d.element.impl.AxisRangeUtils;
import org.jplot2d.element.impl.AxisTickManagerEx;
import org.jplot2d.element.impl.AxisTransformEx;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.element.impl.ContainerEx;
import org.jplot2d.element.impl.ContainerImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.GraphEx;
import org.jplot2d.element.impl.ImageGraphEx;
import org.jplot2d.element.impl.ImageMappingEx;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.element.impl.LayerEx;
import org.jplot2d.element.impl.LegendEx;
import org.jplot2d.element.impl.LegendImpl;
import org.jplot2d.element.impl.LegendItemEx;
import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.element.impl.PlotMarginEx;
import org.jplot2d.element.impl.PlotMarginImpl;
import org.jplot2d.element.impl.PrecisionState;
import org.jplot2d.element.impl.RGBImageGraphEx;
import org.jplot2d.element.impl.RGBImageMappingEx;
import org.jplot2d.element.impl.RangeStatus;
import org.jplot2d.element.impl.TitleEx;
import org.jplot2d.element.impl.XYGraphEx;
import org.jplot2d.layout.LayoutDirector;
import org.jplot2d.layout.SimpleLayoutDirector;
import org.jplot2d.notice.Notice;
import org.jplot2d.notice.Notifier;
import org.jplot2d.notice.RangeAdjustedToValueBoundsNotice;
import org.jplot2d.notice.RangeSelectionNotice;
import org.jplot2d.sizing.SizeMode;
import org.jplot2d.transform.PaperTransform;
import org.jplot2d.util.DoubleDimension2D;
import org.jplot2d.util.Range;

public class PlotImpl
extends ContainerImpl
implements PlotEx {
    private double containerWidth;
    private double containerHeight;
    private SizeMode sizeMode;
    private double locX;
    private double locY;
    private double width = 640.0;
    private double height = 480.0;
    private double scale = 1.0;
    private PaperTransform pxf;
    private boolean valid = true;
    private boolean rerenderNeeded;
    private Notifier notifier;
    private LayoutDirector layoutDirector = new SimpleLayoutDirector();
    private Dimension2D contentConstraint;
    private double preferredContentWidth = 320.0;
    private double preferredContentHeight = 240.0;
    private Dimension2D contentSize;
    private PlotMarginEx margin;
    private LegendEx legend;
    private final List<TitleEx> titles = new ArrayList<TitleEx>();
    private final List<AxisEx> xAxis = new ArrayList<AxisEx>();
    private final List<AxisEx> yAxis = new ArrayList<AxisEx>();
    private final List<LayerEx> layers = new ArrayList<LayerEx>();
    private final List<PlotEx> subplots = new ArrayList<PlotEx>();

    public PlotImpl() {
        this.margin = new PlotMarginImpl();
        this.margin.setParent(this);
        this.legend = new LegendImpl();
        this.legend.setParent(this);
    }

    public PlotImpl(LegendEx legend) {
        this.margin = new PlotMarginImpl();
        this.margin.setParent(this);
        this.legend = legend;
        legend.setParent(this);
    }

    @Override
    public String getShortId() {
        return null;
    }

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "Plot" + this.getParent().indexOf(this);
        }
        return "Plot@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        Method method;
        if (this.parent == null) {
            return null;
        }
        try {
            method = PlotEx.class.getMethod("getSubplot", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method, this.getParent().indexOf(this));
    }

    @Override
    public PlotEx getParent() {
        return (PlotEx)super.getParent();
    }

    @Override
    public Map<Element, Element> getMooringMap() {
        AxisTransformEx arm;
        HashMap<Element, Element> result = new HashMap<Element, Element>();
        for (AxisEx axis : this.xAxis) {
            arm = axis.getTickManager().getAxisTransform();
            for (LayerEx layer : arm.getLayers()) {
                if (layer.getParent() == this) continue;
                result.put(arm, layer);
            }
        }
        for (AxisEx axis : this.yAxis) {
            arm = axis.getTickManager().getAxisTransform();
            for (LayerEx layer : arm.getLayers()) {
                if (layer.getParent() == this) continue;
                result.put(arm, layer);
            }
        }
        return result;
    }

    @Override
    public Dimension2D getContainerSize() {
        return new DoubleDimension2D(this.containerWidth, this.containerHeight);
    }

    @Override
    public void setContainerSize(Dimension2D size) {
        if (this.sizeMode == null) {
            throw new IllegalStateException("The sizeMode property must be set.");
        }
        this.containerWidth = size.getWidth();
        this.containerHeight = size.getHeight();
    }

    @Override
    public SizeMode getSizeMode() {
        return this.sizeMode;
    }

    @Override
    public void setSizeMode(SizeMode sizeMode) {
        this.sizeMode = sizeMode;
        if (this.getParent() == null && sizeMode.isAutoPack()) {
            this.invalidate();
        }
    }

    @Override
    public Point2D getLocation() {
        return new Point2D.Double(this.locX, this.locY);
    }

    @Override
    public final void setLocation(Point2D p) {
        this.setLocation(p.getX(), p.getY());
    }

    @Override
    public void setLocation(double locX, double locY) {
        if (this.getLocation().getX() != locX || this.getLocation().getY() != locY) {
            this.locX = locX;
            this.locY = locY;
            this.pxf = null;
            PlotImpl.redrawCascade(this);
        }
    }

    @Override
    public Dimension2D getSize() {
        return new DoubleDimension2D(this.width, this.height);
    }

    @Override
    public final void setSize(Dimension2D size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setSize(double width, double height) {
        if (width < 0.0 || height < 0.0) {
            throw new IllegalArgumentException("paper size must be positive, " + width + "x" + height + " is invalid.");
        }
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.invalidate();
        }
    }

    @Override
    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(-this.margin.getLeft() - this.margin.getExtraLeft(), -this.margin.getBottom() - this.margin.getExtraBottom(), this.width, this.height);
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public void setScale(double scale) {
        if (this.scale != scale) {
            this.scale = scale;
            this.pxf = null;
        }
    }

    @Override
    public PaperTransform getPaperTransform() {
        if (this.pxf == null) {
            if (this.getParent() != null) {
                this.pxf = this.getParent().getPaperTransform().translate(this.locX, this.locY);
            } else {
                if (this.contentSize == null) {
                    return null;
                }
                this.pxf = new PaperTransform(this.margin.getLeft() + this.margin.getExtraLeft(), this.contentSize.getHeight() + this.margin.getTop() + this.margin.getExtraTop(), this.scale);
            }
        }
        return this.pxf;
    }

    @Override
    public void parentPaperTransformChanged() {
        this.pxf = null;
        PlotImpl.redrawCascade(this);
        for (PlotEx sp : this.subplots) {
            sp.parentPaperTransformChanged();
        }
    }

    @Override
    public PlotMarginEx getMargin() {
        return this.margin;
    }

    @Override
    public LayoutDirector getLayoutDirector() {
        return this.layoutDirector;
    }

    @Override
    public void setLayoutDirector(LayoutDirector director) {
        this.layoutDirector = director;
        this.invalidate();
    }

    @Override
    public Object getConstraint(Plot subplot) {
        return this.layoutDirector.getConstraint((PlotEx)subplot);
    }

    @Override
    public void setConstraint(Plot subplot, Object constraint) {
        this.layoutDirector.setConstraint((PlotEx)subplot, constraint);
        this.invalidate();
    }

    @Override
    public Dimension2D getContentConstrant() {
        return this.contentConstraint;
    }

    @Override
    public void setContentConstrant(Dimension2D constraint) {
        if (!constraint.equals(this.contentConstraint)) {
            this.contentConstraint = constraint;
            this.invalidate();
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void invalidate() {
        if (this.isValid()) {
            this.valid = false;
            if (this.getParent() != null) {
                this.getParent().invalidate();
            }
            if (this.layoutDirector != null) {
                this.layoutDirector.invalidateLayout(this);
            }
        }
    }

    @Override
    public void validate() {
        if (this.isValid()) {
            return;
        }
        if (this.layoutDirector != null) {
            this.layoutDirector.layout(this);
        }
        for (PlotEx subplot : this.subplots) {
            subplot.validate();
        }
        this.valid = true;
    }

    @Override
    public boolean isRerenderNeeded() {
        return this.rerenderNeeded;
    }

    @Override
    public void setRerenderNeeded(boolean flag) {
        this.rerenderNeeded = flag;
    }

    @Override
    public Notifier getNotifier() {
        return this.notifier;
    }

    @Override
    public void setNotifier(Notifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public void notify(Notice msg) {
        if (this.getParent() != null) {
            this.getParent().notify(msg);
        } else if (this.notifier != null) {
            this.notifier.notify(msg);
        }
    }

    @Override
    public Dimension2D getPreferredContentSize() {
        return new DoubleDimension2D(this.preferredContentWidth, this.preferredContentHeight);
    }

    @Override
    public void setPreferredContentSize(Dimension2D size) {
        if (size == null) {
            throw new IllegalArgumentException("Preferred content size cannot be null.");
        }
        this.setPreferredContentSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPreferredContentSize(double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException("Size must be positive, " + width + "x" + height + " is invalid.");
        }
        this.preferredContentWidth = width;
        this.preferredContentHeight = height;
        this.invalidate();
    }

    @Override
    public Dimension2D getContentSize() {
        return new DoubleDimension2D(this.contentSize);
    }

    @Override
    public void setContentSize(Dimension2D csize) {
        if (csize.getWidth() < 0.0 || csize.getHeight() < 0.0) {
            throw new IllegalArgumentException("Content size must be positive, " + csize.getWidth() + "x" + csize.getHeight() + " is invalid.");
        }
        this.contentSize = csize;
        this.pxf = null;
    }

    @Override
    public ComponentEx[] getComponents() {
        int i;
        int size = 1 + this.titles.size() + this.xAxis.size() + this.yAxis.size() + this.layers.size() + this.subplots.size();
        ComponentEx[] comps = new ComponentEx[size];
        int n = 0;
        comps[n++] = this.legend;
        for (i = 0; i < this.titles.size(); ++i) {
            comps[n++] = this.titles.get(i);
        }
        for (i = 0; i < this.xAxis.size(); ++i) {
            comps[n++] = this.xAxis.get(i);
        }
        for (i = 0; i < this.yAxis.size(); ++i) {
            comps[n++] = this.yAxis.get(i);
        }
        for (i = 0; i < this.layers.size(); ++i) {
            comps[n++] = this.layers.get(i);
        }
        for (i = 0; i < this.subplots.size(); ++i) {
            comps[n++] = this.subplots.get(i);
        }
        return comps;
    }

    @Override
    public LegendEx getLegend() {
        return this.legend;
    }

    @Override
    public TitleEx getTitle(int index) {
        return this.titles.get(index);
    }

    @Override
    public int indexOf(TitleEx title) {
        return this.titles.indexOf(title);
    }

    @Override
    public TitleEx[] getTitles() {
        return this.titles.toArray(new TitleEx[this.titles.size()]);
    }

    @Override
    public void addTitle(Title title) {
        TitleEx tx = (TitleEx)title;
        this.titles.add(tx);
        tx.setParent(this);
        PlotImpl.redraw(tx);
        if (tx.isVisible() && tx.canContribute() && tx.getPosition() != TitlePosition.FREE) {
            this.invalidate();
        }
    }

    @Override
    public void removeTitle(Title title) {
        TitleEx tx = (TitleEx)title;
        PlotImpl.redraw(tx);
        this.titles.remove(tx);
        tx.setParent(null);
        if (tx.isVisible() && tx.canContribute() && tx.getPosition() != TitlePosition.FREE) {
            this.invalidate();
        }
    }

    @Override
    public AxisEx getXAxis(int index) {
        return this.xAxis.get(index);
    }

    @Override
    public AxisEx getYAxis(int index) {
        return this.yAxis.get(index);
    }

    @Override
    public int indexOfXAxis(AxisEx axis) {
        return this.xAxis.indexOf(axis);
    }

    @Override
    public int indexOfYAxis(AxisEx axis) {
        return this.yAxis.indexOf(axis);
    }

    @Override
    public AxisEx[] getXAxes() {
        return this.xAxis.toArray(new AxisEx[this.xAxis.size()]);
    }

    @Override
    public AxisEx[] getYAxes() {
        return this.yAxis.toArray(new AxisEx[this.yAxis.size()]);
    }

    @Override
    public void addXAxis(Axis axis) {
        AxisEx ax = (AxisEx)axis;
        if (ax.getTickManager() == null) {
            throw new IllegalArgumentException("The axis has no tick manager.");
        }
        if (ax.getTickManager().getAxisTransform() == null) {
            throw new IllegalArgumentException("The axis' tick manager has no range manager.");
        }
        if (ax.getTickManager().getAxisTransform().getLockGroup() == null) {
            throw new IllegalArgumentException("The axis's range manager has no lock group.");
        }
        this.xAxis.add(ax);
        ax.setParent(this);
        ax.setOrientation(AxisOrientation.HORIZONTAL);
        PlotImpl.redrawCascade(ax);
        if (ax.isVisible() && ax.canContribute()) {
            this.invalidate();
        }
    }

    @Override
    public void addYAxis(Axis axis) {
        AxisEx ax = (AxisEx)axis;
        if (ax.getTickManager() == null) {
            throw new IllegalArgumentException("The axis has no tick manager.");
        }
        if (ax.getTickManager().getAxisTransform() == null) {
            throw new IllegalArgumentException("The axis' tick manager has no range manager.");
        }
        if (ax.getTickManager().getAxisTransform().getLockGroup() == null) {
            throw new IllegalArgumentException("The axis's range manager has no lock group.");
        }
        this.yAxis.add(ax);
        ax.setParent(this);
        ax.setOrientation(AxisOrientation.VERTICAL);
        PlotImpl.redrawCascade(ax);
        if (ax.isVisible() && ax.canContribute()) {
            this.invalidate();
        }
    }

    @Override
    public void addXAxes(Axis[] axes) {
        int i;
        if (axes.length == 0) {
            return;
        }
        AxisTickManagerEx atm = ((AxisEx)axes[0]).getTickManager();
        for (i = 1; i < axes.length; ++i) {
            if (atm == ((AxisEx)axes[i]).getTickManager()) continue;
            throw new IllegalArgumentException("The axes must have the same tick manager.");
        }
        if (atm == null) {
            throw new IllegalArgumentException("The axes have no tick manager.");
        }
        if (atm.getAxisTransform() == null) {
            throw new IllegalArgumentException("The axes' tick manager has no range manager.");
        }
        if (atm.getAxisTransform().getLockGroup() == null) {
            throw new IllegalArgumentException("The axes' range manager has no lock group.");
        }
        for (i = 0; i < axes.length; ++i) {
            AxisEx ax = (AxisEx)axes[i];
            this.xAxis.add(ax);
            ax.setParent(this);
            ax.setOrientation(AxisOrientation.HORIZONTAL);
            PlotImpl.redrawCascade(ax);
            if (!ax.isVisible() || !ax.canContribute()) continue;
            this.invalidate();
        }
    }

    @Override
    public void addYAxes(Axis[] axes) {
        int i;
        if (axes.length == 0) {
            return;
        }
        AxisTickManagerEx atm = ((AxisEx)axes[0]).getTickManager();
        for (i = 1; i < axes.length; ++i) {
            if (atm == ((AxisEx)axes[i]).getTickManager()) continue;
            throw new IllegalArgumentException("The axes must have the same tick manager.");
        }
        if (atm == null) {
            throw new IllegalArgumentException("The axes have no tick manager.");
        }
        if (atm.getAxisTransform() == null) {
            throw new IllegalArgumentException("The axes' tick manager has no range manager.");
        }
        if (atm.getAxisTransform().getLockGroup() == null) {
            throw new IllegalArgumentException("The axes' range manager has no lock group.");
        }
        for (i = 0; i < axes.length; ++i) {
            AxisEx ax = (AxisEx)axes[i];
            this.yAxis.add(ax);
            ax.setParent(this);
            ax.setOrientation(AxisOrientation.VERTICAL);
            PlotImpl.redrawCascade(ax);
            if (!ax.isVisible() || !ax.canContribute()) continue;
            this.invalidate();
        }
    }

    @Override
    public void removeXAxis(Axis axis) {
        AxisEx ax = (AxisEx)axis;
        PlotImpl.redrawCascade(ax);
        this.xAxis.remove(ax);
        ax.setParent(null);
        if (ax.getTickManager().getParent() == null) {
            ax.setTickManager(null);
        } else if (ax.getTickManager().getAxisTransform().getParent() == null) {
            ax.getTickManager().setAxisTransform(null);
        } else if (ax.getTickManager().getAxisTransform().getLockGroup().getParent() == null) {
            ax.getTickManager().getAxisTransform().setLockGroup(null);
        }
        if (ax.isVisible() && ax.canContribute()) {
            this.invalidate();
        }
    }

    @Override
    public void removeYAxis(Axis axis) {
        AxisEx ax = (AxisEx)axis;
        PlotImpl.redrawCascade(ax);
        this.yAxis.remove(ax);
        ax.setParent(null);
        if (ax.getTickManager().getParent() == null) {
            ax.setTickManager(null);
        } else if (ax.getTickManager().getAxisTransform().getParent() == null) {
            ax.getTickManager().setAxisTransform(null);
        } else if (ax.getTickManager().getAxisTransform().getLockGroup().getParent() == null) {
            ax.getTickManager().getAxisTransform().setLockGroup(null);
        }
        if (ax.isVisible() && ax.canContribute()) {
            this.invalidate();
        }
    }

    @Override
    public Layer getLayer(int index) {
        return this.layers.get(index);
    }

    @Override
    public int indexOf(LayerEx layer) {
        return this.layers.indexOf(layer);
    }

    @Override
    public LayerEx[] getLayers() {
        return this.layers.toArray(new LayerEx[this.layers.size()]);
    }

    @Override
    public void addLayer(Layer layer) {
        LayerEx lx = (LayerEx)layer;
        this.layers.add(lx);
        lx.setParent(this);
        PlotImpl.redrawCascade(lx);
        for (GraphEx gx : lx.getGraphs()) {
            if (!(gx instanceof XYGraphEx)) continue;
            this.getLegend().addLegendItem(((XYGraphEx)gx).getLegendItem());
        }
    }

    @Override
    public void addLayer(Layer layer, AxisTransform xRangeManager, AxisTransform yRangeManager) {
        this.addLayer(layer);
        layer.setAxesTransform(xRangeManager, yRangeManager);
    }

    @Override
    public void addLayer(Layer layer, Axis xaxis, Axis yaxis) {
        this.addLayer(layer, xaxis.getTickManager().getAxisTransform(), yaxis.getTickManager().getAxisTransform());
    }

    @Override
    public void removeLayer(Layer layer) {
        LayerEx lx = (LayerEx)layer;
        PlotImpl.redrawCascade(lx);
        this.layers.remove(lx);
        lx.setParent(null);
        lx.setAxesTransform(null, null);
        for (GraphEx gx : lx.getGraphs()) {
            if (!(gx instanceof XYGraphEx)) continue;
            this.getLegend().removeLegendItem(((XYGraphEx)gx).getLegendItem());
        }
    }

    @Override
    public PlotEx getSubplot(int i) {
        return this.subplots.get(i);
    }

    @Override
    public int indexOf(PlotEx subplot) {
        return this.subplots.indexOf(subplot);
    }

    @Override
    public PlotEx[] getSubplots() {
        return this.subplots.toArray(new PlotEx[this.subplots.size()]);
    }

    @Override
    public void addSubplot(Plot subplot, Object constraint) {
        LayoutDirector ld;
        PlotEx sp = (PlotEx)subplot;
        this.subplots.add(sp);
        sp.setParent(this);
        PlotImpl.redrawCascade(sp);
        if (sp.isVisible()) {
            this.invalidate();
        }
        if ((ld = this.getLayoutDirector()) != null) {
            ld.setConstraint(sp, constraint);
        }
        if (!sp.getLegend().isEnabled()) {
            sp.getLegend().putItemsToEnabledLegend();
        }
    }

    @Override
    public void setSubplotConstraint(Plot subplot, Object constraint) {
        PlotEx sp = (PlotEx)subplot;
        LayoutDirector ld = this.getLayoutDirector();
        if (ld != null) {
            ld.setConstraint(sp, constraint);
            if (sp.isVisible()) {
                this.invalidate();
            }
        }
    }

    @Override
    public void removeSubplot(Plot subplot) {
        PlotEx sp = (PlotEx)subplot;
        PlotImpl.redrawCascade(sp);
        this.subplots.remove(sp);
        sp.setParent(null);
        LayoutDirector ld = this.getLayoutDirector();
        if (ld != null) {
            ld.remove((PlotEx)subplot);
        }
        if (subplot.isVisible()) {
            this.invalidate();
        }
    }

    @Override
    public boolean canContribute() {
        return false;
    }

    @Override
    public PlotImpl copyStructure(Map<ElementEx, ElementEx> orig2copyMap) {
        PlotEx result = this.copyStructureCascade((Map)orig2copyMap);
        PlotImpl.linkLayerAndAxisTransform(this, orig2copyMap);
        return result;
    }

    @Override
    public PlotImpl copyStructureCascade(Map<ElementEx, ElementEx> orig2copyMap) {
        AxisEx vaCopy;
        PlotImpl result = (PlotImpl)super.copyStructure((Map)orig2copyMap);
        result.margin = (PlotMarginEx)this.margin.copyStructure(orig2copyMap);
        result.margin.setParent(result);
        result.legend = (LegendEx)this.legend.copyStructure(orig2copyMap);
        result.legend.setParent(result);
        for (TitleEx title : this.titles) {
            TitleEx titleCopy = (TitleEx)title.copyStructure(orig2copyMap);
            titleCopy.setParent(result);
            result.titles.add(titleCopy);
        }
        for (AxisEx va : this.xAxis) {
            vaCopy = (AxisEx)va.copyStructure(orig2copyMap);
            vaCopy.setParent(result);
            result.xAxis.add(vaCopy);
        }
        for (AxisEx va : this.yAxis) {
            vaCopy = (AxisEx)va.copyStructure(orig2copyMap);
            vaCopy.setParent(result);
            result.yAxis.add(vaCopy);
        }
        for (LayerEx layer : this.layers) {
            LayerEx layerCopy = (LayerEx)layer.copyStructure(orig2copyMap);
            layerCopy.setParent(result);
            result.layers.add(layerCopy);
        }
        for (PlotEx sp : this.subplots) {
            PlotEx spCopy = sp.copyStructureCascade(orig2copyMap);
            spCopy.setParent(result);
            result.subplots.add(spCopy);
        }
        for (LegendItemEx item : this.getLegend().getItems()) {
            LegendItemEx liCopy = (LegendItemEx)orig2copyMap.get(item);
            result.legend.addLegendItem(liCopy);
        }
        return result;
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        PlotImpl plot = (PlotImpl)src;
        this.locX = plot.locX;
        this.locY = plot.locY;
        this.width = plot.width;
        this.height = plot.height;
        this.scale = plot.scale;
        this.valid = plot.valid;
        this.layoutDirector = plot.layoutDirector;
        this.pxf = plot.pxf;
        this.preferredContentWidth = plot.preferredContentWidth;
        this.preferredContentHeight = plot.preferredContentHeight;
        this.contentSize = plot.contentSize;
        this.containerWidth = plot.containerWidth;
        this.containerHeight = plot.containerHeight;
        this.sizeMode = plot.sizeMode;
        this.rerenderNeeded = plot.rerenderNeeded;
    }

    public static void linkLayerAndAxisTransform(PlotEx plot, Map<ElementEx, ElementEx> orig2copyMap) {
        for (LayerEx layerEx : plot.getLayers()) {
            LayerEx layerCopy = (LayerEx)orig2copyMap.get(layerEx);
            if (layerCopy.getXAxisTransform() == null && layerEx.getXAxisTransform() != null) {
                AxisTransformEx xcopy = (AxisTransformEx)orig2copyMap.get(layerEx.getXAxisTransform());
                layerCopy.linkXAxisTransform(xcopy);
                xcopy.linkLayer(layerCopy);
            }
            if (layerCopy.getYAxisTransform() != null || layerEx.getYAxisTransform() == null) continue;
            AxisTransformEx ycopy = (AxisTransformEx)orig2copyMap.get(layerEx.getYAxisTransform());
            layerCopy.linkYAxisTransform(ycopy);
            ycopy.linkLayer(layerCopy);
        }
        for (ContainerEx containerEx : plot.getSubplots()) {
            PlotImpl.linkLayerAndAxisTransform((PlotEx)containerEx, orig2copyMap);
        }
    }

    @Override
    public void draw(Graphics2D g) {
    }

    @Override
    public void commit() {
        PaperTransform oldPxf = this.getPaperTransform();
        double scaleResult = 0.0;
        if (this.getSizeMode() != null && !this.getSizeMode().isAutoPack()) {
            SizeMode.Result sizeResult = this.getSizeMode().update(this);
            this.setSize(sizeResult.getSize());
            scaleResult = sizeResult.getScale();
        }
        PlotImpl.calcAxesThickness(this);
        PlotImpl.calcLegendSize(this);
        PlotImpl.calcTitleSize(this);
        do {
            if (this.getSizeMode() != null && this.getSizeMode().isAutoPack()) {
                this.autoPack();
            }
            this.validate();
            this.calcPendingLockGroupAutoRange();
            PlotImpl.calcAxesTick(this);
            PlotImpl.calcAxesThickness(this);
            PlotImpl.calcLegendSize(this);
        } while (!this.isValid());
        if (this.getSizeMode() != null && this.getSizeMode().isAutoPack()) {
            scaleResult = this.getSizeMode().update(this).getScale();
        }
        if (this.getSizeMode() != null) {
            this.setScale(scaleResult);
        }
        if (oldPxf == null || !oldPxf.equals(this.getPaperTransform())) {
            this.parentPaperTransformChanged();
        }
        this.calcPendingImageMappingLimits();
    }

    private void autoPack() {
        if (this.getLayoutDirector() != null && !this.isValid()) {
            Dimension2D prefSize = this.getLayoutDirector().getPreferredSize(this);
            this.setSize(prefSize);
        }
    }

    private void calcPendingLockGroupAutoRange() {
        HashSet<AxisRangeLockGroupEx> xalgs = new HashSet<AxisRangeLockGroupEx>();
        HashSet<AxisRangeLockGroupEx> yalgs = new HashSet<AxisRangeLockGroupEx>();
        PlotImpl.fillLockGroups(this, xalgs, yalgs);
        boolean hasAutoRange = true;
        while (hasAutoRange) {
            hasAutoRange = false;
            for (AxisRangeLockGroupEx alg : xalgs) {
                hasAutoRange |= alg.calcAutoRange();
            }
            for (AxisRangeLockGroupEx alg : yalgs) {
                hasAutoRange |= alg.calcAutoRange();
            }
        }
    }

    private static void fillLockGroups(PlotEx plot, Set<AxisRangeLockGroupEx> xalgs, Set<AxisRangeLockGroupEx> yalgs) {
        AxisRangeLockGroupEx alg;
        for (AxisEx axisEx : plot.getXAxes()) {
            alg = axisEx.getTickManager().getAxisTransform().getLockGroup();
            xalgs.add(alg);
        }
        for (AxisEx axisEx : plot.getYAxes()) {
            alg = axisEx.getTickManager().getAxisTransform().getLockGroup();
            yalgs.add(alg);
        }
        for (ComponentEx componentEx : plot.getSubplots()) {
            PlotImpl.fillLockGroups((PlotEx)componentEx, xalgs, yalgs);
        }
    }

    private static void calcAxesThickness(PlotEx plot) {
        for (AxisEx axisEx : plot.getXAxes()) {
            if (!axisEx.isVisible() || !axisEx.canContribute()) continue;
            PlotImpl.calcAxisThickness(axisEx);
        }
        for (AxisEx axisEx : plot.getYAxes()) {
            if (!axisEx.isVisible() || !axisEx.canContribute()) continue;
            PlotImpl.calcAxisThickness(axisEx);
        }
        for (ComponentEx componentEx : plot.getSubplots()) {
            PlotImpl.calcAxesThickness((PlotEx)componentEx);
        }
    }

    private static void calcAxisThickness(AxisEx axis) {
        double asc = axis.getAsc();
        double desc = axis.getDesc();
        axis.calcThickness();
        if (Math.abs(asc - axis.getAsc()) > Math.abs(asc) * 1.0E-12 || Math.abs(desc - axis.getDesc()) > Math.abs(desc) * 1.0E-12) {
            axis.getParent().invalidate();
        }
    }

    private static void calcAxesTick(PlotEx plot) {
        HashSet<AxisTickManagerEx> algs = new HashSet<AxisTickManagerEx>();
        PlotImpl.fillTickManagers(plot, algs);
        for (AxisTickManagerEx alg : algs) {
            alg.calcTicks();
        }
    }

    private static void fillTickManagers(PlotEx plot, Set<AxisTickManagerEx> algs) {
        AxisTickManagerEx alg;
        for (AxisEx axisEx : plot.getXAxes()) {
            alg = axisEx.getTickManager();
            algs.add(alg);
        }
        for (AxisEx axisEx : plot.getYAxes()) {
            alg = axisEx.getTickManager();
            algs.add(alg);
        }
        for (ComponentEx componentEx : plot.getSubplots()) {
            PlotImpl.fillTickManagers((PlotEx)componentEx, algs);
        }
    }

    private static void calcTitleSize(PlotEx plot) {
        for (TitleEx titleEx : plot.getTitles()) {
            if (!titleEx.isVisible() || !titleEx.canContribute()) continue;
            Dimension2D size = titleEx.getSize();
            double oldThickness = size == null ? 0.0 : size.getHeight();
            titleEx.calcSize();
            if (!(Math.abs(oldThickness - titleEx.getSize().getHeight()) > Math.abs(oldThickness) * 1.0E-12)) continue;
            plot.invalidate();
        }
        for (ComponentEx componentEx : plot.getSubplots()) {
            PlotImpl.calcTitleSize((PlotEx)componentEx);
        }
    }

    private static void calcLegendSize(PlotEx plot) {
        LegendEx legend = plot.getLegend();
        if (legend.isVisible() && legend.canContribute()) {
            double oldThickness = legend.getThickness();
            plot.getLegend().calcSize();
            if (Math.abs(oldThickness - legend.getThickness()) > Math.abs(oldThickness) * 1.0E-12) {
                plot.invalidate();
            }
        }
        for (PlotEx sp : plot.getSubplots()) {
            PlotImpl.calcLegendSize(sp);
        }
    }

    private void calcPendingImageMappingLimits() {
        HashSet<ImageMappingEx> ims = new HashSet<ImageMappingEx>();
        HashSet<RGBImageMappingEx> rgbims = new HashSet<RGBImageMappingEx>();
        PlotImpl.fillImageMappings(this, ims, rgbims);
        for (ImageMappingEx imageMappingEx : ims) {
            imageMappingEx.calcLimits();
        }
        for (RGBImageMappingEx rGBImageMappingEx : rgbims) {
            rGBImageMappingEx.calcLimits();
        }
    }

    private static void fillImageMappings(PlotEx plot, Set<ImageMappingEx> ims, Set<RGBImageMappingEx> rgbims) {
        for (LayerEx layerEx : plot.getLayers()) {
            for (GraphEx graph : layerEx.getGraphs()) {
                if (graph instanceof ImageGraphEx) {
                    ims.add(((ImageGraphEx)graph).getMapping());
                }
                if (!(graph instanceof RGBImageGraphEx)) continue;
                rgbims.add(((RGBImageGraphEx)graph).getMapping());
            }
        }
        for (ContainerEx containerEx : plot.getSubplots()) {
            PlotImpl.fillImageMappings((PlotEx)containerEx, ims, rgbims);
        }
    }

    @Override
    public void zoomXRange(double start, double end) {
        Set<AxisRangeLockGroupEx> xarlgs = this.getXAxisRangeLockGroup();
        this.zoomRange(xarlgs, start, end);
    }

    @Override
    public void zoomYRange(double start, double end) {
        Set<AxisRangeLockGroupEx> yarlgs = this.getYAxisRangeLockGroup();
        this.zoomRange(yarlgs, start, end);
    }

    private Set<AxisRangeLockGroupEx> getXAxisRangeLockGroup() {
        HashSet<AxisRangeLockGroupEx> algs = new HashSet<AxisRangeLockGroupEx>();
        for (LayerEx layer : this.layers) {
            AxisRangeLockGroupEx alg;
            if (layer.getXAxisTransform() == null || !(alg = layer.getXAxisTransform().getLockGroup()).isZoomable()) continue;
            algs.add(alg);
        }
        return algs;
    }

    private Set<AxisRangeLockGroupEx> getYAxisRangeLockGroup() {
        HashSet<AxisRangeLockGroupEx> algs = new HashSet<AxisRangeLockGroupEx>();
        for (LayerEx layer : this.layers) {
            AxisRangeLockGroupEx alg;
            if (layer.getXAxisTransform() == null || !(alg = layer.getYAxisTransform().getLockGroup()).isZoomable()) continue;
            algs.add(alg);
        }
        return algs;
    }

    private void zoomRange(Collection<AxisRangeLockGroupEx> arlgs, double start, double end) {
        RangeStatus<PrecisionState> xrs;
        RangeStatus<PrecisionState> rs;
        ArrayList<AxisTransformEx> arms = new ArrayList<AxisTransformEx>();
        for (AxisRangeLockGroupEx arlg : arlgs) {
            arms.addAll(Arrays.asList(arlg.getRangeManagers()));
        }
        Range.Double range = new Range.Double(start, end);
        Range validRange = AxisRangeUtils.validateNormalRange((Range)range, arms, false);
        if (!validRange.equals(range)) {
            this.notify(new RangeAdjustedToValueBoundsNotice("Range exceed valid boundary, has been adjusted."));
        }
        if ((rs = AxisRangeUtils.ensurePrecision(validRange, arms)).getStatus() != null) {
            this.notify(new RangeSelectionNotice(rs.getStatus().getMessage()));
        }
        if ((xrs = AxisRangeUtils.ensureCircleSpan(rs, arms)).getStatus() != null) {
            this.notify(new RangeSelectionNotice(xrs.getStatus().getMessage()));
        }
        for (AxisRangeLockGroupEx arm : arlgs) {
            arm.zoomNormalRange(xrs);
        }
    }

    @Override
    public void adaptiveZoomX() {
        Set<AxisRangeLockGroupEx> xarlgs = this.getXAxisRangeLockGroup();
        for (AxisRangeLockGroupEx arm : xarlgs) {
            arm.reAutoRange();
        }
    }

    @Override
    public void adaptiveZoomY() {
        Set<AxisRangeLockGroupEx> yarlgs = this.getYAxisRangeLockGroup();
        for (AxisRangeLockGroupEx arm : yarlgs) {
            arm.reAutoRange();
        }
    }
}

