/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.jplot2d.element.HAlign;
import org.jplot2d.element.LegendPosition;
import org.jplot2d.element.Plot;
import org.jplot2d.element.VAlign;
import org.jplot2d.element.impl.ComponentImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.element.impl.LegendEx;
import org.jplot2d.element.impl.LegendItemEx;
import org.jplot2d.element.impl.LegendItemImpl;
import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.util.DoubleDimension2D;

public class LegendImpl
extends ComponentImpl
implements LegendEx {
    private static final double VERTICAL_BORDER = 2.0;
    private static final double HORIZONTAL_BORDER = 8.0;
    private static final double COLUMN_SPACE = 8.0;
    private static final Color BORDER_COLOR = Color.BLACK;
    private boolean enabled = true;
    private double locX;
    private double locY;
    private double width;
    private double height;
    private LegendPosition position = LegendPosition.BOTTOMCENTER;
    private HAlign halign = HAlign.CENTER;
    private VAlign valign = VAlign.TOP;
    private double rowSpacingFactor = 0.125;
    private boolean borderVisible = true;
    private Dimension2D maxItemSize;
    private int columns = 1;
    private int rows = 1;
    private double lengthConstraint = Double.NaN;
    private boolean sizeCalculationNeeded;
    private boolean layoutItemsNeeded;
    private final Collection<LegendItemEx> items = new ArrayList<LegendItemEx>();
    private int visibleItemNum;

    public LegendImpl() {
        this.setSelectable(true);
        this.setMovable(true);
    }

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "Legend";
        }
        return "Legend@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        Method method;
        if (this.parent == null) {
            return null;
        }
        try {
            method = Plot.class.getMethod("getLegend", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method);
    }

    @Override
    public PlotEx getParent() {
        return (PlotEx)super.getParent();
    }

    private void invalidatePlot() {
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    @Override
    public boolean canContribute() {
        return this.visibleItemNum > 0;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.canContribute() && this.getPosition() != LegendPosition.FREE) {
            this.invalidatePlot();
        }
    }

    @Override
    public void thisEffectiveColorChanged() {
        LegendImpl.redraw(this);
    }

    @Override
    public void thisEffectiveFontChanged() {
        for (LegendItemEx item : this.items) {
            item.legendEffectiveFontChanged();
        }
    }

    @Override
    public Dimension2D getSize() {
        return new DoubleDimension2D(this.width, this.height);
    }

    @Override
    public Rectangle2D getBounds() {
        double y;
        double x;
        switch (this.getHAlign()) {
            case RIGHT: {
                x = -this.width;
                break;
            }
            case CENTER: {
                x = -this.width / 2.0;
                break;
            }
            default: {
                x = 0.0;
            }
        }
        switch (this.getVAlign()) {
            case TOP: {
                y = -this.height;
                break;
            }
            case MIDDLE: {
                y = -this.height / 2.0;
                break;
            }
            default: {
                y = 0.0;
            }
        }
        return new Rectangle2D.Double(x, y, this.width, this.height);
    }

    @Override
    public Point2D getLocation() {
        return new Point2D.Double(this.locX, this.locY);
    }

    @Override
    public void setLocation(Point2D loc) {
        this.setLocation(loc.getX(), loc.getY());
    }

    @Override
    public void setLocation(double locX, double locY) {
        this.directLocation(locX, locY);
        this.setPosition(LegendPosition.FREE);
    }

    @Override
    public void directLocation(double locX, double locY) {
        if (this.locX != locX || this.locY != locY) {
            this.locX = locX;
            this.locY = locY;
            LegendImpl.redraw(this);
        }
    }

    @Override
    public LegendPosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(LegendPosition position) {
        if (position == null) {
            position = LegendPosition.FREE;
        }
        if (this.position != position) {
            this.position = position;
            if (this.isVisible() && this.canContribute()) {
                this.invalidatePlot();
            }
        }
    }

    @Override
    public HAlign getHAlign() {
        return this.halign;
    }

    @Override
    public void setHAlign(HAlign halign) {
        this.halign = halign;
        this.layoutItemsNeeded = true;
    }

    @Override
    public VAlign getVAlign() {
        return this.valign;
    }

    @Override
    public void setVAlign(VAlign valign) {
        this.valign = valign;
        this.layoutItemsNeeded = true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldContribution = this.canContribute();
        if (enabled) {
            LegendEx oldLegend = LegendImpl.getEnabledLegend(this.getParent());
            LegendItemEx[] allItems = oldLegend.getItems();
            this.enabled = enabled;
            for (LegendItemEx item : allItems) {
                if (LegendImpl.getEnabledLegend(item.getParent().getParent().getParent()) != this) continue;
                oldLegend.removeLegendItem(item);
                this.addLegendItem(item);
            }
        } else {
            this.enabled = enabled;
            LegendEx newLegend = LegendImpl.getEnabledLegend(this.getParent());
            if (newLegend != this) {
                for (LegendItemEx item : this.items) {
                    newLegend.addLegendItem(item);
                }
                this.items.clear();
                this.visibleItemNum = 0;
                this.maxItemSize = null;
            }
        }
        if (this.isVisible() && oldContribution != this.canContribute() && this.getPosition() != LegendPosition.FREE) {
            this.invalidatePlot();
        }
    }

    @Override
    public void putItemsToEnabledLegend() {
        if (!this.isEnabled() && this.items.size() > 0) {
            LegendEx newLegend = LegendImpl.getEnabledLegend(this.getParent());
            for (LegendItemEx item : this.items) {
                newLegend.addLegendItem(item);
            }
            this.items.clear();
            this.visibleItemNum = 0;
            this.maxItemSize = null;
        }
    }

    private static LegendEx getEnabledLegend(PlotEx plot) {
        if (plot.getLegend().isEnabled()) {
            return plot.getLegend();
        }
        if (plot.getParent() == null) {
            return plot.getLegend();
        }
        return LegendImpl.getEnabledLegend(plot.getParent());
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(int columns) {
        if (columns < 1) {
            throw new IllegalArgumentException("Columns number must great than 0.");
        }
        this.columns = columns;
        this.sizeCalculationNeeded = true;
        LegendImpl.redraw(this);
    }

    @Override
    public double getRowSpacingFactor() {
        return this.rowSpacingFactor;
    }

    @Override
    public void setRowSpacingFactor(double factor) {
        this.rowSpacingFactor = factor;
        this.sizeCalculationNeeded = true;
    }

    @Override
    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    @Override
    public void setBorderVisible(boolean visible) {
        this.borderVisible = visible;
        LegendImpl.redraw(this);
    }

    @Override
    public LegendItemEx[] getItems() {
        return this.items.toArray(new LegendItemEx[this.items.size()]);
    }

    @Override
    public void addLegendItem(LegendItemEx item) {
        if (this.isEnabled() || this.getParent().getParent() == null) {
            this.items.add(item);
            item.setLegend(this);
            if (this.isItemVisible(item)) {
                this.incVisibleItemNum();
                this.maxItemSize = null;
                this.sizeCalculationNeeded = true;
                if (this.isVisible()) {
                    LegendImpl.redraw(this);
                }
            }
        } else {
            this.getParent().getParent().getLegend().addLegendItem(item);
        }
    }

    @Override
    public void removeLegendItem(LegendItemEx item) {
        if (this.isEnabled() || this.getParent().getParent() == null) {
            if (this.isItemVisible(item)) {
                this.decVisibleItemNum();
                if (item.getSize().equals(this.maxItemSize)) {
                    this.maxItemSize = null;
                }
                this.sizeCalculationNeeded = true;
                LegendImpl.redraw(this);
            }
            this.items.remove(item);
            item.setLegend(null);
        } else {
            this.getParent().getParent().getLegend().removeLegendItem(item);
        }
    }

    @Override
    public void itemVisibilityChanged(LegendItemImpl item) {
        if (item.canContribute()) {
            if (item.isVisible()) {
                this.incVisibleItemNum();
                this.maxItemSize = null;
            } else {
                this.decVisibleItemNum();
                if (item.getSize().equals(this.maxItemSize)) {
                    this.maxItemSize = null;
                }
            }
            this.sizeCalculationNeeded = true;
            LegendImpl.redraw(this);
        }
    }

    @Override
    public void itemContribitivityChanged(LegendItemImpl item) {
        if (item.isVisible()) {
            if (item.canContribute()) {
                this.incVisibleItemNum();
            } else {
                this.decVisibleItemNum();
            }
            this.maxItemSize = null;
            this.sizeCalculationNeeded = true;
            LegendImpl.redraw(this);
        }
    }

    private boolean isItemVisible(LegendItemEx item) {
        return item.isVisible() && item.canContribute();
    }

    private void incVisibleItemNum() {
        ++this.visibleItemNum;
        if (this.visibleItemNum == 1 && this.isVisible()) {
            this.invalidatePlot();
        }
    }

    private void decVisibleItemNum() {
        --this.visibleItemNum;
        if (this.visibleItemNum == 0 && this.isVisible()) {
            this.invalidatePlot();
        }
    }

    @Override
    public void itemSizeChanged(LegendItemEx item) {
        if (item.isVisible()) {
            this.maxItemSize = null;
            this.sizeCalculationNeeded = true;
            LegendImpl.redraw(this);
        }
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        LegendImpl legend = (LegendImpl)src;
        this.enabled = legend.enabled;
        this.locX = legend.locX;
        this.locY = legend.locY;
        this.width = legend.width;
        this.height = legend.height;
        this.position = legend.position;
        this.halign = legend.halign;
        this.valign = legend.valign;
        this.rowSpacingFactor = legend.rowSpacingFactor;
        this.borderVisible = legend.borderVisible;
        this.maxItemSize = legend.maxItemSize;
        this.rows = legend.rows;
        this.columns = legend.columns;
        this.lengthConstraint = legend.lengthConstraint;
        this.sizeCalculationNeeded = legend.sizeCalculationNeeded;
        this.layoutItemsNeeded = legend.layoutItemsNeeded;
        this.visibleItemNum = legend.visibleItemNum;
    }

    @Override
    public double getThickness() {
        switch (this.getPosition()) {
            case TOPLEFT: 
            case TOPCENTER: 
            case TOPRIGHT: 
            case BOTTOMLEFT: 
            case BOTTOMCENTER: 
            case BOTTOMRIGHT: {
                return this.getSize().getHeight();
            }
            case LEFTTOP: 
            case LEFTMIDDLE: 
            case LEFTBOTTOM: 
            case RIGHTTOP: 
            case RIGHTMIDDLE: 
            case RIGHTBOTTOM: {
                return this.getSize().getWidth();
            }
        }
        return 0.0;
    }

    @Override
    public void calcSize() {
        if (this.visibleItemNum == 0) {
            this.width = 0.0;
            this.height = 0.0;
            this.sizeCalculationNeeded = false;
            return;
        }
        PlotEx plot = this.getParent();
        switch (this.getPosition()) {
            case TOPLEFT: 
            case TOPCENTER: 
            case TOPRIGHT: 
            case BOTTOMLEFT: 
            case BOTTOMCENTER: 
            case BOTTOMRIGHT: {
                double legendWidth = plot.getSize().getWidth() - plot.getMargin().getExtraLeft() - plot.getMargin().getExtraRight();
                this.setLengthConstraint(legendWidth);
                break;
            }
            case LEFTTOP: 
            case LEFTMIDDLE: 
            case LEFTBOTTOM: 
            case RIGHTTOP: 
            case RIGHTMIDDLE: 
            case RIGHTBOTTOM: {
                double contentHeight = plot.getContentSize().getHeight();
                this.setLengthConstraint(contentHeight);
                break;
            }
            default: {
                int nrow = this.visibleItemNum / this.columns;
                if (this.visibleItemNum % this.columns > 0) {
                    ++nrow;
                }
                this.rows = nrow;
            }
        }
        if (this.sizeCalculationNeeded) {
            switch (this.getPosition()) {
                case TOPLEFT: 
                case TOPCENTER: 
                case TOPRIGHT: 
                case BOTTOMLEFT: 
                case BOTTOMCENTER: 
                case BOTTOMRIGHT: {
                    this.fitColumnsToWidth(this.lengthConstraint);
                    break;
                }
                case LEFTTOP: 
                case LEFTMIDDLE: 
                case LEFTBOTTOM: 
                case RIGHTTOP: 
                case RIGHTMIDDLE: 
                case RIGHTBOTTOM: {
                    this.fitRowsToHeight(this.lengthConstraint);
                }
            }
            this.width = (this.getMaxItemSize().getWidth() + 8.0) * (double)this.columns - 8.0 + 16.0;
            this.height = this.getMaxItemSize().getHeight() * (double)this.rows + this.getMaxItemSize().getHeight() * this.rowSpacingFactor * (double)(this.rows - 1) + 4.0;
            this.sizeCalculationNeeded = false;
            this.layoutItemsNeeded = true;
        }
        if (this.layoutItemsNeeded) {
            this.layoutItems();
        }
    }

    private void setLengthConstraint(double length) {
        if (this.lengthConstraint != length) {
            this.lengthConstraint = length;
            this.sizeCalculationNeeded = true;
        }
    }

    private void fitColumnsToWidth(double width) {
        Dimension2D lisize = this.getMaxItemSize();
        double maxColumns = (width - 16.0 + 8.0) / (lisize.getWidth() + 8.0);
        int ncol = (int)maxColumns;
        if (ncol < 1) {
            ncol = 1;
        } else if (ncol > this.visibleItemNum) {
            ncol = this.visibleItemNum;
        }
        int nrow = this.visibleItemNum / ncol;
        if (this.visibleItemNum % ncol > 0) {
            ++nrow;
        }
        this.columns = ncol;
        this.rows = nrow;
    }

    private void fitRowsToHeight(double height) {
        Dimension2D lisize = this.getMaxItemSize();
        double maxRows = ((height - 4.0) / lisize.getHeight() + this.rowSpacingFactor) / (1.0 + this.rowSpacingFactor);
        int nrow = (int)maxRows;
        if (nrow < 1) {
            nrow = 1;
        } else if (nrow > this.visibleItemNum) {
            nrow = this.visibleItemNum;
        }
        int ncol = this.visibleItemNum / nrow;
        if (this.visibleItemNum % nrow > 0) {
            ++ncol;
        }
        this.columns = ncol;
        this.rows = nrow;
    }

    private void layoutItems() {
        int i;
        if (this.visibleItemNum == 0 || !this.isVisible()) {
            return;
        }
        double[] lipx = new double[this.columns];
        double[] lipy = new double[this.rows];
        for (i = 0; i < this.columns; ++i) {
            lipx[i] = 8.0 + (double)i * this.getMaxItemSize().getWidth() + (double)i * 8.0;
        }
        for (i = 0; i < this.rows; ++i) {
            lipy[i] = 2.0 + ((double)(this.rows - i) - 0.5) * this.getMaxItemSize().getHeight() + (double)(this.rows - 1 - i) * this.getMaxItemSize().getHeight() * this.rowSpacingFactor;
        }
        Rectangle2D bounds = this.getBounds();
        double xoff = bounds.getX();
        double yoff = bounds.getY();
        int col = 0;
        int row = 0;
        for (LegendItemEx item : this.items) {
            if (!this.isItemVisible(item)) continue;
            item.setLocation(lipx[col] + xoff, lipy[row] + yoff);
            if (++col < this.columns) continue;
            col = 0;
            ++row;
        }
    }

    private Dimension2D getMaxItemSize() {
        if (this.maxItemSize != null) {
            return this.maxItemSize;
        }
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        for (LegendItemEx item : this.items) {
            if (!this.isItemVisible(item)) continue;
            Dimension2D psize = item.getSize();
            double pwidth = psize.getWidth();
            double pheight = psize.getHeight();
            if (maxWidth < pwidth) {
                maxWidth = pwidth;
            }
            if (!(maxHeight < pheight)) continue;
            maxHeight = pheight;
        }
        this.maxItemSize = new DoubleDimension2D(maxWidth, maxHeight);
        return this.maxItemSize;
    }

    @Override
    public void draw(Graphics2D graphics) {
        if (!this.canContribute()) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics.create();
        g.transform(this.getPaperTransform().getTransform());
        if (this.borderVisible) {
            Object aahint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(BORDER_COLOR);
            g.draw(this.getBounds());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aahint);
        }
        for (LegendItemEx item : this.items) {
            if (!this.isItemVisible(item)) continue;
            item.draw(g);
        }
        g.dispose();
    }
}

