/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.data;

import java.nio.ShortBuffer;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.data.ImageMaskBuffer;

public abstract class ShortDataBuffer
extends ImageDataBuffer {
    public ShortDataBuffer(ImageMaskBuffer mask) {
        super(mask);
    }

    @Override
    public byte getByte(int x, int y) {
        return (byte)this.get(x, y);
    }

    @Override
    public short getShort(int x, int y) {
        return this.get(x, y);
    }

    @Override
    public int getInt(int x, int y) {
        return this.get(x, y);
    }

    @Override
    public float getFloat(int x, int y) {
        return this.get(x, y);
    }

    @Override
    public double getDouble(int x, int y) {
        return this.get(x, y);
    }

    public abstract short get(int var1, int var2);

    @Override
    public double countValid(int w, int h) {
        if (this.mask == null) {
            return w * h;
        }
        int count = 0;
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                if (this.isMasked(i, j)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public double[] calcMinMax(int w, int h) {
        short min = Short.MAX_VALUE;
        short max = Short.MIN_VALUE;
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                if (this.isMasked(i, j)) continue;
                short v = this.get(i, j);
                if (min > v) {
                    min = v;
                }
                if (max >= v) continue;
                max = v;
            }
        }
        if (min > max) {
            return null;
        }
        return new double[]{min, max};
    }

    public static class NioBuffer
    extends ShortDataBuffer {
        private final ShortBuffer data;
        private final int offset;

        public NioBuffer(ShortBuffer data) {
            this(data, 0, null);
        }

        public NioBuffer(ShortBuffer data, ImageMaskBuffer mask) {
            this(data, 0, mask);
        }

        public NioBuffer(ShortBuffer data, int offset, ImageMaskBuffer mask) {
            super(mask);
            this.data = data;
            this.offset = offset;
        }

        @Override
        public short get(int x, int y) {
            return this.data.get(this.offset + x + y);
        }
    }

    public static class Array2D
    extends ShortDataBuffer {
        private final short[][] data;
        private final int xoffset;
        private final int yoffset;

        public Array2D(short[][] data) {
            this(data, 0, 0, null);
        }

        public Array2D(short[][] data, ImageMaskBuffer mask) {
            this(data, 0, 0, mask);
        }

        public Array2D(short[][] data, int xoffset, int yoffset, ImageMaskBuffer mask) {
            super(mask);
            this.data = data;
            this.xoffset = xoffset;
            this.yoffset = yoffset;
        }

        @Override
        public short get(int x, int y) {
            return this.data[this.yoffset + y][this.xoffset + x];
        }
    }

    public static class Array
    extends ShortDataBuffer {
        private final short[] data;
        private final int offset;

        public Array(short[] data) {
            this(data, 0, null);
        }

        public Array(short[] data, ImageMaskBuffer mask) {
            this(data, 0, mask);
        }

        public Array(short[] data, int offset, ImageMaskBuffer mask) {
            super(mask);
            this.data = data;
            this.offset = offset;
        }

        @Override
        public short get(int x, int y) {
            return this.data[this.offset + x + y];
        }
    }
}

