/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.data;

import org.jplot2d.data.GraphData;
import org.jplot2d.data.ImageCoordinateReference;
import org.jplot2d.util.Range;

public abstract class ImageData
implements GraphData {
    private final int imgWidth;
    private final int imgHeight;
    protected final Range xboundary;
    protected final Range yboundary;
    protected final ImageCoordinateReference coordref;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;

    protected ImageData(int w, int h, ImageCoordinateReference cr, Range xboundary, Range yboundary) {
        this.imgWidth = w;
        this.imgHeight = h;
        this.coordref = new ImageCoordinateReference(cr);
        this.xboundary = xboundary;
        this.yboundary = yboundary;
        this.updateRanges();
    }

    public int getWidth() {
        return this.imgWidth;
    }

    public int getHeight() {
        return this.imgHeight;
    }

    protected void updateRanges() {
        this.xmin = this.coordref.xRefVal - (this.coordref.xRefPixel - 0.5) * this.coordref.xDelta;
        this.xmax = this.xmin + (double)this.imgWidth * this.coordref.xDelta;
        this.ymin = this.coordref.yRefVal - (this.coordref.yRefPixel - 0.5) * this.coordref.yDelta;
        this.ymax = this.ymin + (double)this.imgHeight * this.coordref.yDelta;
        if (!this.inXBoundary(this.xmin)) {
            this.xmin = this.xboundary.getMin();
        }
        if (!this.inXBoundary(this.xmax)) {
            this.xmax = this.xboundary.getMax();
        }
        if (!this.inYBoundary(this.ymin)) {
            this.ymin = this.yboundary.getMin();
        }
        if (!this.inXBoundary(this.ymax)) {
            this.ymax = this.yboundary.getMax();
        }
    }

    private boolean inXBoundary(double x) {
        return this.xboundary == null ? true : this.xboundary.contains(x);
    }

    private boolean inYBoundary(double y) {
        return this.yboundary == null ? true : this.yboundary.contains(y);
    }

    @Override
    public Range getXRange() {
        return new Range.Double(this.xmin, this.xmax);
    }

    @Override
    public Range getYRange() {
        return new Range.Double(this.ymin, this.ymax);
    }

    @Override
    public boolean hasPointOutsideXBounds() {
        return false;
    }

    @Override
    public boolean hasPointOutsideYBounds() {
        return false;
    }

    public ImageCoordinateReference getCoordinateReference() {
        return new ImageCoordinateReference(this.coordref);
    }

    public abstract ImageData applyCoordinateReference(ImageCoordinateReference var1);

    public double getXcrval() {
        return this.coordref.xRefVal;
    }

    public double getYcrval() {
        return this.coordref.yRefVal;
    }

    public double getXcrpix() {
        return this.coordref.xRefPixel;
    }

    public double getYcrpix() {
        return this.coordref.yRefPixel;
    }

    public double getXcdelt() {
        return this.coordref.xDelta;
    }

    public double getYcdelt() {
        return this.coordref.yDelta;
    }
}

