/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.data;

import java.lang.reflect.Array;

public class ArrayPair
implements Cloneable {
    private final Object p;
    private final Object q;
    private final Class<?> pctype;
    private final Class<?> qctype;
    private final int size;

    public ArrayPair(Object p, Object q) {
        int plen = Array.getLength(p);
        int qlen = Array.getLength(q);
        if (plen != qlen) {
            throw new IllegalArgumentException("The length of the pair of arrays must be equal.");
        }
        this.pctype = p.getClass().getComponentType();
        this.qctype = q.getClass().getComponentType();
        this.p = p;
        this.q = q;
        this.size = plen;
    }

    public ArrayPair(Object p, Object q, int length) {
        int plen = Array.getLength(p);
        int qlen = Array.getLength(q);
        if (plen < length) {
            throw new IllegalArgumentException("The length of the p arrays must be equal or longer than the given length.");
        }
        if (qlen < length) {
            throw new IllegalArgumentException("The length of the q arrays must be equal or longer than the given length.");
        }
        this.pctype = p.getClass().getComponentType();
        this.qctype = q.getClass().getComponentType();
        this.p = p;
        this.q = q;
        this.size = length;
    }

    public int size() {
        return this.size;
    }

    public Class<?> getPComponentType() {
        return this.pctype.getComponentType();
    }

    public Class<?> getQComponentType() {
        return this.qctype.getComponentType();
    }

    public Object getPArray() {
        return this.p;
    }

    public Object getQArray() {
        return this.q;
    }

    public double getPDouble(int idx) {
        return Array.getDouble(this.p, idx);
    }

    public double getQDouble(int idx) {
        return Array.getDouble(this.q, idx);
    }

    public ArrayPair append(ArrayPair arrayPair) {
        Object newp = Array.newInstance(this.pctype, this.size + arrayPair.size);
        System.arraycopy(this.p, 0, newp, 0, this.size);
        System.arraycopy(arrayPair.p, 0, newp, this.size, arrayPair.size);
        Object newq = Array.newInstance(this.qctype, this.size + arrayPair.size);
        System.arraycopy(this.q, 0, newq, 0, this.size);
        System.arraycopy(arrayPair.q, 0, newq, this.size, arrayPair.size);
        return new ArrayPair(newp, newq);
    }

    public ArrayPair append(Object ap, Object aq, int length) {
        Object newp = Array.newInstance(this.pctype, this.size + length);
        System.arraycopy(this.p, 0, newp, 0, this.size);
        System.arraycopy(ap, 0, newp, this.size, length);
        Object newq = Array.newInstance(this.qctype, this.size + length);
        System.arraycopy(this.q, 0, newq, 0, this.size);
        System.arraycopy(aq, 0, newq, this.size, length);
        return new ArrayPair(newp, newq);
    }

    public ArrayPair copy() {
        try {
            return (ArrayPair)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

