/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtype;

import org.jplot2d.axtick.ArcDmsTickAlgorithm;
import org.jplot2d.axtick.TickAlgorithm;
import org.jplot2d.axtype.AxisType;
import org.jplot2d.transform.AxisTickTransform;
import org.jplot2d.transform.TransformType;
import org.jplot2d.util.Range;

public class DeclinationAxisType
extends AxisType {
    private static final Range DECLINATION_BOUNDARY = new Range.Double(-90.0, true, 90.0, true);

    public static DeclinationAxisType getInstance() {
        return new DeclinationAxisType();
    }

    private DeclinationAxisType() {
        super("DECLINATION");
    }

    @Override
    public boolean canSupport(TransformType txfType) {
        return txfType == TransformType.LINEAR;
    }

    @Override
    public TransformType getDefaultTransformType() {
        return TransformType.LINEAR;
    }

    @Override
    public Range getBoundary(TransformType txfType) {
        return DECLINATION_BOUNDARY;
    }

    @Override
    public Range getDefaultWorldRange(TransformType txfType) {
        return DECLINATION_BOUNDARY;
    }

    @Override
    public TickAlgorithm getTickAlgorithm(TransformType txfType, AxisTickTransform tickTransform) {
        if (tickTransform != null) {
            return null;
        }
        return ArcDmsTickAlgorithm.getInstance();
    }
}

