/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Formatter;
import org.jplot2d.axtick.TickUnitConverter;

public class TimeHmsFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private final TickUnitConverter tuf;
    private final int fraDigits;

    public TimeHmsFormat(int fraDigits) {
        this(TickUnitConverter.IDENTITY, fraDigits);
    }

    public TimeHmsFormat(TickUnitConverter tuf, int fraDigits) {
        this.tuf = tuf;
        this.fraDigits = fraDigits;
    }

    @Override
    public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number instanceof Number) {
            double v = this.tuf.convertD2T(((Number)number).doubleValue());
            return this.format(v, toAppendTo, pos);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    private StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        boolean negative = false;
        if (number < 0.0) {
            number = -number;
            negative = true;
        }
        int hour = (int)(number / 3600.0);
        int minute = (int)((number -= (double)(hour * 3600)) / 60.0);
        int second = (int)(number -= (double)(minute * 60));
        StringBuilder sb = new StringBuilder();
        new Formatter(sb).format("%." + this.fraDigits + "f", number -= (double)second);
        if (sb.charAt(0) == '1' && ++second == 60) {
            second = 0;
            if (++minute == 60) {
                minute = 0;
                ++hour;
            }
        }
        if (negative) {
            result.append('-');
        }
        Formatter foramtter = new Formatter(result);
        foramtter.format("%02d:%02d:%02d", hour, minute, second);
        if (this.fraDigits > 0) {
            result.append(sb, 1, sb.length());
        }
        return result;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeHmsFormat) {
            return this.fraDigits == ((TimeHmsFormat)obj).fraDigits;
        }
        return false;
    }
}

