/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.text.Format;
import org.jplot2d.axtick.DoubleTickCalculator;
import org.jplot2d.axtick.LinearTickAlgorithm;
import org.jplot2d.axtick.LinearTickCalculator;
import org.jplot2d.axtick.TickCalculator;

public class ReciprocalTickCalculator
extends DoubleTickCalculator {
    static final int LINEAR_MULIPLE_THRESHOLD = 2;
    protected double interval;
    protected int minorNumber;
    protected double[] tickValues;
    protected double[] minorValues;

    @Override
    protected void setRange(double start, double end) {
        super.setRange(start, end);
    }

    @Override
    public void calcValuesByTickNumber(int tickNumber, int minorTickNumber) {
        this.calcReciprocal(minorTickNumber);
        if (this.tickValues == null) {
            this.calcAsLinear(tickNumber, minorTickNumber);
        }
    }

    @Override
    public void calcValuesByTickInterval(double interval, double offset, int minorTickNumber) {
        this.calcReciprocal(minorTickNumber);
        if (this.tickValues == null) {
            this.calcAsLinear(interval, offset, minorTickNumber);
        }
    }

    private void calcReciprocal(int minorTickNumber) {
        double farv;
        double mf = 0.0;
        double absStart = Math.abs(this.start);
        double absEnd = Math.abs(this.end);
        if (Math.signum(this.start) == Math.signum(this.end)) {
            double d = mf = absStart > absEnd ? absStart / absEnd : absEnd / absStart;
            if (mf < 2.0) {
                this.tickValues = null;
                this.minorValues = null;
                return;
            }
            farv = absStart > absEnd ? this.end : this.start;
        } else {
            farv = Double.isNaN(this.start) ? this.end : (Double.isNaN(this.end) ? this.start : (absStart > absEnd ? this.end : this.start));
        }
        if (mf == 0.0 || mf > 4.0) {
            mf = 4.0;
        }
        LinearTickCalculator tc = LinearTickAlgorithm.getInstance().createCalculator();
        ((DoubleTickCalculator)tc).setRange(farv, farv * mf);
        ((TickCalculator)tc).calcValuesByTickNumber(3, minorTickNumber);
        this.minorNumber = ((TickCalculator)tc).getMinorNumber();
        this.tickValues = ((DoubleTickCalculator)tc).getValues();
        this.minorValues = ((DoubleTickCalculator)tc).getMinorValues();
    }

    private void calcAsLinear(int tickNumber, int minorTickNumber) {
        LinearTickCalculator tc = LinearTickAlgorithm.getInstance().createCalculator();
        ((DoubleTickCalculator)tc).setRange(this.start, this.end);
        ((TickCalculator)tc).calcValuesByTickNumber(tickNumber, minorTickNumber);
        this.minorNumber = ((TickCalculator)tc).getMinorNumber();
        this.tickValues = ((DoubleTickCalculator)tc).getValues();
        this.minorValues = ((DoubleTickCalculator)tc).getMinorValues();
    }

    private void calcAsLinear(double interval, double offset, int minorTickNumber) {
        LinearTickCalculator tc = LinearTickAlgorithm.getInstance().createCalculator();
        ((DoubleTickCalculator)tc).setRange(this.start, this.end);
        ((TickCalculator)tc).calcValuesByTickInterval(interval, offset, minorTickNumber);
        this.minorNumber = ((TickCalculator)tc).getMinorNumber();
        this.tickValues = ((DoubleTickCalculator)tc).getValues();
        this.minorValues = ((DoubleTickCalculator)tc).getMinorValues();
    }

    @Override
    public double getInterval() {
        return this.interval;
    }

    @Override
    public int getMinorNumber() {
        return this.minorNumber;
    }

    @Override
    public double[] getValues() {
        return this.tickValues;
    }

    @Override
    public double[] getMinorValues() {
        return this.minorValues;
    }

    @Override
    public Format calcLabelTextFormat(Object canonicalValues) {
        return null;
    }

    @Override
    public String getLabelFormate() {
        return this.calcLabelFormatString(this.getValues());
    }
}

