/*
 * Decompiled with CFR 0.152.
 */
package jyplot;

import java.util.ArrayList;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class BarXYDataset
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
DomainInfo,
RangeInfo,
DatasetChangeListener {
    private ArrayList xStart = new ArrayList();
    private ArrayList xEnd = new ArrayList();
    private ArrayList yStart = new ArrayList();
    private ArrayList yEnd = new ArrayList();
    private ArrayList seriesKeys = new ArrayList();

    @Override
    public Range getRangeBounds(boolean includeInterval) {
        double upper;
        double lower = this.getRangeLowerBound(includeInterval);
        if (lower <= (upper = this.getRangeUpperBound(includeInterval))) {
            return new Range(lower, upper);
        }
        return new Range(0.0, 1.0);
    }

    @Override
    public double getRangeLowerBound(boolean includeInterval) {
        double result = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.yEnd.size(); ++i) {
            for (int j = 0; j < ((Double[])this.yEnd.get(i)).length; ++j) {
                if (result == Double.POSITIVE_INFINITY) {
                    result = ((Double[])this.yStart.get(i))[j];
                }
                result = Math.min(result, Math.min(((Double[])this.yStart.get(i))[j], ((Double[])this.yEnd.get(i))[j]));
            }
        }
        return result;
    }

    @Override
    public double getRangeUpperBound(boolean includeInterval) {
        double result = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.yEnd.size(); ++i) {
            for (int j = 0; j < ((Double[])this.yEnd.get(i)).length; ++j) {
                if (result == Double.NEGATIVE_INFINITY) {
                    result = ((Double[])this.yStart.get(i))[j];
                }
                result = Math.max(result, Math.max(((Double[])this.yStart.get(i))[j], ((Double[])this.yEnd.get(i))[j]));
            }
        }
        return result;
    }

    @Override
    public Range getDomainBounds(boolean includeInterval) {
        double upper;
        double lower = this.getDomainLowerBound(includeInterval);
        if (lower <= (upper = this.getDomainUpperBound(includeInterval))) {
            return new Range(lower, upper);
        }
        return new Range(0.0, 1.0);
    }

    @Override
    public double getDomainLowerBound(boolean includeInterval) {
        double result = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.xEnd.size(); ++i) {
            for (int j = 0; j < ((Double[])this.xEnd.get(i)).length; ++j) {
                if (result == Double.POSITIVE_INFINITY) {
                    result = ((Double[])this.xStart.get(i))[j];
                }
                result = Math.min(result, Math.min(((Double[])this.xStart.get(i))[j], ((Double[])this.xEnd.get(i))[j]));
            }
        }
        return result;
    }

    @Override
    public double getDomainUpperBound(boolean includeInterval) {
        double result = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.xEnd.size(); ++i) {
            for (int j = 0; j < ((Double[])this.xEnd.get(i)).length; ++j) {
                if (result == Double.NEGATIVE_INFINITY) {
                    result = ((Double[])this.xStart.get(i))[j];
                }
                result = Math.max(result, Math.max(((Double[])this.xStart.get(i))[j], ((Double[])this.xEnd.get(i))[j]));
            }
        }
        return result;
    }

    public BarXYDataset() {
    }

    public BarXYDataset(double[] x, double[] y, double[] width, double[] height) {
        this();
        this.addSeries(x, y, width, height);
    }

    public void addSeries(double x, double y, double width, double height) {
        double[] _x = new double[]{x};
        double[] _y = new double[]{y};
        double[] _width = new double[]{width};
        double[] _height = new double[]{height};
        this.addSeries(_x, _y, _width, _height);
    }

    public BarXYDataset(double[] x, double[] y, double[] width, double[] height, Comparable seriesKey) {
        this();
        this.addSeries(x, y, width, height, seriesKey);
    }

    public void addSeries(double[] x, double[] y, double[] width, double[] height) {
        Integer key = new Integer(this.seriesKeys.size());
        this.addSeries(x, y, width, height, key);
    }

    public void addSeries(double[] x, double[] y, double[] width, double[] height, Comparable seriesKey) {
        if (x.length == y.length && x.length == width.length && x.length == height.length) {
            int i;
            Double[] _xStart = new Double[x.length];
            Double[] _yStart = new Double[y.length];
            Double[] _xEnd = new Double[width.length];
            Double[] _yEnd = new Double[height.length];
            for (i = 0; i < x.length; ++i) {
                _xStart[i] = new Double(x[i]);
            }
            for (i = 0; i < width.length; ++i) {
                _xEnd[i] = new Double(x[i] + width[i]);
            }
            for (i = 0; i < y.length; ++i) {
                _yStart[i] = new Double(y[i]);
            }
            for (i = 0; i < height.length; ++i) {
                _yEnd[i] = new Double(y[i] + height[i]);
            }
            this.xStart.add(_xStart);
            this.yStart.add(_yStart);
            this.xEnd.add(_xEnd);
            this.yEnd.add(_yEnd);
            this.seriesKeys.add(seriesKey);
        } else {
            System.err.println("BarXYDataset() args length not equal");
        }
    }

    @Override
    public int getSeriesCount() {
        return this.seriesKeys.size();
    }

    @Override
    public Comparable getSeriesKey(int series) {
        return (Comparable)this.seriesKeys.get(series);
    }

    public void setSeriesKey(int series, Comparable c) {
        this.seriesKeys.set(series, c);
    }

    @Override
    public int getItemCount(int series) {
        return ((Double[])this.xStart.get(series)).length;
    }

    @Override
    public Number getX(int series, int item) {
        return ((Double[])this.xStart.get(series))[item];
    }

    @Override
    public Number getY(int series, int item) {
        return ((Double[])this.yStart.get(series))[item];
    }

    @Override
    public Number getStartX(int series, int item) {
        return ((Double[])this.xStart.get(series))[item];
    }

    @Override
    public Number getEndX(int series, int item) {
        return ((Double[])this.xEnd.get(series))[item];
    }

    @Override
    public Number getStartY(int series, int item) {
        return ((Double[])this.yStart.get(series))[item];
    }

    @Override
    public Number getEndY(int series, int item) {
        return ((Double[])this.yEnd.get(series))[item];
    }

    @Override
    public double getEndXValue(int series, int item) {
        return ((Double[])this.xEnd.get(series))[item];
    }

    @Override
    public double getEndYValue(int series, int item) {
        return ((Double[])this.yEnd.get(series))[item];
    }

    @Override
    public double getStartXValue(int series, int item) {
        return ((Double[])this.xStart.get(series))[item];
    }

    @Override
    public double getStartYValue(int series, int item) {
        return ((Double[])this.yStart.get(series))[item];
    }

    @Override
    public double getXValue(int series, int item) {
        return ((Double[])this.xStart.get(series))[item];
    }

    @Override
    public double getYValue(int series, int item) {
        return ((Double[])this.yStart.get(series))[item];
    }

    @Override
    public int indexOf(Comparable arg0) {
        return this.seriesKeys.indexOf(arg0);
    }

    @Override
    public void datasetChanged(DatasetChangeEvent event) {
        this.notifyListeners(event);
    }

    public void removeSeries(int index) {
        if (index < this.seriesKeys.size() && index > -1) {
            this.seriesKeys.remove(index);
            this.xStart.remove(index);
            this.yStart.remove(index);
            this.xEnd.remove(index);
            this.yEnd.remove(index);
        }
    }
}

